/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token;

import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.serial.Serializable;

public record Mint(PublicKey address, PublicKey mintAuthority, long supply, int decimals, boolean initialized, PublicKey freezeAuthority) implements Serializable
{
    public static final int BYTES = 82;
    public static final BiFunction<PublicKey, byte[], Mint> FACTORY = Mint::read;

    public static Mint read(PublicKey address, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        boolean hasMintAuthority = ByteUtil.getInt32LE(data, 0) == 1;
        PublicKey mintAuthority = hasMintAuthority ? PublicKey.readPubKey(data, 4) : null;
        int i = 36;
        long supply = ByteUtil.getInt64LE(data, i);
        int decimals = data[i += 8] & 0xFF;
        boolean initialized = data[++i] == 1;
        boolean hasFreezeAuthority = ByteUtil.getInt32LE(data, ++i) == 1;
        PublicKey freezeAuthority = hasFreezeAuthority ? PublicKey.readPubKey(data, i += 4) : null;
        return new Mint(address, mintAuthority, supply, decimals, initialized, freezeAuthority);
    }

    @Override
    public int write(byte[] data, int offset) {
        if (this.mintAuthority != null) {
            ByteUtil.putInt32LE(data, 0, 1);
            this.mintAuthority.write(data, 4);
        }
        int i = 36;
        ByteUtil.putInt64LE(data, i, this.supply);
        data[i += 8] = (byte)this.decimals;
        data[++i] = (byte)(this.initialized ? 1 : 0);
        ++i;
        if (this.freezeAuthority != null) {
            ByteUtil.putInt32LE(data, i, 1);
            this.freezeAuthority.write(data, i + 4);
        }
        return 82;
    }

    @Override
    public int l() {
        return 82;
    }
}

