/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token;

import java.util.Map;
import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.Token2022;
import software.sava.core.accounts.token.TokenAccount;
import software.sava.core.accounts.token.extensions.AccountType;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.TokenExtension;
import software.sava.core.serial.Serializable;

public record Token2022Account(TokenAccount tokenAccount, AccountType type, Map<ExtensionType, TokenExtension> extensions) implements Serializable
{
    public static final BiFunction<PublicKey, byte[], Token2022Account> FACTORY = Token2022Account::read;

    public static Token2022Account read(PublicKey address, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        TokenAccount tokenAccount = TokenAccount.read(address, data);
        int i = tokenAccount.l();
        AccountType accountType = Token2022.parseAccountType(data, i);
        Map<ExtensionType, TokenExtension> extensions = Token2022.parseExtensions(data, ++i);
        return new Token2022Account(tokenAccount, accountType, extensions);
    }

    @Override
    public int l() {
        int l = this.tokenAccount.l() + this.extensions.size() * 4;
        for (TokenExtension extension : this.extensions.values()) {
            l += extension.l();
        }
        return l;
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset + this.tokenAccount.write(data, offset);
        for (TokenExtension extension : this.extensions.values()) {
            i += TokenExtension.write(extension, data, i);
        }
        return i - offset;
    }
}

