/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.AccountTokenExtension;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.encoding.ByteUtil;

public record ConfidentialTransferAccount(boolean approved, PublicKey elgamalPubkey, byte[] pendingBalanceLo, byte[] pendingBalanceHi, byte[] availableBalance, byte[] decryptableAvailableBalance, boolean allowConfidentialCredits, boolean allowNonConfidentialCredits, long pendingBalanceCreditCounter, long maximumPendingBalanceCreditCounter, long expectedPendingBalanceCreditCounter, long actualPendingBalanceCreditCounter) implements AccountTokenExtension
{
    public static final long MAXIMUM_DEPOSIT_TRANSFER_AMOUNT = 0xFFFFFFFFFFFFL;
    public static final int PENDING_BALANCE_LO_BIT_LENGTH = 16;
    public static final int DEFAULT_MAXIMUM_PENDING_BALANCE_CREDIT_COUNTER = 65536;
    public static final int BYTES = 295;

    public static ConfidentialTransferAccount read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        boolean approved = data[offset] == 1;
        int i = offset + 1;
        PublicKey elgamalPubkey = PublicKey.readPubKey(data, i);
        byte[] pendingBalanceLo = new byte[64];
        System.arraycopy(data, i += 32, pendingBalanceLo, 0, pendingBalanceLo.length);
        byte[] pendingBalanceHi = new byte[64];
        System.arraycopy(data, i += pendingBalanceLo.length, pendingBalanceHi, 0, pendingBalanceHi.length);
        byte[] availableBalance = new byte[64];
        System.arraycopy(data, i += pendingBalanceHi.length, availableBalance, 0, availableBalance.length);
        byte[] decryptableAvailableBalance = new byte[36];
        System.arraycopy(data, i += availableBalance.length, decryptableAvailableBalance, 0, decryptableAvailableBalance.length);
        boolean allowConfidentialCredits = data[i += decryptableAvailableBalance.length] == 1;
        boolean allowNonConfidentialCredits = data[++i] == 1;
        long pendingBalanceCreditCounter = ByteUtil.getInt64LE(data, ++i);
        long maximumPendingBalanceCreditCounter = ByteUtil.getInt64LE(data, i += 8);
        long expectedPendingBalanceCreditCounter = ByteUtil.getInt64LE(data, i += 8);
        long actualPendingBalanceCreditCounter = ByteUtil.getInt64LE(data, i += 8);
        return new ConfidentialTransferAccount(approved, elgamalPubkey, pendingBalanceLo, pendingBalanceHi, availableBalance, decryptableAvailableBalance, allowConfidentialCredits, allowNonConfidentialCredits, pendingBalanceCreditCounter, maximumPendingBalanceCreditCounter, expectedPendingBalanceCreditCounter, actualPendingBalanceCreditCounter);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.ConfidentialTransferAccount;
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset;
        data[i] = (byte)(this.approved ? 1 : 0);
        System.arraycopy(this.pendingBalanceLo, 0, data, ++i, this.pendingBalanceLo.length);
        System.arraycopy(this.pendingBalanceHi, 0, data, i += this.pendingBalanceLo.length, this.pendingBalanceHi.length);
        System.arraycopy(this.availableBalance, 0, data, i += this.pendingBalanceHi.length, this.availableBalance.length);
        System.arraycopy(this.decryptableAvailableBalance, 0, data, i += this.availableBalance.length, this.decryptableAvailableBalance.length);
        data[i += this.decryptableAvailableBalance.length] = (byte)(this.allowConfidentialCredits ? 1 : 0);
        data[++i] = (byte)(this.allowNonConfidentialCredits ? 1 : 0);
        ByteUtil.putInt64LE(data, ++i, this.pendingBalanceCreditCounter);
        ByteUtil.putInt64LE(data, i += 8, this.maximumPendingBalanceCreditCounter);
        ByteUtil.putInt64LE(data, i += 8, this.expectedPendingBalanceCreditCounter);
        ByteUtil.putInt64LE(data, i += 8, this.actualPendingBalanceCreditCounter);
        return 295;
    }

    @Override
    public int l() {
        return 295;
    }
}

