/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record ConfidentialTransferFeeAmount(byte[] withheldAmount) implements MintTokenExtension
{
    public static ConfidentialTransferFeeAmount read(byte[] data, int offset, int to) {
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] withheldAmount = new byte[to - offset];
        System.arraycopy(data, offset, withheldAmount, 0, withheldAmount.length);
        return new ConfidentialTransferFeeAmount(withheldAmount);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.ConfidentialTransferFeeAmount;
    }

    @Override
    public int l() {
        return this.withheldAmount.length;
    }

    @Override
    public int write(byte[] data, int offset) {
        System.arraycopy(this.withheldAmount, 0, data, offset, this.withheldAmount.length);
        return this.withheldAmount.length;
    }
}

