/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record ConfidentialTransferMint(PublicKey authority, boolean autoApproveNewAccounts, PublicKey auditorElGamalKey) implements MintTokenExtension
{
    public static final int BYTES = 65;

    public static ConfidentialTransferMint read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        boolean autoApproveNewAccounts = data[offset + 32] == 1;
        PublicKey auditorElGamalKey = PublicKey.readPubKey(data, offset + 32 + 1);
        return new ConfidentialTransferMint(authority, autoApproveNewAccounts, auditorElGamalKey);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.ConfidentialTransferMint;
    }

    @Override
    public int l() {
        return 65;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        data[offset + 32] = (byte)(this.autoApproveNewAccounts ? 1 : 0);
        this.auditorElGamalKey.write(data, offset + 32 + 1);
        return 65;
    }
}

