/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record GroupMemberPointer(PublicKey authority, PublicKey memberAddress) implements MintTokenExtension
{
    public static final int BYTES = 64;

    public static GroupMemberPointer read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        PublicKey memberAddress = PublicKey.readPubKey(data, offset + 32);
        return new GroupMemberPointer(authority, memberAddress);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.GroupMemberPointer;
    }

    @Override
    public int l() {
        return 64;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        this.memberAddress.write(data, offset + 32);
        return 64;
    }
}

