/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record GroupPointer(PublicKey authority, PublicKey groupAddress) implements MintTokenExtension
{
    public static final int BYTES = 64;

    public static GroupPointer read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        PublicKey groupAddress = PublicKey.readPubKey(data, offset + 32);
        return new GroupPointer(authority, groupAddress);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.GroupPointer;
    }

    @Override
    public int l() {
        return 64;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        this.groupAddress.write(data, offset + 32);
        return 64;
    }
}

