/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;
import software.sava.core.encoding.ByteUtil;

public record InterestBearingConfig(PublicKey rateAuthority, long unixTimestamp, int preUpdateAverageRate, long lastUpdateTimestamp, int currentRate) implements MintTokenExtension
{
    public static final int BYTES = 52;

    public static InterestBearingConfig read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey rateAuthority = PublicKey.readPubKey(data, offset);
        int i = offset + 32;
        long unixTimestamp = ByteUtil.getInt64LE(data, i);
        short preUpdateAverageRate = ByteUtil.getInt16LE(data, i += 8);
        long lastUpdateTimestamp = ByteUtil.getInt64LE(data, i += 2);
        short currentRate = ByteUtil.getInt16LE(data, i += 8);
        return new InterestBearingConfig(rateAuthority, unixTimestamp, preUpdateAverageRate, lastUpdateTimestamp, currentRate);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.InterestBearingConfig;
    }

    @Override
    public int l() {
        return 52;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.rateAuthority.write(data, offset);
        int i = offset + 32;
        ByteUtil.putInt64LE(data, i, this.unixTimestamp);
        ByteUtil.putInt16LE(data, i += 8, this.preUpdateAverageRate);
        ByteUtil.putInt64LE(data, i += 2, this.lastUpdateTimestamp);
        ByteUtil.putInt16LE(data, i += 8, this.currentRate);
        return 52;
    }
}

