/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record MetadataPointer(PublicKey authority, PublicKey metadataAddress) implements MintTokenExtension
{
    public static final int BYTES = 64;

    public static MetadataPointer read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        PublicKey metadataAddress = PublicKey.readPubKey(data, offset + 32);
        return new MetadataPointer(authority, metadataAddress);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.MetadataPointer;
    }

    @Override
    public int l() {
        return 64;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        this.metadataAddress.write(data, offset + 32);
        return 64;
    }
}

