/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record PausableConfig(PublicKey authority, boolean paused) implements MintTokenExtension
{
    public static final int BYTES = 33;

    public static PausableConfig read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        boolean paused = data[offset + 32] == 1;
        return new PausableConfig(authority, paused);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.Pausable;
    }

    @Override
    public int l() {
        return 33;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        data[offset + 32] = (byte)(this.paused ? 1 : 0);
        return 33;
    }
}

