/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.encoding.ByteUtil;
import software.sava.core.serial.Serializable;

public record TransferFee(long epoch, long maximumFee, int transferFeeBasisPoints) implements Serializable
{
    public static final int BYTES = 18;

    public static TransferFee read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        long epoch = ByteUtil.getInt64LE(data, i);
        long maximumFee = ByteUtil.getInt64LE(data, i += 8);
        short transferFeeBasisPoints = ByteUtil.getInt16LE(data, i += 8);
        return new TransferFee(epoch, maximumFee, transferFeeBasisPoints);
    }

    @Override
    public int l() {
        return 18;
    }

    @Override
    public int write(byte[] data, int offset) {
        ByteUtil.putInt64LE(data, offset, this.epoch);
        ByteUtil.putInt64LE(data, offset + 8, this.maximumFee);
        ByteUtil.putInt16LE(data, offset + 8 + 8, this.transferFeeBasisPoints);
        return 18;
    }
}

