/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;
import software.sava.core.encoding.ByteUtil;

public record TransferFeeAmount(long withHeldAmount) implements MintTokenExtension
{
    public static final int BYTES = 8;

    public static TransferFeeAmount read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        long withheldAmount = ByteUtil.getInt64LE(data, offset);
        return new TransferFeeAmount(withheldAmount);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.TransferFeeAmount;
    }

    @Override
    public int l() {
        return 8;
    }

    @Override
    public int write(byte[] data, int offset) {
        ByteUtil.putInt64LE(data, offset, this.withHeldAmount);
        return 8;
    }
}

