/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.Signer;
import software.sava.core.accounts.vanity.AddressWorker;
import software.sava.core.accounts.vanity.PrivateKeyEncoding;
import software.sava.core.accounts.vanity.Result;
import software.sava.core.accounts.vanity.Subsequence;
import software.sava.core.crypto.Hash;
import software.sava.core.crypto.ed25519.Ed25519Util;
import software.sava.core.encoding.Base58;

abstract class BaseMaskWorker
implements AddressWorker {
    static final LongBinaryOperator SUM = Long::sum;
    private final Path keyPath;
    private final SecureRandom secureRandom;
    private final PrivateKeyEncoding privateKeyEncoding;
    private final boolean sigVerify;
    private final Subsequence beginsWith;
    private final long find;
    private final AtomicInteger found;
    protected final AtomicLong searched;
    private final Queue<Result> results;
    protected final int checkFound;
    private final MessageDigest digest = Hash.sha512Digest();
    private final byte[] privateKey;
    private final byte[] publicKey;
    protected final char[] encoded;
    private final byte[] mutableKeyPair;
    protected final byte[] mutablePublicKey;
    protected static final byte[] VERIFY_MSG = "sava".getBytes();

    protected BaseMaskWorker(Path keyPath, SecureRandom secureRandom, PrivateKeyEncoding privateKeyEncoding, boolean sigVerify, Subsequence beginsWith, long find, AtomicInteger found, AtomicLong searched, Queue<Result> results, int checkFound) {
        this.keyPath = keyPath;
        this.secureRandom = secureRandom;
        this.privateKeyEncoding = privateKeyEncoding;
        this.sigVerify = sigVerify;
        this.beginsWith = beginsWith;
        this.find = find;
        this.found = found;
        this.searched = searched;
        this.results = results;
        this.checkFound = checkFound;
        this.privateKey = new byte[32];
        this.publicKey = new byte[32];
        this.encoded = new char[64];
        this.mutableKeyPair = new byte[64];
        this.mutablePublicKey = new byte[32];
    }

    @Override
    public final SecureRandom secureRandom() {
        return this.secureRandom;
    }

    @Override
    public final Subsequence beginsWith() {
        return this.beginsWith;
    }

    @Override
    public final long find() {
        return this.find;
    }

    @Override
    public final AtomicInteger found() {
        return this.found;
    }

    @Override
    public final AtomicLong searched() {
        return this.searched;
    }

    @Override
    public final Queue<Result> results() {
        return this.results;
    }

    protected final boolean queueResult(long timeStart, int keyStart) {
        if (this.beginsWith == null || this.beginsWith.contains(this.encoded, keyStart)) {
            PublicKey publicKey;
            long end = System.currentTimeMillis();
            byte[] keyPair = new byte[64];
            System.arraycopy(this.privateKey, 0, keyPair, 0, 32);
            System.arraycopy(this.publicKey, 0, keyPair, 32, 32);
            if (this.sigVerify) {
                Signer signer = Signer.createFromKeyPair(keyPair);
                byte[] sig = signer.sign(VERIFY_MSG);
                publicKey = signer.publicKey();
                if (!publicKey.verifySignature(VERIFY_MSG, sig)) {
                    throw new IllegalStateException("Invalid signature for key pair " + Base64.getEncoder().encodeToString(keyPair));
                }
                java.security.PublicKey javaPublicKey = publicKey.toJavaPublicKey();
                if (!PublicKey.verifySignature(javaPublicKey, VERIFY_MSG, sig)) {
                    throw new IllegalStateException("Failed to verify signature using a Java PublicKey for key pair " + Base64.getEncoder().encodeToString(keyPair));
                }
            } else {
                Signer.validateKeyPair(keyPair);
                publicKey = PublicKey.readPubKey(keyPair, 32);
            }
            Result result = new Result(publicKey, keyPair, end - timeStart);
            if (this.keyPath != null) {
                try {
                    String formattedKey = switch (this.privateKeyEncoding) {
                        default -> throw new MatchException(null, null);
                        case PrivateKeyEncoding.jsonKeyPairArray -> {
                            StringBuilder json = new StringBuilder("[");
                            int i = 0;
                            while (true) {
                                json.append(Byte.toUnsignedInt(keyPair[i]));
                                if (++i == keyPair.length) break;
                                json.append(',');
                            }
                            json.append(']');
                            yield json.toString();
                        }
                        case PrivateKeyEncoding.base64PrivateKey -> "\"" + Base64.getEncoder().encodeToString(this.privateKey) + "\"";
                        case PrivateKeyEncoding.base64KeyPair -> "\"" + Base64.getEncoder().encodeToString(keyPair) + "\"";
                        case PrivateKeyEncoding.base58PrivateKey -> "\"" + Base58.encode(this.privateKey) + "\"";
                        case PrivateKeyEncoding.base58KeyPair -> "\"" + Base58.encode(keyPair) + "\"";
                    };
                    Files.writeString(this.keyPath.resolve(publicKey.toBase58() + ".json"), (CharSequence)String.format("{\n  \"pubKey\": \"%s\",\n  \"encoding\": \"%s\",\n  \"secret\": %s\n}", new Object[]{publicKey, this.privateKeyEncoding, formattedKey}), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            this.results.add(result);
            this.found.incrementAndGet();
            return true;
        }
        return false;
    }

    protected final void generateKeyPair() {
        this.secureRandom.nextBytes(this.privateKey);
        Ed25519Util.generatePublicKey(this.digest, this.privateKey, 0, this.publicKey, 0, this.mutablePublicKey, this.mutableKeyPair);
        System.arraycopy(this.publicKey, 0, this.mutablePublicKey, 0, 32);
    }

    protected final boolean foundLimitOrInterrupted() {
        if ((long)this.found.getOpaque() >= this.find || Thread.currentThread().isInterrupted()) {
            return true;
        }
        this.searched.getAndAccumulate(this.checkFound, SUM);
        return false;
    }

    protected final boolean foundHitLimitOrInterrupted() {
        return (long)this.found.get() >= this.find || Thread.currentThread().isInterrupted();
    }
}

