/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import software.sava.core.accounts.vanity.BaseMaskWorker;
import software.sava.core.accounts.vanity.PrivateKeyEncoding;
import software.sava.core.accounts.vanity.Result;
import software.sava.core.accounts.vanity.Subsequence;
import software.sava.core.encoding.Base58;

final class BeginsWithMaskWorker
extends BaseMaskWorker {
    BeginsWithMaskWorker(Path keyPath, SecureRandom secureRandom, PrivateKeyEncoding privateKeyEncoding, boolean sigVerify, Subsequence beginsWith, long find, AtomicInteger found, AtomicLong searched, Queue<Result> results, int checkFound) {
        super(keyPath, secureRandom, privateKeyEncoding, sigVerify, beginsWith, find, found, searched, results, checkFound);
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        int i = 0;
        while (true) {
            this.generateKeyPair();
            int keyStart = Base58.mutableEncode(this.mutablePublicKey, this.encoded);
            if (this.queueResult(start, keyStart)) {
                this.searched.getAndAccumulate(i, SUM);
                if (this.foundHitLimitOrInterrupted()) {
                    return;
                }
                i = 0;
                start = System.currentTimeMillis();
                continue;
            }
            if (++i != this.checkFound) continue;
            if (this.foundLimitOrInterrupted()) {
                return;
            }
            this.searched.getAndAccumulate(i, SUM);
            i = 0;
        }
    }
}

