/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import software.sava.core.accounts.vanity.Result;
import software.sava.core.accounts.vanity.VanityAddressGenerator;

final class ConcurrentVanityAddressGenerator
implements VanityAddressGenerator {
    private final long findKeys;
    private final BlockingQueue<Result> results;
    private final AtomicInteger found;
    private final AtomicLong searched;

    ConcurrentVanityAddressGenerator(long findKeys, BlockingQueue<Result> results, AtomicInteger found, AtomicLong searched) {
        this.findKeys = findKeys;
        this.results = results;
        this.found = found;
        this.searched = searched;
    }

    @Override
    public int numFound() {
        return this.found.get();
    }

    @Override
    public long numSearched() {
        return this.searched.get();
    }

    @Override
    public void breakOut() {
        this.found.set(Integer.MAX_VALUE);
    }

    @Override
    public Result take() throws InterruptedException {
        return this.results.isEmpty() ? null : this.results.take();
    }

    @Override
    public Result poll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if ((long)this.found.get() >= this.findKeys) {
            return this.results.isEmpty() ? null : this.results.poll(timeout, timeUnit);
        }
        return this.results.poll(timeout, timeUnit);
    }
}

