/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import software.sava.core.accounts.vanity.BaseMaskWorker;
import software.sava.core.accounts.vanity.PrivateKeyEncoding;
import software.sava.core.accounts.vanity.Result;
import software.sava.core.accounts.vanity.Subsequence;
import software.sava.core.encoding.Base58;

final class MaskWorker
extends BaseMaskWorker {
    private final Subsequence endsWith;

    MaskWorker(Path keyPath, SecureRandom secureRandom, PrivateKeyEncoding privateKeyEncoding, boolean sigVerify, Subsequence beginsWith, Subsequence endsWith, long find, AtomicInteger found, AtomicLong searched, Queue<Result> results, int checkFound) {
        super(keyPath, secureRandom, privateKeyEncoding, sigVerify, beginsWith, find, found, searched, results, checkFound);
        this.endsWith = endsWith;
    }

    @Override
    public void run() {
        int endLength = this.endsWith.length();
        char[] shortEncoded = new char[endLength << 1];
        int shortStart = shortEncoded.length - endLength;
        long start = System.currentTimeMillis();
        int i = 0;
        while (true) {
            int shortEncodedLen;
            int encodedStart;
            int keyStart;
            this.generateKeyPair();
            long fastEncodeOffsets = Base58.beginMutableEncode(this.mutablePublicKey, endLength, shortEncoded);
            int shortKeyStart = (int)fastEncodeOffsets;
            if (this.endsWith.contains(shortEncoded, shortStart) && this.queueResult(start, keyStart = Base58.continueMutableEncode(this.mutablePublicKey, (int)(fastEncodeOffsets >>> 48), (int)(fastEncodeOffsets >>> 32) & 0xFFFF, encodedStart = this.encoded.length - (shortEncodedLen = shortEncoded.length - shortKeyStart), this.encoded))) {
                this.searched.getAndAccumulate(i, SUM);
                if (this.foundHitLimitOrInterrupted()) {
                    return;
                }
                i = 0;
                start = System.currentTimeMillis();
                continue;
            }
            if (++i != this.checkFound) continue;
            if (this.foundLimitOrInterrupted()) {
                return;
            }
            this.searched.getAndAccumulate(i, SUM);
            i = 0;
        }
    }
}

