/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.util.Arrays;
import software.sava.core.accounts.vanity.Subsequence;
import software.sava.core.encoding.Base58;

record SubsequenceRecord(String subsequence, int length, boolean caseSensitive, boolean _1337Numbers, boolean _1337Letters, long[] masks) implements Subsequence
{
    static long[] generateMasks(char[][] findChars) {
        int numMasks = 0;
        char[] base = findChars[0];
        numMasks = findChars.length == 1 ? base.length : (numMasks += base.length * SubsequenceRecord.countMasks(findChars, 1));
        long[] masks = new long[numMasks];
        numMasks = 0;
        if (findChars.length == 1) {
            char[] cArray = base;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                long c = cArray[i];
                masks[numMasks++] = c;
            }
        } else {
            int shift = (findChars.length - 1) * 8;
            char[] cArray = base;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                long c = cArray[i];
                numMasks += SubsequenceRecord.createMasks(findChars, 1, c << shift, numMasks, masks);
            }
        }
        return masks;
    }

    static int countMasks(char[][] findChars, int depth) {
        int nextDepth = depth + 1;
        if (nextDepth == findChars.length) {
            return findChars[depth].length;
        }
        return findChars[depth].length * SubsequenceRecord.countMasks(findChars, nextDepth);
    }

    static int createMasks(char[][] findChars, int depth, long parentMask, int i, long[] masks) {
        int nextDepth = depth + 1;
        if (nextDepth == findChars.length) {
            char[] options;
            char[] cArray = options = findChars[depth];
            int n = cArray.length;
            for (int j = 0; j < n; ++j) {
                long c = cArray[j];
                masks[i++] = parentMask | c;
            }
            return options.length;
        }
        int shift = (findChars.length - nextDepth) * 8;
        int numMasks = 0;
        char[] cArray = findChars[depth];
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            long c = cArray[j];
            int nm = SubsequenceRecord.createMasks(findChars, nextDepth, parentMask | c << shift, i, masks);
            i += nm;
            numMasks += nm;
        }
        return numMasks;
    }

    static char[][] generateCharOptions(String find, boolean caseSensitive, boolean _1337Numbers, boolean _1337Letters) {
        char[][] findChars = new char[find.length()][];
        char[] storage = new char[3];
        for (int i = 0; i < findChars.length; ++i) {
            findChars[i] = SubsequenceRecord.getCharOptions(storage, find.charAt(i), caseSensitive, _1337Numbers, _1337Letters);
        }
        return findChars;
    }

    private static char[] getCharOptions(char[] storage, char c, boolean caseSensitive, boolean _1337Numbers, boolean _1337Letters) {
        int i = 0;
        if (Character.isAlphabetic(c)) {
            if (caseSensitive) {
                storage[i++] = c;
            } else {
                char upper;
                char lower = Character.toLowerCase(c);
                if (Base58.isBase58(lower)) {
                    storage[i++] = lower;
                }
                if (Base58.isBase58(upper = Character.toUpperCase(c))) {
                    storage[i++] = upper;
                }
            }
            if (_1337Letters) {
                switch (c) {
                    case 'A': 
                    case 'a': {
                        storage[i++] = 52;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        storage[i++] = 56;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        storage[i++] = 51;
                        break;
                    }
                    case 'G': {
                        storage[i++] = 54;
                        break;
                    }
                    case 'g': {
                        storage[i++] = 57;
                        break;
                    }
                    case 'L': 
                    case 'i': {
                        storage[i++] = 49;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        storage[i++] = 53;
                        break;
                    }
                    case 'T': {
                        storage[i++] = 55;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        storage[i++] = 50;
                    }
                }
            }
        } else {
            storage[i++] = c;
            if (_1337Numbers) {
                switch (c) {
                    case '1': {
                        storage[i++] = 76;
                        break;
                    }
                    case '2': {
                        storage[i++] = 90;
                        break;
                    }
                    case '3': {
                        storage[i++] = 69;
                        break;
                    }
                    case '4': {
                        storage[i++] = 65;
                        break;
                    }
                    case '5': {
                        storage[i++] = 83;
                        break;
                    }
                    case '6': {
                        storage[i++] = 71;
                        break;
                    }
                    case '7': {
                        storage[i++] = 84;
                        break;
                    }
                    case '8': {
                        storage[i++] = 66;
                        break;
                    }
                    case '9': {
                        storage[i++] = 103;
                    }
                }
            }
        }
        return Arrays.copyOfRange(storage, 0, i);
    }

    @Override
    public boolean contains(char[] encoded, int from) {
        int i = from + this.length;
        long mask = encoded[--i];
        int shift = 8;
        while (i > from) {
            mask |= (long)encoded[--i] << shift;
            shift += 8;
        }
        return Arrays.binarySearch(this.masks, mask) >= 0;
    }

    @Override
    public int numCombinations() {
        return this.masks.length;
    }
}

