/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import software.sava.core.accounts.vanity.BaseMaskWorker;
import software.sava.core.accounts.vanity.BeginsWithMaskWorker;
import software.sava.core.accounts.vanity.ConcurrentVanityAddressGenerator;
import software.sava.core.accounts.vanity.MaskWorker;
import software.sava.core.accounts.vanity.PrivateKeyEncoding;
import software.sava.core.accounts.vanity.Result;
import software.sava.core.accounts.vanity.SecureRandomFactory;
import software.sava.core.accounts.vanity.Subsequence;

public interface VanityAddressGenerator {
    public static VanityAddressGenerator createGenerator(Path keyPath, SecureRandomFactory secureRandomFactory, PrivateKeyEncoding privateKeyEncoding, boolean sigVerify, ExecutorService executor, int numThreads, Subsequence beginsWith, Subsequence endsWith, long findKeys, int checkFound) {
        if (findKeys > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max find keys is 2147483647");
        }
        try {
            AtomicInteger found = new AtomicInteger(0);
            AtomicLong searched = new AtomicLong(0L);
            ArrayBlockingQueue<Result> results = new ArrayBlockingQueue<Result>(checkFound * numThreads);
            for (int i = 0; i < numThreads; ++i) {
                SecureRandom secureRandom = secureRandomFactory.createSecureRandom();
                BaseMaskWorker worker = endsWith == null ? new BeginsWithMaskWorker(keyPath, secureRandom, privateKeyEncoding, sigVerify, beginsWith, findKeys, found, searched, results, checkFound) : new MaskWorker(keyPath, secureRandom, privateKeyEncoding, sigVerify, beginsWith, endsWith, findKeys, found, searched, results, checkFound);
                executor.execute(worker);
            }
            return new ConcurrentVanityAddressGenerator(findKeys, results, found, searched);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static VanityAddressGenerator createGenerator(Path keyPath, PrivateKeyEncoding privateKeyEncoding, boolean sigVerify, ExecutorService executor, int numThreads, Subsequence beginsWith, Subsequence endsWith, long findKeys, int checkFound) {
        return VanityAddressGenerator.createGenerator(keyPath, SecureRandomFactory.DEFAULT, privateKeyEncoding, sigVerify, executor, numThreads, beginsWith, endsWith, findKeys, checkFound);
    }

    public int numFound();

    public long numSearched();

    public void breakOut();

    public Result take() throws InterruptedException;

    public Result poll(long var1, TimeUnit var3) throws InterruptedException;
}

