/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.borsh;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.serial.Serializable;

public interface Borsh
extends Serializable {
    default public byte[] writeOptional() {
        byte[] data = new byte[1 + this.l()];
        data[0] = 1;
        this.write(data, 1);
        return data;
    }

    public static String readString(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        return new String(data, offset + 4, len, StandardCharsets.UTF_8);
    }

    public static String string(byte[] data, int offset) {
        return Borsh.readString(data, offset);
    }

    public static byte[] getBytes(String str) {
        return str == null || str.isBlank() ? null : str.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[][] getBytes(String[] strings) {
        int len = strings.length;
        byte[][] bytes = new byte[len][];
        for (int i = 0; i < len; ++i) {
            bytes[i] = Borsh.getBytes(strings[i]);
        }
        return bytes;
    }

    public static int len(String val) {
        int len = val.getBytes(StandardCharsets.UTF_8).length;
        return 4 + len;
    }

    public static int lenOptional(String val) {
        return val == null ? 1 : 1 + Borsh.len(val);
    }

    public static int lenVector(String[] array) {
        int len = 4;
        for (String s : array) {
            len += Borsh.len(s);
        }
        return len;
    }

    public static int lenVector(String[][] array) {
        int len = 4;
        for (String[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int readArray(String[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            String s;
            int len = ByteUtil.getInt32LE(data, o);
            result[i] = s = new String(data, o += 4, len, StandardCharsets.UTF_8);
            o += len;
        }
        return o - offset;
    }

    public static int readArray(String[][] result, byte[] data, int offset) {
        int i = offset;
        for (String[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static String[] readStringVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        String[] result = new String[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static String[][] readMultiDimensionStringVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        String[][] result = new String[len][];
        for (int i = 0; i < result.length; ++i) {
            String[] instance = Borsh.readStringVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static String[][] readMultiDimensionStringVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        String[][] result = new String[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int write(String str, byte[] data, int offset) {
        return Borsh.writeVector(str.getBytes(StandardCharsets.UTF_8), data, offset);
    }

    public static int writeArray(String[] array, byte[] data, int offset) {
        int i = offset;
        for (String a : array) {
            i += Borsh.write(a, data, i);
        }
        return i - offset;
    }

    private static IllegalArgumentException invalidArrayLength(Object type, int expectedLength, int actualLength) {
        return new IllegalArgumentException(String.format("%s.length must be %d, not %d.", type.getClass().getSimpleName(), expectedLength, actualLength));
    }

    public static int writeArrayChecked(String[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(String[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(String[][] array, byte[] data, int offset) {
        int i = offset;
        for (String[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(String[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (String[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(String[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (String[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(String[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (String[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(String[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(String[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int readArray(byte[] result, byte[] data, int offset) {
        System.arraycopy(data, offset, result, 0, result.length);
        return result.length;
    }

    public static byte[] readbyteVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        byte[] result = new byte[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int readArray(byte[][] result, byte[] data, int offset) {
        int i = offset;
        for (byte[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static byte[][] readMultiDimensionbyteVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        byte[][] result = new byte[len][];
        for (int i = 0; i < result.length; ++i) {
            byte[] instance = Borsh.readbyteVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static byte[][] readMultiDimensionbyteVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        byte[][] result = new byte[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptionalbyte(OptionalInt val, byte[] data, int offset) {
        if (val == null || val.isEmpty()) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        data[offset + 1] = (byte)val.getAsInt();
        return 2;
    }

    public static int writeOptional(Byte val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        data[offset + 1] = val;
        return 2;
    }

    public static int writeArray(byte[] array, byte[] data, int offset) {
        System.arraycopy(array, 0, data, offset, array.length);
        return array.length;
    }

    public static int writeArrayChecked(byte[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(byte[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeOptionalArray(byte[] bytes, byte[] data, int offset) {
        if (bytes == null || bytes.length == 0) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        return 1 + Borsh.writeArray(bytes, data, offset + 1);
    }

    public static int writeOptionalVector(byte[] bytes, byte[] data, int offset) {
        if (bytes == null || bytes.length == 0) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        return 1 + Borsh.writeVector(bytes, data, offset + 1);
    }

    public static int writeArray(byte[][] array, byte[] data, int offset) {
        int i = offset;
        for (byte[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(byte[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (byte[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(byte[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (byte[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(byte[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (byte[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(byte[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(byte[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(Byte val) {
        return val == null ? 1 : 2;
    }

    public static int lenOptionalbyte(OptionalInt val) {
        return val == null || val.isEmpty() ? 1 : 2;
    }

    public static int lenArray(byte[] array) {
        return array.length;
    }

    public static int lenVector(byte[] array) {
        return 4 + array.length;
    }

    public static int lenOptionalVector(byte[] array) {
        if (array == null || array.length == 0) {
            return 1;
        }
        return 1 + Borsh.lenVector(array);
    }

    public static int lenArray(byte[][] array) {
        int len = 0;
        for (byte[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(byte[][] array) {
        int len = 4;
        for (byte[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(byte[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int readArray(boolean[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[o++] == 1;
        }
        return o - offset;
    }

    public static int readArray(boolean[][] result, byte[] data, int offset) {
        int i = offset;
        for (boolean[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static boolean[] readbooleanVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        boolean[] result = new boolean[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static boolean[][] readMultiDimensionbooleanVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        boolean[][] result = new boolean[len][];
        for (int i = 0; i < result.length; ++i) {
            boolean[] instance = Borsh.readbooleanVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static boolean[][] readMultiDimensionbooleanVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        boolean[][] result = new boolean[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int write(boolean val, byte[] data, int offset) {
        data[offset] = (byte)(val ? 1 : 0);
        return 1;
    }

    public static int writeOptional(Boolean val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        Borsh.write(val, data, offset + 1);
        return 2;
    }

    public static int writeArray(boolean[] array, byte[] data, int offset) {
        int i = offset;
        for (boolean a : array) {
            i += Borsh.write(a, data, i);
        }
        return array.length;
    }

    public static int writeArrayChecked(boolean[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(boolean[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(boolean[][] array, byte[] data, int offset) {
        int i = offset;
        for (boolean[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(boolean[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (boolean[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(boolean[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (boolean[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(boolean[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (boolean[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(boolean[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(boolean[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(Boolean val) {
        return val == null ? 1 : 2;
    }

    public static int lenArray(boolean[] array) {
        return array.length;
    }

    public static int lenVector(boolean[] array) {
        return 4 + array.length;
    }

    public static int lenArray(boolean[][] array) {
        int len = 0;
        for (boolean[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(boolean[][] array) {
        int len = 4;
        for (boolean[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(boolean[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int readArray(short[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getInt16LE(data, o);
            o += 2;
        }
        return o - offset;
    }

    public static int readArray(short[][] result, byte[] data, int offset) {
        int i = offset;
        for (short[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static short[] readshortVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        short[] result = new short[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static short[][] readMultiDimensionshortVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        short[][] result = new short[len][];
        for (int i = 0; i < result.length; ++i) {
            short[] instance = Borsh.readshortVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static short[][] readMultiDimensionshortVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        short[][] result = new short[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptionalshort(OptionalInt val, byte[] data, int offset) {
        if (val == null || val.isEmpty()) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putInt16LE(data, offset + 1, (short)val.getAsInt());
        return 3;
    }

    public static int writeOptional(Short val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putInt16LE(data, offset + 1, val);
        return 3;
    }

    public static int writeArray(short[] array, byte[] data, int offset) {
        int i = offset;
        for (short a : array) {
            ByteUtil.putInt16LE(data, i, a);
            i += 2;
        }
        return i - offset;
    }

    public static int writeArrayChecked(short[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(short[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArrayChecked(short[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (short[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(short[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (short[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeArray(short[][] array, byte[] data, int offset) {
        int i = offset;
        for (short[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeVector(short[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (short[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(short[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(short[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(Short val) {
        return val == null ? 1 : 3;
    }

    public static int lenOptionalshort(OptionalInt val) {
        return val == null || val.isEmpty() ? 1 : 3;
    }

    public static int lenArray(short[] array) {
        return array.length * 2;
    }

    public static int lenVector(short[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenArray(short[][] array) {
        int len = 0;
        for (short[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(short[][] array) {
        int len = 4;
        for (short[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(short[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int readArray(int[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getInt32LE(data, o);
            o += 4;
        }
        return o - offset;
    }

    public static int readArray(int[][] result, byte[] data, int offset) {
        int i = offset;
        for (int[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static int[] readintVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        int[] result = new int[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int[][] readMultiDimensionintVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        int[][] result = new int[len][];
        for (int i = 0; i < result.length; ++i) {
            int[] instance = Borsh.readintVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static int[][] readMultiDimensionintVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        int[][] result = new int[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptional(OptionalInt val, byte[] data, int offset) {
        if (val == null || val.isEmpty()) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putInt32LE(data, offset + 1, val.getAsInt());
        return 5;
    }

    public static int writeArray(int[] array, byte[] data, int offset) {
        int i = offset;
        for (int a : array) {
            ByteUtil.putInt32LE(data, i, a);
            i += 4;
        }
        return i - offset;
    }

    public static int writeArrayChecked(int[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(int[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(int[][] array, byte[] data, int offset) {
        int i = offset;
        for (int[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(int[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (int[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(int[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (int[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(int[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (int[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(int[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(int[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(OptionalInt val) {
        return val == null || val.isEmpty() ? 1 : 5;
    }

    public static int lenArray(int[] array) {
        return array.length * 4;
    }

    public static int lenVector(int[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenArray(int[][] array) {
        int len = 0;
        for (int[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(int[][] array) {
        int len = 4;
        for (int[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(int[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int readArray(long[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getInt64LE(data, o);
            o += 8;
        }
        return o - offset;
    }

    public static int readArray(long[][] result, byte[] data, int offset) {
        int i = offset;
        for (long[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static long[] readlongVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        long[] result = new long[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static long[][] readMultiDimensionlongVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        long[][] result = new long[len][];
        for (int i = 0; i < result.length; ++i) {
            long[] instance = Borsh.readlongVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static long[][] readMultiDimensionlongVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        long[][] result = new long[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptional(OptionalLong val, byte[] data, int offset) {
        if (val == null || val.isEmpty()) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putInt64LE(data, offset + 1, val.getAsLong());
        return 9;
    }

    public static int writeOptional(Instant val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putInt64LE(data, offset + 1, val.toEpochMilli());
        return 9;
    }

    public static int writeArray(long[] array, byte[] data, int offset) {
        int i = offset;
        for (long a : array) {
            ByteUtil.putInt64LE(data, i, a);
            i += 8;
        }
        return i - offset;
    }

    public static int writeArrayChecked(long[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(long[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(long[][] array, byte[] data, int offset) {
        int i = offset;
        for (long[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(long[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (long[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(long[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (long[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(long[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (long[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(long[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(long[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(OptionalLong val) {
        return val == null || val.isEmpty() ? 1 : 9;
    }

    public static int lenArray(long[] array) {
        return array.length * 8;
    }

    public static int lenVector(long[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenArray(long[][] array) {
        int len = 0;
        for (long[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(long[][] array) {
        int len = 4;
        for (long[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(long[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int readArray(float[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getFloat32LE(data, o);
            o += 4;
        }
        return o - offset;
    }

    public static int readArray(float[][] result, byte[] data, int offset) {
        int i = offset;
        for (float[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static float[] readfloatVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        float[] result = new float[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static float[][] readMultiDimensionfloatVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        float[][] result = new float[len][];
        for (int i = 0; i < result.length; ++i) {
            float[] instance = Borsh.readfloatVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static float[][] readMultiDimensionfloatVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        float[][] result = new float[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptionalfloat(OptionalDouble val, byte[] data, int offset) {
        if (val == null || val.isEmpty()) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putFloat32LE(data, offset + 1, (float)val.getAsDouble());
        return 5;
    }

    public static int writeArray(float[] array, byte[] data, int offset) {
        int i = offset;
        for (float a : array) {
            ByteUtil.putFloat32LE(data, i, a);
            i += 4;
        }
        return i - offset;
    }

    public static int writeArrayChecked(float[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(float[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(float[][] array, byte[] data, int offset) {
        int i = offset;
        for (float[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(float[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (float[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(float[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (float[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(float[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (float[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(float[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(float[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptionalfloat(OptionalDouble val) {
        return val == null || val.isEmpty() ? 1 : 5;
    }

    public static int lenArray(float[] array) {
        return array.length * 4;
    }

    public static int lenVector(float[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenArray(float[][] array) {
        int len = 0;
        for (float[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(float[][] array) {
        int len = 4;
        for (float[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(float[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int readArray(double[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getFloat64LE(data, o);
            o += 8;
        }
        return o - offset;
    }

    public static int readArray(double[][] result, byte[] data, int offset) {
        int i = offset;
        for (double[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static double[] readdoubleVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        double[] result = new double[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static double[][] readMultiDimensiondoubleVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        double[][] result = new double[len][];
        for (int i = 0; i < result.length; ++i) {
            double[] instance = Borsh.readdoubleVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static double[][] readMultiDimensiondoubleVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        double[][] result = new double[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptional(OptionalDouble val, byte[] data, int offset) {
        if (val == null || val.isEmpty()) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        ByteUtil.putFloat64LE(data, offset + 1, val.getAsDouble());
        return 9;
    }

    public static int writeArray(double[] array, byte[] data, int offset) {
        int i = offset;
        for (double a : array) {
            ByteUtil.putFloat64LE(data, i, a);
            i += 8;
        }
        return i - offset;
    }

    public static int writeArrayChecked(double[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(double[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(double[][] array, byte[] data, int offset) {
        int i = offset;
        for (double[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(double[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (double[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(double[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (double[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(double[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (double[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArrayChecked(double[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int writeVectorArray(double[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(OptionalDouble val) {
        return val == null || val.isEmpty() ? 1 : 9;
    }

    public static int lenArray(double[] array) {
        return array.length * 8;
    }

    public static int lenVector(double[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenArray(double[][] array) {
        int len = 0;
        for (double[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(double[][] array) {
        int len = 4;
        for (double[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(double[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int read128Array(BigInteger[][] result, byte[] data, int offset) {
        int i = offset;
        for (BigInteger[] out : result) {
            i += Borsh.read128Array(out, data, i);
        }
        return i - offset;
    }

    public static int read128Array(BigInteger[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getInt128LE(data, o);
            o += 16;
        }
        return o - offset;
    }

    public static BigInteger[] read128Vector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        BigInteger[] result = new BigInteger[len];
        Borsh.read128Array(result, data, offset + 4);
        return result;
    }

    public static BigInteger[][] readMultiDimension128Vector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        BigInteger[][] result = new BigInteger[len][];
        for (int i = 0; i < result.length; ++i) {
            BigInteger[] instance = Borsh.read128Vector(data, offset);
            result[i] = instance;
            offset += Borsh.len128Vector(instance);
        }
        return result;
    }

    public static BigInteger[][] readMultiDimension128VectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        BigInteger[][] result = new BigInteger[len][fixedLength];
        Borsh.read128Array(result, data, offset + 4);
        return result;
    }

    public static int write128(BigInteger val, byte[] data, int offset) {
        return ByteUtil.putInt128LE(data, offset, val);
    }

    public static int write128Optional(BigInteger val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        return 1 + Borsh.write128(val, data, offset + 1);
    }

    public static int write128Array(BigInteger[] array, byte[] data, int offset) {
        int i = offset;
        for (BigInteger a : array) {
            i += Borsh.write128(a, data, i);
        }
        return i - offset;
    }

    public static int write128ArrayChecked(BigInteger[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.write128Array(array, data, offset);
    }

    public static int write128Vector(BigInteger[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.write128Array(array, data, offset + 4);
    }

    public static int write128Array(BigInteger[][] array, byte[] data, int offset) {
        int i = offset;
        for (BigInteger[] a : array) {
            i += Borsh.write128Array(a, data, i);
        }
        return i - offset;
    }

    public static int write128ArrayChecked(BigInteger[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (BigInteger[] a : array) {
            i += Borsh.write128ArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int write128ArrayChecked(BigInteger[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (BigInteger[] a : array) {
            i += Borsh.write128ArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int write128Vector(BigInteger[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (BigInteger[] a : array) {
            i += Borsh.write128Vector(a, data, i);
        }
        return i - offset;
    }

    public static int write128VectorArrayChecked(BigInteger[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.write128ArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int write128VectorArray(BigInteger[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.write128Array(array, data, offset + 4);
    }

    public static int len128Optional(BigInteger val) {
        return val == null ? 1 : 17;
    }

    public static int len128Array(BigInteger[] array) {
        return array.length * 16;
    }

    public static int len128Vector(BigInteger[] array) {
        return 4 + Borsh.len128Array(array);
    }

    public static int len128Array(BigInteger[][] array) {
        int len = 0;
        for (BigInteger[] a : array) {
            len += Borsh.len128Array(a);
        }
        return len;
    }

    public static int len128Vector(BigInteger[][] array) {
        int len = 4;
        for (BigInteger[] a : array) {
            len += Borsh.len128Vector(a);
        }
        return len;
    }

    public static int len128VectorArray(BigInteger[][] array) {
        return 4 + Borsh.len128Array(array);
    }

    public static int read256Array(BigInteger[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ByteUtil.getInt256LE(data, o);
            o += 32;
        }
        return o - offset;
    }

    public static int read256Array(BigInteger[][] result, byte[] data, int offset) {
        int i = offset;
        for (BigInteger[] out : result) {
            i += Borsh.read256Array(out, data, i);
        }
        return i - offset;
    }

    public static BigInteger[] read256Vector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        BigInteger[] result = new BigInteger[len];
        Borsh.read256Array(result, data, offset + 4);
        return result;
    }

    public static BigInteger[][] readMultiDimension256Vector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        BigInteger[][] result = new BigInteger[len][];
        for (int i = 0; i < result.length; ++i) {
            BigInteger[] instance = Borsh.read256Vector(data, offset);
            result[i] = instance;
            offset += Borsh.len256Vector(instance);
        }
        return result;
    }

    public static BigInteger[][] readMultiDimension256VectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        BigInteger[][] result = new BigInteger[len][fixedLength];
        Borsh.read256Array(result, data, offset + 4);
        return result;
    }

    public static int write256(BigInteger val, byte[] data, int offset) {
        return ByteUtil.putInt256LE(data, offset, val);
    }

    public static int write256Optional(BigInteger val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        return 1 + Borsh.write256(val, data, offset + 1);
    }

    public static int write256Array(BigInteger[] array, byte[] data, int offset) {
        int i = offset;
        for (BigInteger a : array) {
            i += Borsh.write256(a, data, i);
        }
        return i - offset;
    }

    public static int write256ArrayChecked(BigInteger[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.write256Array(array, data, offset);
    }

    public static int write256Vector(BigInteger[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.write256Array(array, data, offset + 4);
    }

    public static int write256Array(BigInteger[][] array, byte[] data, int offset) {
        int i = offset;
        for (BigInteger[] a : array) {
            i += Borsh.write256Array(a, data, i);
        }
        return i - offset;
    }

    public static int write256ArrayChecked(BigInteger[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (BigInteger[] a : array) {
            i += Borsh.write256ArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int write256ArrayChecked(BigInteger[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (BigInteger[] a : array) {
            i += Borsh.write256ArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int write256Vector(BigInteger[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = 4 + offset;
        for (BigInteger[] a : array) {
            i += Borsh.write256Vector(a, data, i);
        }
        return i - offset;
    }

    public static int write256VectorArrayChecked(BigInteger[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.write256ArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int write256VectorArray(BigInteger[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.write256Array(array, data, offset + 4);
    }

    public static int len256Optional(BigInteger val) {
        return val == null ? 1 : 33;
    }

    public static int len256Array(BigInteger[] array) {
        return array.length * 32;
    }

    public static int len256Vector(BigInteger[] array) {
        return 4 + Borsh.len256Array(array);
    }

    public static int len256Array(BigInteger[][] array) {
        int len = 0;
        for (BigInteger[] a : array) {
            len += Borsh.len256Array(a);
        }
        return len;
    }

    public static int len256Vector(BigInteger[][] array) {
        int len = 4;
        for (BigInteger[] a : array) {
            len += Borsh.len256Vector(a);
        }
        return len;
    }

    public static int len256VectorArray(BigInteger[][] array) {
        return 4 + Borsh.len256Array(array);
    }

    public static int readArray(PublicKey[] result, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            result[i] = PublicKey.readPubKey(data, o);
            o += 32;
        }
        return o - offset;
    }

    public static PublicKey[] readPublicKeyVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        PublicKey[] result = new PublicKey[len];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int readArray(PublicKey[][] result, byte[] data, int offset) {
        int i = offset;
        for (PublicKey[] out : result) {
            i += Borsh.readArray(out, data, i);
        }
        return i - offset;
    }

    public static PublicKey[][] readMultiDimensionPublicKeyVector(byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        PublicKey[][] result = new PublicKey[len][];
        for (int i = 0; i < result.length; ++i) {
            PublicKey[] instance = Borsh.readPublicKeyVector(data, offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static PublicKey[][] readMultiDimensionPublicKeyVectorArray(int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        PublicKey[][] result = new PublicKey[len][fixedLength];
        Borsh.readArray(result, data, offset + 4);
        return result;
    }

    public static int writeOptional(PublicKey val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        val.write(data, offset + 1);
        return 33;
    }

    public static int writeArray(PublicKey[] array, byte[] data, int offset) {
        int i = offset;
        for (PublicKey a : array) {
            i += a.write(data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(PublicKey[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(PublicKey[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(PublicKey[][] array, byte[] data, int offset) {
        int i = offset;
        for (PublicKey[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(PublicKey[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (PublicKey[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(PublicKey[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (PublicKey[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(PublicKey[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = offset + 4;
        for (PublicKey[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArray(PublicKey[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int lenOptional(PublicKey val) {
        return val == null ? 1 : 33;
    }

    public static int lenArray(PublicKey[] array) {
        return array.length * 32;
    }

    public static int lenVector(PublicKey[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenArray(PublicKey[][] array) {
        int len = 0;
        for (PublicKey[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVector(PublicKey[][] array) {
        int len = 4;
        for (PublicKey[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenVectorArray(PublicKey[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static <E extends java.lang.Enum<?>> E read(E[] values, byte[] data, int offset) {
        return values[data[offset] & 0xFF];
    }

    public static <B extends Borsh> int readArray(B[] result, Factory<B> factory, byte[] data, int offset) {
        int o = offset;
        for (int i = 0; i < result.length; ++i) {
            Borsh instance = (Borsh)factory.read(data, o);
            result[i] = instance;
            o += instance.l();
        }
        return o - offset;
    }

    public static <B extends Borsh> int readArray(B[][] result, Factory<B> factory, byte[] data, int offset) {
        int i = offset;
        for (B[] out : result) {
            i += Borsh.readArray(out, factory, (byte[])data, (int)i);
        }
        return i - offset;
    }

    public static <B extends Borsh> B[] readVector(Class<B> borshClass, Factory<B> factory, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        Borsh[] result = (Borsh[])Array.newInstance(borshClass, len);
        Borsh.readArray((Borsh[])result, factory, (byte[])data, (int)(offset + 4));
        return result;
    }

    public static <B extends Borsh> B[][] readMultiDimensionVector(Class<B> borshClass, Factory<B> factory, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        offset += 4;
        Borsh[][] result = (Borsh[][])Array.newInstance(borshClass, len, 0);
        for (int i = 0; i < result.length; ++i) {
            Borsh[] instance = Borsh.readVector(borshClass, factory, (byte[])data, (int)offset);
            result[i] = instance;
            offset += Borsh.lenVector(instance);
        }
        return result;
    }

    public static <B extends Borsh> B[][] readMultiDimensionVectorArray(Class<B> borshClass, Factory<B> factory, int fixedLength, byte[] data, int offset) {
        int len = ByteUtil.getInt32LE(data, offset);
        Borsh[][] result = (Borsh[][])Array.newInstance(borshClass, len, fixedLength);
        Borsh.readArray((Borsh[][])result, factory, (byte[])data, (int)(offset + 4));
        return result;
    }

    public static int write(Borsh val, byte[] data, int offset) {
        return val.write(data, offset);
    }

    public static int writeOptional(Borsh val, byte[] data, int offset) {
        if (val == null) {
            data[offset] = 0;
            return 1;
        }
        data[offset] = 1;
        return 1 + Borsh.write(val, data, offset + 1);
    }

    public static int writeArray(Borsh[] array, byte[] data, int offset) {
        int i = offset;
        for (Borsh a : array) {
            i += a.write(data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(Borsh[] array, int fixedLength, byte[] data, int offset) {
        if (array.length != fixedLength) {
            throw Borsh.invalidArrayLength(array, fixedLength, array.length);
        }
        return Borsh.writeArray(array, data, offset);
    }

    public static int writeVector(Borsh[] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeArray(Borsh[][] array, byte[] data, int offset) {
        int i = offset;
        for (Borsh[] a : array) {
            i += Borsh.writeArray(a, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(Borsh[][] array, int fixedLength, byte[] data, int offset) {
        int i = offset;
        for (Borsh[] a : array) {
            i += Borsh.writeArrayChecked(a, fixedLength, data, i);
        }
        return i - offset;
    }

    public static int writeArrayChecked(Borsh[][] array, int firstDimensionLength, int secondDimensionLength, byte[] data, int offset) {
        if (array.length != firstDimensionLength) {
            throw Borsh.invalidArrayLength(array, firstDimensionLength, array.length);
        }
        int i = offset;
        for (Borsh[] a : array) {
            i += Borsh.writeArrayChecked(a, secondDimensionLength, data, i);
        }
        return i - offset;
    }

    public static int writeVector(Borsh[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        int i = offset + 4;
        for (Borsh[] a : array) {
            i += Borsh.writeVector(a, data, i);
        }
        return i - offset;
    }

    public static int writeVectorArray(Borsh[][] array, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArray(array, data, offset + 4);
    }

    public static int writeVectorArrayChecked(Borsh[][] array, int fixedLength, byte[] data, int offset) {
        ByteUtil.putInt32LE(data, offset, array.length);
        return 4 + Borsh.writeArrayChecked(array, fixedLength, data, offset + 4);
    }

    public static int len(Borsh val) {
        return val.l();
    }

    public static int lenOptional(Borsh val) {
        return val == null ? 1 : 1 + val.l();
    }

    public static int lenArray(Borsh[] array) {
        int len = 0;
        for (Borsh a : array) {
            len += a.l();
        }
        return len;
    }

    public static int lenVector(Borsh[] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static int lenVector(Borsh[][] array) {
        int len = 4;
        for (Borsh[] a : array) {
            len += Borsh.lenVector(a);
        }
        return len;
    }

    public static int lenArray(Borsh[][] array) {
        int len = 0;
        for (Borsh[] a : array) {
            len += Borsh.lenArray(a);
        }
        return len;
    }

    public static int lenVectorArray(Borsh[][] array) {
        return 4 + Borsh.lenArray(array);
    }

    public static interface Factory<T> {
        public T read(byte[] var1, int var2);
    }

    public static interface Enum
    extends Borsh {
        public int ordinal();

        @Override
        default public int l() {
            return 1;
        }

        @Override
        default public int write(byte[] data, int offset) {
            data[offset] = (byte)this.ordinal();
            return 1;
        }
    }
}

