/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import software.sava.core.crypto.SunCrypto;

public final class Hmac {
    private static final String HMAC_SHA512 = "HmacSHA512";

    public static Mac hmacSHA512() {
        try {
            return Mac.getInstance(HMAC_SHA512, SunCrypto.SUN_JCE_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find HmacSHA512", e);
        }
    }

    public static byte[] hmacSHA512(byte[] key, byte[] seed) {
        Mac mac = Hmac.hmacSHA512();
        SecretKeySpec keySpec = new SecretKeySpec(seed, HMAC_SHA512);
        try {
            mac.init(keySpec);
            return mac.doFinal(key);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unable to perform HmacSHA512.", e);
        }
    }

    private Hmac() {
    }
}

