/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.crypto.ed25519;

import java.security.DigestException;
import java.security.MessageDigest;
import org.bouncycastle.math.ec.rfc7748.X25519Field;
import org.bouncycastle.math.raw.Interleave;
import software.sava.core.crypto.Hash;
import software.sava.core.crypto.ed25519.Scalar25519;

public final class Ed25519Util {
    private static final long[] D;
    private static final long[] I;
    private static final long[] gf1;
    private static final int[] B_x;
    private static final int[] B_y;
    private static final int[] B128_x;
    private static final int[] B128_y;
    private static final int[] C_d2;
    private static final int[] C_d4;
    private static final int[] PRECOMP_BASE_COMB;

    private static int[] X25519FieldOne() {
        int[] field = X25519Field.create();
        field[0] = 1;
        return field;
    }

    private static void pointCopy(PointAccum var0, PointExtended var1) {
        X25519Field.copy((int[])var0.x, (int)0, (int[])var1.x, (int)0);
        X25519Field.copy((int[])var0.y, (int)0, (int[])var1.y, (int)0);
        X25519Field.copy((int[])var0.z, (int)0, (int[])var1.z, (int)0);
        X25519Field.mul((int[])var0.u, (int[])var0.v, (int[])var1.t);
    }

    private static void pointCopy(PointAffine var0, PointExtended var1) {
        X25519Field.copy((int[])var0.x, (int)0, (int[])var1.x, (int)0);
        X25519Field.copy((int[])var0.y, (int)0, (int[])var1.y, (int)0);
        X25519Field.one((int[])var1.z);
        X25519Field.mul((int[])var0.x, (int[])var0.y, (int[])var1.t);
    }

    private static void pointAdd(PointExtended var0, PointExtended var1, PointExtended var2, PointTemp var3) {
        int[] var4 = var2.x;
        int[] var5 = var2.y;
        int[] var6 = var3.r0;
        int[] var7 = var3.r1;
        X25519Field.apm((int[])var0.y, (int[])var0.x, (int[])var5, (int[])var4);
        X25519Field.apm((int[])var1.y, (int[])var1.x, (int[])var7, (int[])var6);
        X25519Field.mul((int[])var4, (int[])var6, (int[])var4);
        X25519Field.mul((int[])var5, (int[])var7, (int[])var5);
        X25519Field.mul((int[])var0.t, (int[])var1.t, (int[])var6);
        X25519Field.mul((int[])var6, (int[])C_d2, (int[])var6);
        X25519Field.add((int[])var0.z, (int[])var0.z, (int[])var7);
        X25519Field.mul((int[])var7, (int[])var1.z, (int[])var7);
        X25519Field.apm((int[])var5, (int[])var4, (int[])var5, (int[])var4);
        X25519Field.apm((int[])var7, (int[])var6, (int[])var7, (int[])var6);
        X25519Field.mul((int[])var4, (int[])var5, (int[])var2.t);
        X25519Field.mul((int[])var6, (int[])var7, (int[])var2.z);
        X25519Field.mul((int[])var4, (int[])var6, (int[])var2.x);
        X25519Field.mul((int[])var5, (int[])var7, (int[])var2.y);
    }

    private static void pointPrecompute(PointAffine var0, PointExtended[] var1, int var2, int var3, PointTemp var4) {
        var1[var2] = PointExtended.create();
        Ed25519Util.pointCopy(var0, var1[var2]);
        PointExtended var5 = PointExtended.create();
        Ed25519Util.pointAdd(var1[var2], var1[var2], var5, var4);
        for (int var6 = 1; var6 < var3; ++var6) {
            PointExtended pointExtended = PointExtended.create();
            var1[var2 + var6] = pointExtended;
            Ed25519Util.pointAdd(var1[var2 + var6 - 1], var5, pointExtended, var4);
        }
    }

    private static void pointDouble(PointAccum pointAccum) {
        int[] var1 = pointAccum.x;
        int[] var2 = pointAccum.y;
        int[] var3 = pointAccum.z;
        int[] var4 = pointAccum.u;
        int[] var7 = pointAccum.v;
        X25519Field.add((int[])pointAccum.x, (int[])pointAccum.y, (int[])var4);
        X25519Field.sqr((int[])pointAccum.x, (int[])var1);
        X25519Field.sqr((int[])pointAccum.y, (int[])var2);
        X25519Field.sqr((int[])pointAccum.z, (int[])var3);
        X25519Field.add((int[])var3, (int[])var3, (int[])var3);
        X25519Field.apm((int[])var1, (int[])var2, (int[])var7, (int[])var2);
        X25519Field.sqr((int[])var4, (int[])var4);
        X25519Field.sub((int[])var7, (int[])var4, (int[])var4);
        X25519Field.add((int[])var3, (int[])var2, (int[])var1);
        X25519Field.carry((int[])var1);
        X25519Field.mul((int[])var1, (int[])var2, (int[])pointAccum.z);
        X25519Field.mul((int[])var1, (int[])var4, (int[])pointAccum.x);
        X25519Field.mul((int[])var2, (int[])var7, (int[])pointAccum.y);
    }

    private static void invertDoubleZs(PointExtended[] var0) {
        int var1 = var0.length;
        int[] var2 = X25519Field.createTable((int)var1);
        int[] var3 = X25519Field.create();
        X25519Field.copy((int[])var0[0].z, (int)0, (int[])var3, (int)0);
        X25519Field.copy((int[])var3, (int)0, (int[])var2, (int)0);
        int var4 = 0;
        while (true) {
            if (++var4 >= var1) {
                X25519Field.add((int[])var3, (int[])var3, (int[])var3);
                X25519Field.invVar((int[])var3, (int[])var3);
                --var4;
                int[] var5 = X25519Field.create();
                while (var4 > 0) {
                    int var6 = var4--;
                    X25519Field.copy((int[])var2, (int)(var4 * 10), (int[])var5, (int)0);
                    X25519Field.mul((int[])var5, (int[])var3, (int[])var5);
                    X25519Field.mul((int[])var3, (int[])var0[var6].z, (int[])var3);
                    X25519Field.copy((int[])var5, (int)0, (int[])var0[var6].z, (int)0);
                }
                X25519Field.copy((int[])var3, (int)0, (int[])var0[0].z, (int)0);
                return;
            }
            X25519Field.mul((int[])var3, (int[])var0[var4].z, (int[])var3);
            X25519Field.copy((int[])var3, (int)0, (int[])var2, (int)(var4 * 10));
        }
    }

    public static boolean isNotOnCurve(byte[] p) {
        long[][] r = new long[4][16];
        long[] t = new long[16];
        long[] chk = new long[16];
        long[] num = new long[16];
        long[] den = new long[16];
        long[] den2 = new long[16];
        long[] den4 = new long[16];
        long[] den6 = new long[16];
        Ed25519Util.set25519(r[2]);
        Ed25519Util.unpack25519(r[1], p);
        Ed25519Util.S(num, r[1]);
        Ed25519Util.M(den, num, D);
        Ed25519Util.Z(num, num, r[2]);
        Ed25519Util.A(den, r[2], den);
        Ed25519Util.S(den2, den);
        Ed25519Util.S(den4, den2);
        Ed25519Util.M(den6, den4, den2);
        Ed25519Util.M(t, den6, num);
        Ed25519Util.M(t, t, den);
        Ed25519Util.pow2523(t, t);
        Ed25519Util.M(t, t, num);
        Ed25519Util.M(t, t, den);
        Ed25519Util.M(t, t, den);
        Ed25519Util.M(r[0], t, den);
        Ed25519Util.S(chk, r[0]);
        Ed25519Util.M(chk, chk, den);
        if (Ed25519Util.neq25519(chk, num) != 0) {
            Ed25519Util.M(r[0], r[0], I);
        }
        Ed25519Util.S(chk, r[0]);
        Ed25519Util.M(chk, chk, den);
        return Ed25519Util.neq25519(chk, num) != 0;
    }

    private static void set25519(long[] r) {
        System.arraycopy(gf1, 0, r, 0, 16);
    }

    private static void unpack25519(long[] o, byte[] n) {
        for (int i = 0; i < 16; ++i) {
            o[i] = (long)(n[2 * i] & 0xFF) + (long)(n[2 * i + 1] << 8 & 0xFFFF);
        }
        o[15] = o[15] & 0x7FFFL;
    }

    private static void car25519(long[] o) {
        long c = 1L;
        for (int i = 0; i < 16; ++i) {
            long v = o[i] + c + 65535L;
            c = v >> 16;
            o[i] = v - c * 65536L;
        }
        o[0] = o[0] + (c - 1L + 37L * (c - 1L));
    }

    private static void sel25519(long[] p, long[] q, int b) {
        long c = -b;
        int i = 0;
        while (i < 16) {
            long t = c & (p[i] ^ q[i]);
            int n = i;
            p[n] = p[n] ^ t;
            int n2 = i++;
            q[n2] = q[n2] ^ t;
        }
    }

    private static void pack25519(byte[] o, long[] n) {
        long[] m = new long[16];
        long[] t = new long[16];
        System.arraycopy(n, 0, t, 0, 16);
        Ed25519Util.car25519(t);
        Ed25519Util.car25519(t);
        Ed25519Util.car25519(t);
        for (int j = 0; j < 2; ++j) {
            m[0] = t[0] - 65517L;
            for (int i = 1; i < 15; ++i) {
                m[i] = t[i] - 65535L - (m[i - 1] >> 16 & 1L);
                int n2 = i - 1;
                m[n2] = m[n2] & 0xFFFFL;
            }
            m[15] = t[15] - 32767L - (m[14] >> 16 & 1L);
            int b = (int)(m[15] >> 16 & 1L);
            m[14] = m[14] & 0xFFFFL;
            Ed25519Util.sel25519(t, m, 1 - b);
        }
        for (int i = 0; i < 16; ++i) {
            o[2 * i] = (byte)(t[i] & 0xFFL);
            o[2 * i + 1] = (byte)(t[i] >> 8);
        }
    }

    private static int crypto_verify_32(byte[] x, byte[] y) {
        int d = 0;
        for (int i = 0; i < 32; ++i) {
            d |= (x[i] ^ y[i]) & 0xFF;
        }
        return (1 & d - 1 >>> 8) - 1;
    }

    private static int neq25519(long[] a, long[] b) {
        byte[] c = new byte[32];
        byte[] d = new byte[32];
        Ed25519Util.pack25519(c, a);
        Ed25519Util.pack25519(d, b);
        return Ed25519Util.crypto_verify_32(c, d);
    }

    private static void pow2523(long[] o, long[] i) {
        long[] c = new long[16];
        System.arraycopy(i, 0, c, 0, 16);
        for (int a = 250; a >= 0; --a) {
            Ed25519Util.S(c, c);
            if (a == 1) continue;
            Ed25519Util.M(c, c, i);
        }
        System.arraycopy(c, 0, o, 0, 16);
    }

    private static void A(long[] o, long[] a, long[] b) {
        for (int i = 0; i < 16; ++i) {
            o[i] = a[i] + b[i];
        }
    }

    private static void Z(long[] o, long[] a, long[] b) {
        for (int i = 0; i < 16; ++i) {
            o[i] = a[i] - b[i];
        }
    }

    private static void S(long[] o, long[] a) {
        Ed25519Util.M(o, a, a);
    }

    private static void M(long[] o, long[] a, long[] b) {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        long t5 = 0L;
        long t6 = 0L;
        long t7 = 0L;
        long t8 = 0L;
        long t9 = 0L;
        long t10 = 0L;
        long t11 = 0L;
        long t12 = 0L;
        long t13 = 0L;
        long t14 = 0L;
        long t15 = 0L;
        long t16 = 0L;
        long t17 = 0L;
        long t18 = 0L;
        long t19 = 0L;
        long t20 = 0L;
        long t21 = 0L;
        long t22 = 0L;
        long t23 = 0L;
        long t24 = 0L;
        long t25 = 0L;
        long t26 = 0L;
        long t27 = 0L;
        long t28 = 0L;
        long t29 = 0L;
        long t30 = 0L;
        long b0 = b[0];
        long b1 = b[1];
        long b2 = b[2];
        long b3 = b[3];
        long b4 = b[4];
        long b5 = b[5];
        long b6 = b[6];
        long b7 = b[7];
        long b8 = b[8];
        long b9 = b[9];
        long b10 = b[10];
        long b11 = b[11];
        long b12 = b[12];
        long b13 = b[13];
        long b14 = b[14];
        long b15 = b[15];
        long v = a[0];
        t0 += v * b0;
        t1 += v * b1;
        t2 += v * b2;
        t3 += v * b3;
        t4 += v * b4;
        t5 += v * b5;
        t6 += v * b6;
        t7 += v * b7;
        t8 += v * b8;
        t9 += v * b9;
        t10 += v * b10;
        t11 += v * b11;
        t12 += v * b12;
        t13 += v * b13;
        t14 += v * b14;
        t15 += v * b15;
        v = a[1];
        t1 += v * b0;
        t2 += v * b1;
        t3 += v * b2;
        t4 += v * b3;
        t5 += v * b4;
        t6 += v * b5;
        t7 += v * b6;
        t8 += v * b7;
        t9 += v * b8;
        t10 += v * b9;
        t11 += v * b10;
        t12 += v * b11;
        t13 += v * b12;
        t14 += v * b13;
        t15 += v * b14;
        t16 += v * b15;
        v = a[2];
        t2 += v * b0;
        t3 += v * b1;
        t4 += v * b2;
        t5 += v * b3;
        t6 += v * b4;
        t7 += v * b5;
        t8 += v * b6;
        t9 += v * b7;
        t10 += v * b8;
        t11 += v * b9;
        t12 += v * b10;
        t13 += v * b11;
        t14 += v * b12;
        t15 += v * b13;
        t16 += v * b14;
        t17 += v * b15;
        v = a[3];
        t3 += v * b0;
        t4 += v * b1;
        t5 += v * b2;
        t6 += v * b3;
        t7 += v * b4;
        t8 += v * b5;
        t9 += v * b6;
        t10 += v * b7;
        t11 += v * b8;
        t12 += v * b9;
        t13 += v * b10;
        t14 += v * b11;
        t15 += v * b12;
        t16 += v * b13;
        t17 += v * b14;
        t18 += v * b15;
        v = a[4];
        t4 += v * b0;
        t5 += v * b1;
        t6 += v * b2;
        t7 += v * b3;
        t8 += v * b4;
        t9 += v * b5;
        t10 += v * b6;
        t11 += v * b7;
        t12 += v * b8;
        t13 += v * b9;
        t14 += v * b10;
        t15 += v * b11;
        t16 += v * b12;
        t17 += v * b13;
        t18 += v * b14;
        t19 += v * b15;
        v = a[5];
        t5 += v * b0;
        t6 += v * b1;
        t7 += v * b2;
        t8 += v * b3;
        t9 += v * b4;
        t10 += v * b5;
        t11 += v * b6;
        t12 += v * b7;
        t13 += v * b8;
        t14 += v * b9;
        t15 += v * b10;
        t16 += v * b11;
        t17 += v * b12;
        t18 += v * b13;
        t19 += v * b14;
        t20 += v * b15;
        v = a[6];
        t6 += v * b0;
        t7 += v * b1;
        t8 += v * b2;
        t9 += v * b3;
        t10 += v * b4;
        t11 += v * b5;
        t12 += v * b6;
        t13 += v * b7;
        t14 += v * b8;
        t15 += v * b9;
        t16 += v * b10;
        t17 += v * b11;
        t18 += v * b12;
        t19 += v * b13;
        t20 += v * b14;
        t21 += v * b15;
        v = a[7];
        t7 += v * b0;
        t8 += v * b1;
        t9 += v * b2;
        t10 += v * b3;
        t11 += v * b4;
        t12 += v * b5;
        t13 += v * b6;
        t14 += v * b7;
        t15 += v * b8;
        t16 += v * b9;
        t17 += v * b10;
        t18 += v * b11;
        t19 += v * b12;
        t20 += v * b13;
        t21 += v * b14;
        t22 += v * b15;
        v = a[8];
        t8 += v * b0;
        t9 += v * b1;
        t10 += v * b2;
        t11 += v * b3;
        t12 += v * b4;
        t13 += v * b5;
        t14 += v * b6;
        t15 += v * b7;
        t16 += v * b8;
        t17 += v * b9;
        t18 += v * b10;
        t19 += v * b11;
        t20 += v * b12;
        t21 += v * b13;
        t22 += v * b14;
        t23 += v * b15;
        v = a[9];
        t9 += v * b0;
        t10 += v * b1;
        t11 += v * b2;
        t12 += v * b3;
        t13 += v * b4;
        t14 += v * b5;
        t15 += v * b6;
        t16 += v * b7;
        t17 += v * b8;
        t18 += v * b9;
        t19 += v * b10;
        t20 += v * b11;
        t21 += v * b12;
        t22 += v * b13;
        t23 += v * b14;
        t24 += v * b15;
        v = a[10];
        t10 += v * b0;
        t11 += v * b1;
        t12 += v * b2;
        t13 += v * b3;
        t14 += v * b4;
        t15 += v * b5;
        t16 += v * b6;
        t17 += v * b7;
        t18 += v * b8;
        t19 += v * b9;
        t20 += v * b10;
        t21 += v * b11;
        t22 += v * b12;
        t23 += v * b13;
        t24 += v * b14;
        t25 += v * b15;
        v = a[11];
        t11 += v * b0;
        t12 += v * b1;
        t13 += v * b2;
        t14 += v * b3;
        t15 += v * b4;
        t16 += v * b5;
        t17 += v * b6;
        t18 += v * b7;
        t19 += v * b8;
        t20 += v * b9;
        t21 += v * b10;
        t22 += v * b11;
        t23 += v * b12;
        t24 += v * b13;
        t25 += v * b14;
        t26 += v * b15;
        v = a[12];
        t12 += v * b0;
        t13 += v * b1;
        t14 += v * b2;
        t15 += v * b3;
        t16 += v * b4;
        t17 += v * b5;
        t18 += v * b6;
        t19 += v * b7;
        t20 += v * b8;
        t21 += v * b9;
        t22 += v * b10;
        t23 += v * b11;
        t24 += v * b12;
        t25 += v * b13;
        t26 += v * b14;
        t27 += v * b15;
        v = a[13];
        t13 += v * b0;
        t14 += v * b1;
        t15 += v * b2;
        t16 += v * b3;
        t17 += v * b4;
        t18 += v * b5;
        t19 += v * b6;
        t20 += v * b7;
        t21 += v * b8;
        t22 += v * b9;
        t23 += v * b10;
        t24 += v * b11;
        t25 += v * b12;
        t26 += v * b13;
        t27 += v * b14;
        t28 += v * b15;
        v = a[14];
        t14 += v * b0;
        t15 += v * b1;
        t16 += v * b2;
        t17 += v * b3;
        t18 += v * b4;
        t19 += v * b5;
        t20 += v * b6;
        t21 += v * b7;
        t22 += v * b8;
        t23 += v * b9;
        t24 += v * b10;
        t25 += v * b11;
        t26 += v * b12;
        t27 += v * b13;
        t28 += v * b14;
        t29 += v * b15;
        v = a[15];
        t15 += v * b0;
        t16 += v * b1;
        t17 += v * b2;
        t18 += v * b3;
        t19 += v * b4;
        t20 += v * b5;
        t21 += v * b6;
        t22 += v * b7;
        t23 += v * b8;
        t24 += v * b9;
        t25 += v * b10;
        t26 += v * b11;
        t27 += v * b12;
        t28 += v * b13;
        t29 += v * b14;
        t30 += v * b15;
        t0 += 38L * t16;
        t1 += 38L * t17;
        t2 += 38L * t18;
        t3 += 38L * t19;
        t4 += 38L * t20;
        t5 += 38L * t21;
        t6 += 38L * t22;
        t7 += 38L * t23;
        t8 += 38L * t24;
        t9 += 38L * t25;
        t10 += 38L * t26;
        t11 += 38L * t27;
        t12 += 38L * t28;
        t13 += 38L * t29;
        t14 += 38L * t30;
        long c = 1L;
        v = t0 + c + 65535L;
        c = v >> 16;
        t0 = v - c * 65536L;
        v = t1 + c + 65535L;
        c = v >> 16;
        t1 = v - c * 65536L;
        v = t2 + c + 65535L;
        c = v >> 16;
        t2 = v - c * 65536L;
        v = t3 + c + 65535L;
        c = v >> 16;
        t3 = v - c * 65536L;
        v = t4 + c + 65535L;
        c = v >> 16;
        t4 = v - c * 65536L;
        v = t5 + c + 65535L;
        c = v >> 16;
        t5 = v - c * 65536L;
        v = t6 + c + 65535L;
        c = v >> 16;
        t6 = v - c * 65536L;
        v = t7 + c + 65535L;
        c = v >> 16;
        t7 = v - c * 65536L;
        v = t8 + c + 65535L;
        c = v >> 16;
        t8 = v - c * 65536L;
        v = t9 + c + 65535L;
        c = v >> 16;
        t9 = v - c * 65536L;
        v = t10 + c + 65535L;
        c = v >> 16;
        t10 = v - c * 65536L;
        v = t11 + c + 65535L;
        c = v >> 16;
        t11 = v - c * 65536L;
        v = t12 + c + 65535L;
        c = v >> 16;
        t12 = v - c * 65536L;
        v = t13 + c + 65535L;
        c = v >> 16;
        t13 = v - c * 65536L;
        v = t14 + c + 65535L;
        c = v >> 16;
        t14 = v - c * 65536L;
        v = t15 + c + 65535L;
        c = v >> 16;
        t15 = v - c * 65536L;
        t0 += c - 1L + 37L * (c - 1L);
        c = 1L;
        v = t0 + c + 65535L;
        c = v >> 16;
        t0 = v - c * 65536L;
        v = t1 + c + 65535L;
        c = v >> 16;
        t1 = v - c * 65536L;
        v = t2 + c + 65535L;
        c = v >> 16;
        t2 = v - c * 65536L;
        v = t3 + c + 65535L;
        c = v >> 16;
        t3 = v - c * 65536L;
        v = t4 + c + 65535L;
        c = v >> 16;
        t4 = v - c * 65536L;
        v = t5 + c + 65535L;
        c = v >> 16;
        t5 = v - c * 65536L;
        v = t6 + c + 65535L;
        c = v >> 16;
        t6 = v - c * 65536L;
        v = t7 + c + 65535L;
        c = v >> 16;
        t7 = v - c * 65536L;
        v = t8 + c + 65535L;
        c = v >> 16;
        t8 = v - c * 65536L;
        v = t9 + c + 65535L;
        c = v >> 16;
        t9 = v - c * 65536L;
        v = t10 + c + 65535L;
        c = v >> 16;
        t10 = v - c * 65536L;
        v = t11 + c + 65535L;
        c = v >> 16;
        t11 = v - c * 65536L;
        v = t12 + c + 65535L;
        c = v >> 16;
        t12 = v - c * 65536L;
        v = t13 + c + 65535L;
        c = v >> 16;
        t13 = v - c * 65536L;
        v = t14 + c + 65535L;
        c = v >> 16;
        t14 = v - c * 65536L;
        v = t15 + c + 65535L;
        c = v >> 16;
        t15 = v - c * 65536L;
        o[0] = t0 += c - 1L + 37L * (c - 1L);
        o[1] = t1;
        o[2] = t2;
        o[3] = t3;
        o[4] = t4;
        o[5] = t5;
        o[6] = t6;
        o[7] = t7;
        o[8] = t8;
        o[9] = t9;
        o[10] = t10;
        o[11] = t11;
        o[12] = t12;
        o[13] = t13;
        o[14] = t14;
        o[15] = t15;
    }

    private static void groupCombBits(int[] var0) {
        for (int var1 = 0; var1 < var0.length; ++var1) {
            var0[var1] = Interleave.shuffle2((int)var0[var1]);
        }
    }

    private static void pointLookup(int var0, int var1, PointPrecomp pointPrecomp) {
        int var3 = var0 * 8 * 3 * 10;
        for (int var4 = 0; var4 < 8; ++var4) {
            int var5 = (var4 ^ var1) - 1 >> 31;
            X25519Field.cmov((int)var5, (int[])PRECOMP_BASE_COMB, (int)var3, (int[])pointPrecomp.ymx_h, (int)0);
            X25519Field.cmov((int)var5, (int[])PRECOMP_BASE_COMB, (int)(var3 += 10), (int[])pointPrecomp.ypx_h, (int)0);
            X25519Field.cmov((int)var5, (int[])PRECOMP_BASE_COMB, (int)(var3 += 10), (int[])pointPrecomp.xyd, (int)0);
            var3 += 10;
        }
    }

    private static void pointAdd(PointPrecomp var0, PointAccum pointAccum, PointTemp pointTemp) {
        int[] var3 = pointAccum.x;
        int[] var4 = pointAccum.y;
        int[] var5 = pointTemp.r0;
        int[] var6 = pointAccum.u;
        int[] var9 = pointAccum.v;
        X25519Field.apm((int[])pointAccum.y, (int[])pointAccum.x, (int[])var4, (int[])var3);
        X25519Field.mul((int[])var3, (int[])var0.ymx_h, (int[])var3);
        X25519Field.mul((int[])var4, (int[])var0.ypx_h, (int[])var4);
        X25519Field.mul((int[])pointAccum.u, (int[])pointAccum.v, (int[])var5);
        X25519Field.mul((int[])var5, (int[])var0.xyd, (int[])var5);
        X25519Field.apm((int[])var4, (int[])var3, (int[])var9, (int[])var6);
        X25519Field.apm((int[])pointAccum.z, (int[])var5, (int[])var4, (int[])var3);
        X25519Field.mul((int[])var3, (int[])var4, (int[])pointAccum.z);
        X25519Field.mul((int[])var3, (int[])var6, (int[])pointAccum.x);
        X25519Field.mul((int[])var4, (int[])var9, (int[])pointAccum.y);
    }

    private static PointAccum scalarMultBase(byte[] var0) {
        int[] var2 = new int[8];
        Scalar25519.decode(var0, var2);
        Scalar25519.toSignedDigits(var2);
        Ed25519Util.groupCombBits(var2);
        PointPrecomp pointPrecomp = PointPrecomp.create();
        PointTemp pointTemp = PointTemp.create();
        PointAccum pointAccum = PointAccum.pointSetNeutral();
        int var5 = 0;
        int var6 = 28;
        while (true) {
            for (int var7 = 0; var7 < 8; ++var7) {
                int var8 = var2[var7] >>> var6;
                int var9 = var8 >>> 3 & 1;
                int var10 = (var8 ^ -var9) & 7;
                Ed25519Util.pointLookup(var7, var10, pointPrecomp);
                X25519Field.cnegate((int)(var5 ^ var9), (int[])pointAccum.x);
                X25519Field.cnegate((int)(var5 ^ var9), (int[])pointAccum.u);
                var5 = var9;
                Ed25519Util.pointAdd(pointPrecomp, pointAccum, pointTemp);
            }
            if ((var6 -= 4) < 0) {
                X25519Field.cnegate((int)var5, (int[])pointAccum.x);
                X25519Field.cnegate((int)var5, (int[])pointAccum.u);
                return pointAccum;
            }
            Ed25519Util.pointDouble(pointAccum);
        }
    }

    private static void pruneScalar(byte[] mutableKeyPair, int privateKeyOffset, byte[] mutablePublicKey) {
        System.arraycopy(mutableKeyPair, privateKeyOffset, mutablePublicKey, 0, 32);
        mutablePublicKey[0] = (byte)(mutablePublicKey[0] & 0xF8);
        mutablePublicKey[31] = (byte)(mutablePublicKey[31] & 0x7F);
        mutablePublicKey[31] = (byte)(mutablePublicKey[31] | 0x40);
    }

    private static void normalizeToAffine(PointAccum pointAccum, PointAffine pointAffine) {
        X25519Field.inv((int[])pointAccum.z, (int[])pointAffine.y);
        X25519Field.mul((int[])pointAffine.y, (int[])pointAccum.x, (int[])pointAffine.x);
        X25519Field.mul((int[])pointAffine.y, (int[])pointAccum.y, (int[])pointAffine.y);
        X25519Field.normalize((int[])pointAffine.x);
        X25519Field.normalize((int[])pointAffine.y);
    }

    private static void encodePoint(PointAffine var0, byte[] publicKeyOut, int var2) {
        X25519Field.encode((int[])var0.y, (byte[])publicKeyOut, (int)var2);
        publicKeyOut[var2 + 32 - 1] = (byte)(publicKeyOut[var2 + 32 - 1] | (var0.x[0] & 1) << 7);
    }

    private static void encodeResult(PointAccum pointAccum, byte[] publicKeyOut, int var2) {
        PointAffine pointAffine = PointAffine.create();
        Ed25519Util.normalizeToAffine(pointAccum, pointAffine);
        Ed25519Util.encodePoint(pointAffine, publicKeyOut, var2);
    }

    private static void scalarMultBaseEncoded(byte[] mutablePublicKey, byte[] publicKeyOut, int publicKeyOffset) {
        PointAccum pointAccum = Ed25519Util.scalarMultBase(mutablePublicKey);
        Ed25519Util.encodeResult(pointAccum, publicKeyOut, publicKeyOffset);
    }

    public static void generatePublicKey(byte[] privateKey, byte[] publicKeyOut) {
        Ed25519Util.generatePublicKey(privateKey, 0, publicKeyOut, 0);
    }

    public static void generatePublicKey(byte[] privateKey, int privateKeyOffset, byte[] publicKeyOut, int publicKeyOutOffset) {
        MessageDigest digest = Hash.sha512Digest();
        byte[] mutablePublicKey = new byte[32];
        byte[] mutableKeyPair = new byte[64];
        Ed25519Util.generatePublicKey(digest, privateKey, privateKeyOffset, publicKeyOut, publicKeyOutOffset, mutablePublicKey, mutableKeyPair);
    }

    public static void generatePublicKey(MessageDigest messageDigest, byte[] privateKey, int privateKeyOffset, byte[] publicKeyOut, int publicKeyOutOffset, byte[] mutablePublicKey, byte[] mutableKeyPair) {
        messageDigest.update(privateKey, privateKeyOffset, 32);
        try {
            messageDigest.digest(mutableKeyPair, 0, 64);
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
        Ed25519Util.pruneScalar(mutableKeyPair, 0, mutablePublicKey);
        Ed25519Util.scalarMultBaseEncoded(mutablePublicKey, publicKeyOut, publicKeyOutOffset);
    }

    private Ed25519Util() {
    }

    static {
        int var14;
        PointExtended var13;
        int var12;
        D = new long[]{30883L, 4953L, 19914L, 30187L, 55467L, 16705L, 2637L, 112L, 59544L, 30585L, 16505L, 36039L, 65139L, 11119L, 27886L, 20995L};
        I = new long[]{41136L, 18958L, 6951L, 50414L, 58488L, 44335L, 6150L, 12099L, 55207L, 15867L, 153L, 11085L, 57099L, 20417L, 9344L, 11139L};
        gf1 = new long[16];
        B_x = new int[]{52811034, 25909283, 8072341, 50637101, 13785486, 30858332, 20483199, 20966410, 43936626, 4379245};
        B_y = new int[]{40265304, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC, 0x2666666, 0x1999999, 0x666666, 0x3333333, 0xCCCCCC};
        B128_x = new int[]{12052516, 1174424, 4087752, 38672185, 20040971, 21899680, 55468344, 20105554, 66708015, 9981791};
        B128_y = new int[]{66430571, 45040722, 4842939, 15895846, 18981244, 46308410, 4697481, 8903007, 53646190, 12474675};
        C_d2 = new int[]{45281625, 27714825, 18181821, 0xD4141D, 114729, 49533232, 60832955, 30306712, 48412415, 4722099};
        C_d4 = new int[]{23454386, 55429651, 2809210, 27797563, 229458, 31957600, 54557047, 27058993, 29715967, 9444199};
        Ed25519Util.gf1[0] = 1L;
        int var1 = 16;
        int var2 = 64;
        int var3 = 96;
        PointExtended[] var4 = new PointExtended[96];
        PointTemp var5 = PointTemp.create();
        PointAffine var6 = PointAffine.create();
        X25519Field.copy((int[])B_x, (int)0, (int[])var6.x, (int)0);
        X25519Field.copy((int[])B_y, (int)0, (int[])var6.y, (int)0);
        Ed25519Util.pointPrecompute(var6, var4, 0, 16, var5);
        PointAffine var7 = PointAffine.create();
        X25519Field.copy((int[])B128_x, (int)0, (int[])var7.x, (int)0);
        X25519Field.copy((int[])B128_y, (int)0, (int[])var7.y, (int)0);
        Ed25519Util.pointPrecompute(var7, var4, 16, 16, var5);
        PointAccum var8 = PointAccum.create();
        X25519Field.copy((int[])B_x, (int)0, (int[])var8.x, (int)0);
        X25519Field.copy((int[])B_y, (int)0, (int[])var8.y, (int)0);
        X25519Field.one((int[])var8.z);
        X25519Field.copy((int[])var8.x, (int)0, (int[])var8.u, (int)0);
        X25519Field.copy((int[])var8.y, (int)0, (int[])var8.v, (int)0);
        int var9 = 32;
        PointExtended[] var10 = new PointExtended[4];
        for (int var11 = 0; var11 < 4; ++var11) {
            var10[var11] = PointExtended.create();
        }
        PointExtended var19 = PointExtended.create();
        for (var12 = 0; var12 < 8; ++var12) {
            int var15;
            int n = var9++;
            PointExtended pointExtended = PointExtended.create();
            var4[n] = pointExtended;
            var13 = pointExtended;
            for (var14 = 0; var14 < 4; ++var14) {
                if (var14 == 0) {
                    Ed25519Util.pointCopy(var8, var13);
                } else {
                    Ed25519Util.pointCopy(var8, var19);
                    Ed25519Util.pointAdd(var13, var19, var13, var5);
                }
                Ed25519Util.pointDouble(var8);
                Ed25519Util.pointCopy(var8, var10[var14]);
                if (var12 + var14 == 10) continue;
                for (var15 = 1; var15 < 8; ++var15) {
                    Ed25519Util.pointDouble(var8);
                }
            }
            X25519Field.negate((int[])var13.x, (int[])var13.x);
            X25519Field.negate((int[])var13.t, (int[])var13.t);
            for (var14 = 0; var14 < 3; ++var14) {
                var15 = 1 << var14;
                int var16 = 0;
                while (var16 < var15) {
                    var4[var9] = PointExtended.create();
                    Ed25519Util.pointAdd(var4[var9 - var15], var10[var14], var4[var9], var5);
                    ++var16;
                    ++var9;
                }
            }
        }
        Ed25519Util.invertDoubleZs(var4);
        for (var12 = 0; var12 < 16; ++var12) {
            var13 = var4[var12];
            PointPrecomp var22 = PointPrecomp.create();
            X25519Field.mul((int[])var13.x, (int[])var13.z, (int[])var13.x);
            X25519Field.mul((int[])var13.y, (int[])var13.z, (int[])var13.y);
            X25519Field.apm((int[])var13.y, (int[])var13.x, (int[])var22.ypx_h, (int[])var22.ymx_h);
            X25519Field.mul((int[])var13.x, (int[])var13.y, (int[])var22.xyd);
            X25519Field.mul((int[])var22.xyd, (int[])C_d4, (int[])var22.xyd);
            X25519Field.normalize((int[])var22.ymx_h);
            X25519Field.normalize((int[])var22.ypx_h);
            X25519Field.normalize((int[])var22.xyd);
        }
        for (var12 = 0; var12 < 16; ++var12) {
            var13 = var4[16 + var12];
            PointPrecomp var22 = PointPrecomp.create();
            X25519Field.mul((int[])var13.x, (int[])var13.z, (int[])var13.x);
            X25519Field.mul((int[])var13.y, (int[])var13.z, (int[])var13.y);
            X25519Field.apm((int[])var13.y, (int[])var13.x, (int[])var22.ypx_h, (int[])var22.ymx_h);
            X25519Field.mul((int[])var13.x, (int[])var13.y, (int[])var22.xyd);
            X25519Field.mul((int[])var22.xyd, (int[])C_d4, (int[])var22.xyd);
            X25519Field.normalize((int[])var22.ymx_h);
            X25519Field.normalize((int[])var22.ypx_h);
            X25519Field.normalize((int[])var22.xyd);
        }
        PRECOMP_BASE_COMB = X25519Field.createTable((int)192);
        PointPrecomp var20 = PointPrecomp.create();
        int var21 = 0;
        for (var14 = 32; var14 < 96; ++var14) {
            PointExtended var23 = var4[var14];
            X25519Field.mul((int[])var23.x, (int[])var23.z, (int[])var23.x);
            X25519Field.mul((int[])var23.y, (int[])var23.z, (int[])var23.y);
            X25519Field.apm((int[])var23.y, (int[])var23.x, (int[])var20.ypx_h, (int[])var20.ymx_h);
            X25519Field.mul((int[])var23.x, (int[])var23.y, (int[])var20.xyd);
            X25519Field.mul((int[])var20.xyd, (int[])C_d4, (int[])var20.xyd);
            X25519Field.normalize((int[])var20.ymx_h);
            X25519Field.normalize((int[])var20.ypx_h);
            X25519Field.normalize((int[])var20.xyd);
            X25519Field.copy((int[])var20.ymx_h, (int)0, (int[])PRECOMP_BASE_COMB, (int)var21);
            X25519Field.copy((int[])var20.ypx_h, (int)0, (int[])PRECOMP_BASE_COMB, (int)(var21 += 10));
            X25519Field.copy((int[])var20.xyd, (int)0, (int[])PRECOMP_BASE_COMB, (int)(var21 += 10));
            var21 += 10;
        }
    }

    private record PointAccum(int[] x, int[] y, int[] z, int[] u, int[] v) {
        private static PointAccum create() {
            return new PointAccum(X25519Field.create(), X25519Field.create(), X25519Field.create(), X25519Field.create(), X25519Field.create());
        }

        private static PointAccum pointSetNeutral() {
            return new PointAccum(X25519Field.create(), Ed25519Util.X25519FieldOne(), Ed25519Util.X25519FieldOne(), X25519Field.create(), Ed25519Util.X25519FieldOne());
        }
    }

    private record PointExtended(int[] x, int[] y, int[] z, int[] t) {
        private static PointExtended create() {
            return new PointExtended(X25519Field.create(), X25519Field.create(), X25519Field.create(), X25519Field.create());
        }
    }

    private record PointAffine(int[] x, int[] y) {
        private static PointAffine create() {
            return new PointAffine(X25519Field.create(), X25519Field.create());
        }
    }

    private record PointTemp(int[] r0, int[] r1) {
        private static PointTemp create() {
            return new PointTemp(X25519Field.create(), X25519Field.create());
        }
    }

    private record PointPrecomp(int[] ymx_h, int[] ypx_h, int[] xyd) {
        private static PointPrecomp create() {
            return new PointPrecomp(X25519Field.create(), X25519Field.create(), X25519Field.create());
        }
    }
}

