/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.encoding;

import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class Base58 {
    private static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final char ENCODED_ZERO = ALPHABET[0];
    private static final int[] INDEXES = new int[123];

    public static boolean isBase58(char c) {
        return Arrays.binarySearch(ALPHABET, c) >= 0;
    }

    public static boolean isBase58(String str) {
        for (char c : str.toCharArray()) {
            if (Base58.isBase58(c)) continue;
            return false;
        }
        return true;
    }

    public static int nonBase58(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Arrays.binarySearch(ALPHABET, c) >= 0) continue;
            return i;
        }
        return -1;
    }

    public static String encode(byte[] input) {
        return Base58.encode(input, 0, input.length);
    }

    public static String encode(byte[] input, int offset, int to) {
        char[] encoded = new char[input.length << 1];
        int outputStart = Base58.encode(input, offset, to, encoded);
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    public static int encode(byte[] input, char[] output) {
        return Base58.encode(input, 0, input.length, output);
    }

    public static int encode(byte[] input, int offset, int to, char[] output) {
        int leadingZeroes;
        input = Arrays.copyOfRange(input, offset, to);
        for (leadingZeroes = 0; leadingZeroes < input.length && input[leadingZeroes] == 0; ++leadingZeroes) {
        }
        int outputStart = output.length;
        int inputStart = leadingZeroes;
        while (inputStart < input.length) {
            output[--outputStart] = ALPHABET[Base58.divMod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < output.length && output[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (leadingZeroes > 0) {
            output[--outputStart] = ENCODED_ZERO;
            --leadingZeroes;
        }
        return outputStart;
    }

    public static byte[] decode(char[] input) {
        return Base58.decode(input, 0, input.length);
    }

    public static byte[] decode(char[] input, int from, int len) {
        if (len == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[len];
        int i = from;
        for (int i58 = 0; i58 < len; ++i58) {
            block8: {
                int c;
                block7: {
                    c = Character.codePointAt(input, i);
                    try {
                        int digit = INDEXES[c];
                        if (digit < 0) break block7;
                        input58[i58] = (byte)digit;
                        break block8;
                    }
                    catch (ArrayIndexOutOfBoundsException digit) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Illegal character " + c + " at position " + i);
            }
            ++i;
        }
        int zeros = 0;
        while (input58[zeros] == 0) {
            if (++zeros != len) continue;
            return input58;
        }
        byte[] decoded = new byte[len];
        int outputStart = len;
        int inputStart = zeros;
        do {
            decoded[--outputStart] = Base58.divMod(input58, inputStart, 58, 256);
        } while (input58[inputStart] != 0 || ++inputStart != len);
        while (outputStart < len && decoded[outputStart] == 0) {
            ++outputStart;
        }
        int start = outputStart - zeros;
        byte[] zeroPadded = new byte[len - start];
        System.arraycopy(decoded, start, zeroPadded, 0, zeroPadded.length);
        return zeroPadded;
    }

    public static byte[] decode(String input) {
        int len = input.length();
        if (len == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[len];
        PrimitiveIterator.OfInt codePoints = input.codePoints().iterator();
        for (int i = 0; i < len; ++i) {
            int c = codePoints.next();
            try {
                int digit = INDEXES[c];
                if (digit >= 0) {
                    input58[i] = (byte)digit;
                    continue;
                }
            }
            catch (ArrayIndexOutOfBoundsException digit) {
                // empty catch block
            }
            throw new IllegalArgumentException("Illegal character " + c + " at position " + i);
        }
        int zeros = 0;
        while (input58[zeros] == 0) {
            if (++zeros != len) continue;
            return input58;
        }
        byte[] decoded = new byte[len];
        int outputStart = len;
        int inputStart = zeros;
        do {
            decoded[--outputStart] = Base58.divMod(input58, inputStart, 58, 256);
        } while (input58[inputStart] != 0 || ++inputStart != len);
        while (outputStart < len && decoded[outputStart] == 0) {
            ++outputStart;
        }
        int start = outputStart - zeros;
        byte[] zeroPadded = new byte[len - start];
        System.arraycopy(decoded, start, zeroPadded, 0, zeroPadded.length);
        return zeroPadded;
    }

    static byte divMod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int num = remainder * base + (number[i] & 0xFF);
            number[i] = (byte)(num / divisor);
            remainder = num % divisor;
        }
        return (byte)remainder;
    }

    public static int mutableEncode(byte[] input, char[] output) {
        int leadingZeroes;
        for (leadingZeroes = 0; leadingZeroes < input.length && input[leadingZeroes] == 0; ++leadingZeroes) {
        }
        int outputStart = output.length;
        int inputStart = leadingZeroes;
        while (inputStart < input.length) {
            output[--outputStart] = ALPHABET[Base58.divMod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < output.length && output[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (leadingZeroes > 0) {
            output[--outputStart] = ENCODED_ZERO;
            --leadingZeroes;
        }
        return outputStart;
    }

    public static int continueMutableEncode(byte[] input, int leadingZeroes, int inputStart, int outputStart, char[] output) {
        while (inputStart < input.length) {
            output[--outputStart] = ALPHABET[Base58.divMod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < output.length && output[outputStart] == ENCODED_ZERO) {
            ++outputStart;
        }
        while (leadingZeroes > 0) {
            output[--outputStart] = ENCODED_ZERO;
            --leadingZeroes;
        }
        return outputStart;
    }

    public static long beginMutableEncode(byte[] input, int maxLen, char[] output) {
        int leadingZeroes;
        for (leadingZeroes = 0; leadingZeroes < input.length && input[leadingZeroes] == 0; ++leadingZeroes) {
        }
        int outputStart = output.length;
        int inputStart = leadingZeroes;
        for (int len = 0; inputStart < input.length && len < maxLen; ++len) {
            output[--outputStart] = ALPHABET[Base58.divMod(input, inputStart, 256, 58)];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        return (long)outputStart | (long)leadingZeroes << 48 | (long)inputStart << 32;
    }

    private Base58() {
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

