/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.encoding;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class Jex {
    static final byte[] LOWER_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final byte[] UPPER_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int INVALID = -1;
    private static final char[] LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MAX_CHAR = 102;
    private static final int[] DIGITS = new int[103];

    private static RuntimeException createIllegalLengthException(int len) {
        return new IllegalArgumentException(String.format("Invalid hex encoding length of %d.", len));
    }

    private static RuntimeException createIllegalCharException(byte chr, int pos) {
        return Jex.createIllegalCharException((char)chr, pos);
    }

    private static RuntimeException createIllegalCharException(char chr, int pos) {
        return new IllegalArgumentException(String.format("Invalid character '%c' for hex encoding at position %d.", Character.valueOf(chr), pos));
    }

    public static String encode(byte[] data) {
        return new String(Jex.encode(data, LOWER));
    }

    public static String encodeUpper(byte[] data) {
        return new String(Jex.encode(data, UPPER));
    }

    public static char[] encodeChars(byte[] data) {
        return Jex.encode(data, LOWER);
    }

    public static char[] encodeUpperChars(byte[] data) {
        return Jex.encode(data, UPPER);
    }

    private static char[] encode(byte[] data, char[] alpha) {
        char[] hex = new char[data.length << 1];
        Jex.encode(data, hex, 0, alpha);
        return hex;
    }

    private static void encode(byte[] data, char[] out, int outOffset, char[] alpha) {
        int len = data.length;
        int i = 0;
        while (i < len) {
            int d = data[i++] & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
        }
    }

    public static byte[] encodeBytes(byte[] data) {
        return Jex.encodeBytes(data, LOWER_BYTES);
    }

    public static byte[] encodeUpperBytes(byte[] data) {
        return Jex.encodeBytes(data, UPPER_BYTES);
    }

    static byte[] encodeBytes(byte[] data, byte[] alpha) {
        byte[] hex = new byte[data.length << 1];
        Jex.encodeBytes(data, hex, 0, alpha);
        return hex;
    }

    public static void encodeBytes(byte[] data, byte[] out, int outOffset) {
        Jex.encodeBytes(data, out, outOffset, LOWER_BYTES);
    }

    public static void encodeUpperBytes(byte[] data, byte[] out, int outOffset) {
        Jex.encodeBytes(data, out, outOffset, UPPER_BYTES);
    }

    static void encodeBytes(byte[] data, byte[] out, int outOffset, byte[] alpha) {
        int len = data.length;
        int i = 0;
        while (i < len) {
            int d = data[i++] & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
        }
    }

    public static String encode(ByteBuffer data) {
        return new String(Jex.encode(data, LOWER));
    }

    public static String encodeUpper(ByteBuffer data) {
        return new String(Jex.encode(data, UPPER));
    }

    public static char[] encodeChars(ByteBuffer data) {
        return Jex.encode(data, LOWER);
    }

    public static char[] encodeUpperChars(ByteBuffer data) {
        return Jex.encode(data, UPPER);
    }

    private static char[] encode(ByteBuffer data, char[] alpha) {
        char[] hex = new char[data.limit() << 1];
        Jex.encode(data, hex, 0, alpha);
        return hex;
    }

    public static void encodeChars(ByteBuffer data, char[] out, int outOffset) {
        Jex.encode(data, out, outOffset, LOWER);
    }

    public static void encodeUpperChars(ByteBuffer data, char[] out, int outOffset) {
        Jex.encode(data, out, outOffset, UPPER);
    }

    private static void encode(ByteBuffer data, char[] out, int outOffset, char[] alpha) {
        int max = outOffset + (data.limit() << 1);
        while (outOffset < max) {
            int d = data.get() & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
        }
    }

    public static byte[] encodeBytes(ByteBuffer data) {
        return Jex.encodeBytes(data, LOWER_BYTES);
    }

    public static byte[] encodeUpperBytes(ByteBuffer data) {
        return Jex.encodeBytes(data, UPPER_BYTES);
    }

    static byte[] encodeBytes(ByteBuffer data, byte[] alpha) {
        byte[] hex = new byte[data.limit() << 1];
        Jex.encodeBytes(data, hex, 0, alpha);
        return hex;
    }

    public static void encodeBytes(ByteBuffer data, byte[] out, int outOffset) {
        Jex.encodeBytes(data, out, outOffset, LOWER_BYTES);
    }

    public static void encodeUpperBytes(ByteBuffer data, byte[] out, int outOffset) {
        Jex.encodeBytes(data, out, outOffset, UPPER_BYTES);
    }

    static void encodeBytes(ByteBuffer data, byte[] out, int outOffset, byte[] alpha) {
        int max = outOffset + (data.limit() << 1);
        while (outOffset < max) {
            int d = data.get() & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
        }
    }

    public static String encode(byte[] data, int offset, int len) {
        return new String(Jex.encode(data, offset, len, LOWER));
    }

    public static String encodeUpper(byte[] data, int offset, int len) {
        return new String(Jex.encode(data, offset, len, UPPER));
    }

    public static char[] encodeChars(byte[] data, int offset, int len) {
        return Jex.encode(data, offset, len, LOWER);
    }

    public static char[] encodeUpperChars(byte[] data, int offset, int len) {
        return Jex.encode(data, offset, len, UPPER);
    }

    private static char[] encode(byte[] data, int offset, int len, char[] alpha) {
        char[] hex = new char[len << 1];
        Jex.encode(data, offset, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeChars(byte[] data, int offset, int len, char[] out, int outOffset) {
        Jex.encode(data, offset, len, out, outOffset, LOWER);
    }

    public static void encodeUpperChars(byte[] data, int offset, int len, char[] out, int outOffset) {
        Jex.encode(data, offset, len, out, outOffset, UPPER);
    }

    private static void encode(byte[] data, int offset, int len, char[] out, int outOffset, char[] alpha) {
        int max = offset + len;
        while (offset < max) {
            int d = data[offset] & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
            ++offset;
        }
    }

    public static String encode(ByteBuffer data, int len) {
        return new String(Jex.encode(data, len, LOWER));
    }

    public static String encodeUpper(ByteBuffer data, int len) {
        return new String(Jex.encode(data, len, UPPER));
    }

    public static char[] encodeChars(ByteBuffer data, int len) {
        return Jex.encode(data, len, LOWER);
    }

    public static char[] encodeUpperChars(ByteBuffer data, int len) {
        return Jex.encode(data, len, UPPER);
    }

    private static char[] encode(ByteBuffer data, int len, char[] alpha) {
        char[] hex = new char[len << 1];
        Jex.encode(data, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeChars(ByteBuffer data, int len, char[] out, int outOffset) {
        Jex.encode(data, len, out, outOffset, LOWER);
    }

    public static void encodeUpperChars(ByteBuffer data, int len, char[] out, int outOffset) {
        Jex.encode(data, len, out, outOffset, UPPER);
    }

    private static void encode(ByteBuffer data, int len, char[] out, int outOffset, char[] alpha) {
        int max = outOffset + (len << 1);
        while (outOffset < max) {
            int d = data.get() & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
        }
    }

    public static byte[] encodeBytes(ByteBuffer data, int len) {
        return Jex.encodeBytes(data, len, LOWER_BYTES);
    }

    public static byte[] encodeUpperBytes(ByteBuffer data, int len) {
        return Jex.encodeBytes(data, len, UPPER_BYTES);
    }

    private static byte[] encodeBytes(ByteBuffer data, int len, byte[] alpha) {
        byte[] hex = new byte[len << 1];
        Jex.encodeBytes(data, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeBytes(ByteBuffer data, int len, byte[] out, int outOffset) {
        Jex.encodeBytes(data, len, out, outOffset, LOWER_BYTES);
    }

    public static void encodeUpperBytes(ByteBuffer data, int len, byte[] out, int outOffset) {
        Jex.encodeBytes(data, len, out, outOffset, UPPER_BYTES);
    }

    private static void encodeBytes(ByteBuffer data, int len, byte[] out, int outOffset, byte[] alpha) {
        int max = outOffset + (len << 1);
        while (outOffset < max) {
            int d = data.get() & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
        }
    }

    public static byte[] encodeBytes(byte[] data, int offset, int len) {
        return Jex.encodeBytes(data, offset, len, LOWER_BYTES);
    }

    public static byte[] encodeUpperBytes(byte[] data, int offset, int len) {
        return Jex.encodeBytes(data, offset, len, UPPER_BYTES);
    }

    static byte[] encodeBytes(byte[] data, int offset, int len, byte[] alpha) {
        byte[] hex = new byte[len << 1];
        Jex.encodeBytes(data, offset, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeBytes(byte[] data, int offset, int len, byte[] out, int outOffset) {
        Jex.encodeBytes(data, offset, len, out, outOffset, LOWER_BYTES);
    }

    public static void encodeUpperBytes(byte[] data, int offset, int len, byte[] out, int outOffset) {
        Jex.encodeBytes(data, offset, len, out, outOffset, UPPER_BYTES);
    }

    static void encodeBytes(byte[] data, int offset, int len, byte[] out, int outOffset, byte[] alpha) {
        int max = offset + len;
        while (offset < max) {
            int d = data[offset] & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
            ++offset;
        }
    }

    public static String encodeReverse(byte[] data, int offset, int len) {
        return new String(Jex.encodeReverse(data, offset, len, LOWER));
    }

    public static String encodeUpperReverse(byte[] data, int offset, int len) {
        return new String(Jex.encodeReverse(data, offset, len, UPPER));
    }

    public static char[] encodeReverseChars(byte[] data, int offset, int len) {
        return Jex.encodeReverse(data, offset, len, LOWER);
    }

    public static char[] encodeUpperReverseChars(byte[] data, int offset, int len) {
        return Jex.encodeReverse(data, offset, len, UPPER);
    }

    private static char[] encodeReverse(byte[] data, int offset, int len, char[] alpha) {
        char[] hex = new char[len << 1];
        Jex.encodeReverse(data, offset, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeReverseChars(byte[] data, int offset, int len, char[] out, int outOffset) {
        Jex.encodeReverse(data, offset, len, out, outOffset, LOWER);
    }

    public static void encodeUpperReverseChars(byte[] data, int offset, int len, char[] out, int outOffset) {
        Jex.encodeReverse(data, offset, len, out, outOffset, UPPER);
    }

    private static void encodeReverse(byte[] data, int offset, int len, char[] out, int outOffset, char[] alpha) {
        int min = offset - len;
        while (offset > min) {
            int d = data[offset] & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
            --offset;
        }
    }

    public static String encodeReverse(ByteBuffer data, int offset, int len) {
        return new String(Jex.encodeReverse(data, offset, len, LOWER));
    }

    public static String encodeUpperReverse(ByteBuffer data, int offset, int len) {
        return new String(Jex.encodeReverse(data, offset, len, UPPER));
    }

    public static char[] encodeReverseChars(ByteBuffer data, int offset, int len) {
        return Jex.encodeReverse(data, offset, len, LOWER);
    }

    public static char[] encodeUpperReverseChars(ByteBuffer data, int offset, int len) {
        return Jex.encodeReverse(data, offset, len, UPPER);
    }

    private static char[] encodeReverse(ByteBuffer data, int offset, int len, char[] alpha) {
        char[] hex = new char[len << 1];
        Jex.encodeReverse(data, offset, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeReverseChars(ByteBuffer data, int offset, int len, char[] out, int outOffset) {
        Jex.encodeReverse(data, offset, len, out, outOffset, LOWER);
    }

    public static void encodeUpperReverseChars(ByteBuffer data, int offset, int len, char[] out, int outOffset) {
        Jex.encodeReverse(data, offset, len, out, outOffset, UPPER);
    }

    private static void encodeReverse(ByteBuffer data, int offset, int len, char[] out, int outOffset, char[] alpha) {
        int min = offset - len;
        while (offset > min) {
            int d = data.get(offset) & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
            --offset;
        }
    }

    public static byte[] encodeReverseBytes(byte[] data, int offset, int len) {
        return Jex.encodeReverseBytes(data, offset, len, LOWER_BYTES);
    }

    public static byte[] encodeUpperReverseBytes(byte[] data, int offset, int len) {
        return Jex.encodeReverseBytes(data, offset, len, UPPER_BYTES);
    }

    static byte[] encodeReverseBytes(byte[] data, int offset, int len, byte[] alpha) {
        byte[] hex = new byte[len << 1];
        Jex.encodeReverseBytes(data, offset, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeReverseBytes(byte[] data, int offset, int len, byte[] out, int outOffset) {
        Jex.encodeReverseBytes(data, offset, len, out, outOffset, LOWER_BYTES);
    }

    public static void encodeUpperReverseBytes(byte[] data, int offset, int len, byte[] out, int outOffset) {
        Jex.encodeReverseBytes(data, offset, len, out, outOffset, UPPER_BYTES);
    }

    static void encodeReverseBytes(byte[] data, int offset, int len, byte[] out, int outOffset, byte[] alpha) {
        int min = offset - len;
        while (offset > min) {
            int d = data[offset] & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
            --offset;
        }
    }

    public static byte[] encodeReverseBytes(ByteBuffer data, int offset, int len) {
        return Jex.encodeReverseBytes(data, offset, len, LOWER_BYTES);
    }

    public static byte[] encodeUpperReverseBytes(ByteBuffer data, int offset, int len) {
        return Jex.encodeReverseBytes(data, offset, len, UPPER_BYTES);
    }

    static byte[] encodeReverseBytes(ByteBuffer data, int offset, int len, byte[] alpha) {
        byte[] hex = new byte[len << 1];
        Jex.encodeReverseBytes(data, offset, len, hex, 0, alpha);
        return hex;
    }

    public static void encodeReverseBytes(ByteBuffer data, int offset, int len, byte[] out, int outOffset) {
        Jex.encodeReverseBytes(data, offset, len, out, outOffset, LOWER_BYTES);
    }

    public static void encodeUpperReverseBytes(ByteBuffer data, int offset, int len, byte[] out, int outOffset) {
        Jex.encodeReverseBytes(data, offset, len, out, outOffset, UPPER_BYTES);
    }

    static void encodeReverseBytes(ByteBuffer data, int offset, int len, byte[] out, int outOffset, byte[] alpha) {
        int min = offset - len;
        while (offset > min) {
            int d = data.get(offset) & 0xFF;
            out[outOffset++] = alpha[d >>> 4];
            out[outOffset++] = alpha[d & 0xF];
            --offset;
        }
    }

    public static boolean isValid(CharSequence hex) {
        if (hex == null) {
            return false;
        }
        int len = hex.length();
        if ((len & 1) != 0) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int index = 0;
        do {
            char chr;
            if ((chr = hex.charAt(index++)) > 'f' || DIGITS[chr] == -1) {
                return false;
            }
            if ((chr = hex.charAt(index++)) <= 'f' && DIGITS[chr] != -1) continue;
            return false;
        } while (index < len);
        return true;
    }

    public static boolean isLengthValid(CharSequence hex) {
        return hex != null && (hex.length() & 1) == 0;
    }

    public static byte[] decode(CharSequence chars) {
        byte[] data = new byte[chars.length() >> 1];
        if (data.length == 0) {
            return data;
        }
        int i = 0;
        int c = 0;
        while (true) {
            data[i++] = (byte)(DIGITS[chars.charAt(c)] << 4 | DIGITS[chars.charAt(++c)]);
            if (i == data.length) {
                return data;
            }
            ++c;
        }
    }

    public static byte[] decode(char[] chars) {
        byte[] data = new byte[chars.length >> 1];
        if (data.length == 0) {
            return data;
        }
        int i = 0;
        int c = 0;
        while (true) {
            data[i++] = (byte)(DIGITS[chars[c]] << 4 | DIGITS[chars[++c]]);
            if (i == data.length) {
                return data;
            }
            ++c;
        }
    }

    public static byte[] decode(byte[] chars) {
        byte[] data = new byte[chars.length >> 1];
        if (data.length == 0) {
            return data;
        }
        int i = 0;
        int c = 0;
        while (true) {
            data[i++] = (byte)(DIGITS[chars[c]] << 4 | DIGITS[chars[++c]]);
            if (i == data.length) {
                return data;
            }
            ++c;
        }
    }

    public static byte[] decode(ByteBuffer chars) {
        byte[] data = new byte[chars.limit() >> 1];
        if (data.length == 0) {
            return data;
        }
        int index = 0;
        do {
            data[index++] = (byte)(DIGITS[chars.get()] << 4 | DIGITS[chars.get()]);
        } while (index < data.length);
        return data;
    }

    public static byte[] decodeChecked(CharSequence chars) {
        int len = chars.length();
        if (len == 0) {
            return new byte[0];
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        byte[] data = new byte[len >> 1];
        int i = 0;
        int c = 0;
        while (true) {
            char chr;
            if ((chr = chars.charAt(c)) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            int bite = DIGITS[chr] << 4;
            if ((chr = chars.charAt(++c)) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            data[i++] = (byte)(bite | DIGITS[chr]);
            if (i == data.length) {
                return data;
            }
            ++c;
        }
    }

    static byte[] decodeCheckedToCharArray(String hex) {
        return Jex.decodeChecked(hex.toCharArray());
    }

    public static byte[] decodeChecked(char[] chars) {
        if (chars.length == 0) {
            return new byte[0];
        }
        if ((chars.length & 1) != 0) {
            throw Jex.createIllegalLengthException(chars.length);
        }
        byte[] data = new byte[chars.length >> 1];
        int i = 0;
        int c = 0;
        while (true) {
            char chr;
            if ((chr = chars[c]) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            int bite = DIGITS[chr] << 4;
            if ((chr = chars[++c]) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            data[i++] = (byte)(bite | DIGITS[chr]);
            if (i == data.length) {
                return data;
            }
            ++c;
        }
    }

    public static byte[] decodeChecked(byte[] chars) {
        if (chars.length == 0) {
            return new byte[0];
        }
        if ((chars.length & 1) != 0) {
            throw Jex.createIllegalLengthException(chars.length);
        }
        byte[] data = new byte[chars.length >> 1];
        int i = 0;
        int c = 0;
        while (true) {
            byte chr;
            if ((chr = chars[c]) > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            int bite = DIGITS[chr] << 4;
            if ((chr = chars[++c]) > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            data[i++] = (byte)(bite | DIGITS[chr]);
            if (i == data.length) {
                return data;
            }
            ++c;
        }
    }

    public static byte[] decodeChecked(ByteBuffer chars) {
        int len = chars.limit();
        if (len == 0) {
            return new byte[0];
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        byte[] data = new byte[len >> 1];
        int i = 0;
        do {
            byte chr;
            if ((chr = chars.get()) > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, i * 2);
            }
            int bite = DIGITS[chr] << 4;
            chr = chars.get();
            if (chr > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, i * 2 + 1);
            }
            data[i++] = (byte)(bite | DIGITS[chr]);
        } while (i != data.length);
        return data;
    }

    public static void decode(CharSequence chars, byte[] out, int offset) {
        int c = 0;
        int len = chars.length();
        while (c < len) {
            out[offset++] = (byte)(DIGITS[chars.charAt(c++)] << 4 | DIGITS[chars.charAt(c++)]);
        }
    }

    static void decodeToCharArray(String hex, byte[] out, int offset) {
        Jex.decode(hex.toCharArray(), out, offset);
    }

    public static void decode(char[] chars, byte[] out, int offset) {
        Jex.decode(chars, 0, chars.length, out, offset);
    }

    public static void decode(char[] chars, int offset, int len, byte[] out, int outOffset) {
        while (offset < len) {
            out[outOffset++] = (byte)(DIGITS[chars[offset++]] << 4 | DIGITS[chars[offset++]]);
        }
    }

    public static void decodeChecked(CharSequence chars, byte[] out, int offset) {
        int len = chars.length();
        if (len == 0) {
            return;
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        int c = 0;
        while (true) {
            char chr;
            if ((chr = chars.charAt(c)) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            int bite = DIGITS[chr] << 4;
            if ((chr = chars.charAt(++c)) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, c);
            }
            out[offset] = (byte)(bite | DIGITS[chr]);
            if (++c == len) {
                return;
            }
            ++offset;
        }
    }

    static void decodeCheckedToCharArray(String hex, byte[] out, int offset) {
        Jex.decodeChecked(hex.toCharArray(), out, offset);
    }

    public static void decodeChecked(char[] chars, byte[] out, int offset) {
        Jex.decodeChecked(chars, 0, chars.length, out, offset);
    }

    public static void decodeChecked(char[] chars, int offset, int len, byte[] out, int outOffset) {
        if (len == 0) {
            return;
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        while (true) {
            char chr;
            if ((chr = chars[offset]) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, offset);
            }
            int bite = DIGITS[chr] << 4;
            if ((chr = chars[++offset]) > 'f' || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, offset);
            }
            out[outOffset] = (byte)(bite | DIGITS[chr]);
            if (++offset == len) {
                return;
            }
            ++outOffset;
        }
    }

    public static void decodeChecked(byte[] chars, byte[] out, int offset) {
        Jex.decodeChecked(chars, 0, chars.length, out, offset);
    }

    public static void decodeChecked(byte[] chars, int offset, int len, byte[] out, int outOffset) {
        if (len == 0) {
            return;
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        while (true) {
            byte chr;
            if ((chr = chars[offset]) > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, offset);
            }
            int bite = DIGITS[chr] << 4;
            if ((chr = chars[++offset]) > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, offset);
            }
            out[outOffset] = (byte)(bite | DIGITS[chr]);
            if (++offset == len) {
                return;
            }
            ++outOffset;
        }
    }

    public static void decodeChecked(ByteBuffer buffer, byte[] out, int offset) {
        Jex.decodeChecked(buffer, 0, buffer.limit(), out, offset);
    }

    public static void decodeChecked(ByteBuffer buffer, int offset, int len, byte[] out, int outOffset) {
        if (len == 0) {
            return;
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        while (true) {
            byte chr;
            if ((chr = buffer.get()) > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, offset);
            }
            int bite = DIGITS[chr] << 4;
            chr = buffer.get();
            if (chr > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException(chr, ++offset);
            }
            out[outOffset] = (byte)(bite | DIGITS[chr]);
            if ((offset += 2) == len) {
                return;
            }
            ++outOffset;
        }
    }

    public static byte[] decodePrimIter(CharSequence hex) {
        byte[] data = new byte[hex.length() >> 1];
        if (data.length == 0) {
            return data;
        }
        PrimitiveIterator.OfInt chars = hex.chars().iterator();
        int index = 0;
        do {
            data[index++] = (byte)(DIGITS[chars.nextInt()] << 4 | DIGITS[chars.nextInt()]);
        } while (index < data.length);
        return data;
    }

    public static byte[] decodePrimIterChecked(CharSequence hex) {
        int len = hex.length();
        if (len == 0) {
            return new byte[0];
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        byte[] data = new byte[len >> 1];
        PrimitiveIterator.OfInt chars = hex.chars().iterator();
        int index = 0;
        while (index < data.length) {
            int chr = chars.nextInt();
            if (chr > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException((char)chr, index * 2);
            }
            int bite = DIGITS[chr] << 4;
            chr = chars.nextInt();
            if (chr > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException((char)chr, index * 2 + 1);
            }
            data[index++] = (byte)(bite | DIGITS[chr]);
        }
        return data;
    }

    public static void decodePrimIter(CharSequence hex, byte[] out, int offset) {
        PrimitiveIterator.OfInt chars = hex.chars().iterator();
        int max = offset + (hex.length() >> 1);
        while (offset < max) {
            out[offset++] = (byte)(DIGITS[chars.nextInt()] << 4 | DIGITS[chars.nextInt()]);
        }
    }

    public static void decodePrimIterChecked(CharSequence hex, byte[] out, int offset) {
        int len = hex.length();
        if (len == 0) {
            return;
        }
        if ((len & 1) != 0) {
            throw Jex.createIllegalLengthException(len);
        }
        PrimitiveIterator.OfInt chars = hex.chars().iterator();
        int index = 0;
        while (chars.hasNext()) {
            int chr = chars.nextInt();
            if (chr > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException((char)chr, index);
            }
            int bite = DIGITS[chr] << 4;
            chr = chars.nextInt();
            if (chr > 102 || DIGITS[chr] == -1) {
                throw Jex.createIllegalCharException((char)chr, index + 1);
            }
            out[offset++] = (byte)(bite | DIGITS[chr]);
            index += 2;
        }
    }

    private Jex() {
    }

    static {
        Arrays.fill(DIGITS, -1);
        for (char c : LOWER) {
            Jex.DIGITS[c] = Character.digit(c, 16);
        }
        for (int i = 10; i < UPPER.length; ++i) {
            char c = UPPER[i];
            Jex.DIGITS[c] = Character.digit(c, 16);
        }
    }
}

