/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.tx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.Signer;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.encoding.Base58;
import software.sava.core.encoding.CompactU16Encoding;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.TransactionRecord;

public interface Transaction {
    public static final int MAX_SERIALIZED_LENGTH = 1232;
    public static final int MAX_BASE_64_ENCODED_LENGTH = 1683;
    public static final int SIGNATURE_LENGTH = 64;
    public static final int BLOCK_HASH_LENGTH = 32;
    public static final int MAX_ACCOUNTS = 64;
    public static final int BLOCK_QUEUE_SIZE = 151;
    public static final int BLOCKS_UNTIL_FINALIZED = 32;
    public static final BiFunction<AccountMeta, AccountMeta, AccountMeta> MERGE_ACCOUNT_META = (prev, add) -> prev == null ? add : prev.merge((AccountMeta)add);
    public static final Comparator<AccountMeta> LEGACY_META_COMPARATOR = (am1, am2) -> {
        if (am1.feePayer()) {
            return -1;
        }
        if (am2.feePayer()) {
            return 1;
        }
        if (am1.signer() == am2.signer()) {
            if (am1.write() == am2.write()) {
                return 0;
            }
            return am1.write() ? -1 : 1;
        }
        return am1.signer() ? -1 : 1;
    };
    public static final Comparator<AccountMeta> VO_META_COMPARATOR = (am1, am2) -> {
        if (am1.feePayer()) {
            return -1;
        }
        if (am2.feePayer()) {
            return 1;
        }
        if (am1.signer() == am2.signer()) {
            if (am1.write() == am2.write()) {
                return am1.invoked() == am2.invoked() ? 0 : (am1.invoked() ? -1 : 1);
            }
            return am1.write() ? -1 : 1;
        }
        return am1.signer() ? -1 : 1;
    };
    public static final int MSG_HEADER_LENGTH = 3;
    public static final int VERSIONED_MSG_HEADER_LENGTH = 4;
    public static final byte VERSIONED_BIT_MASK = -128;
    public static final int BASE_LOOKUP_TABLE_LEN = 34;

    public static String getBase58Id(byte[] signedTransaction) {
        if (signedTransaction[0] == 0) {
            throw new IllegalStateException("Transaction has not been signed yet.");
        }
        return Base58.encode(signedTransaction, 1, 65);
    }

    public static byte[] getId(byte[] signedTransaction) {
        if (signedTransaction[0] == 0) {
            throw new IllegalStateException("Transaction has not been signed yet.");
        }
        return Arrays.copyOfRange(signedTransaction, 1, 65);
    }

    public static AccountMeta[] sortLegacyAccounts(Map<PublicKey, AccountMeta> mergedAccounts) {
        AccountMeta[] accountMetas = (AccountMeta[])mergedAccounts.values().toArray(AccountMeta.ACCOUNT_META_ARRAY_GENERATOR);
        Arrays.sort(accountMetas, LEGACY_META_COMPARATOR);
        return accountMetas;
    }

    public static Transaction createTx(PublicKey feePayer, List<Instruction> instructions) {
        return Transaction.createTx(feePayer == null ? null : AccountMeta.createFeePayer(feePayer), instructions);
    }

    private static int mergeAccounts(AccountMeta feePayer, Map<PublicKey, AccountMeta> accounts, List<Instruction> instructions) {
        int numInstructions = instructions.size();
        if (numInstructions == 0) {
            throw new IllegalArgumentException("No instructions provided");
        }
        if (feePayer != null) {
            accounts.put(feePayer.publicKey(), feePayer);
        }
        int serializedInstructionLength = 0;
        for (Instruction instruction : instructions) {
            serializedInstructionLength += instruction.serializedLength();
            for (AccountMeta meta : instruction.accounts()) {
                accounts.merge(meta.publicKey(), meta, MERGE_ACCOUNT_META);
            }
            AccountMeta programMeta = instruction.programId();
            accounts.merge(programMeta.publicKey(), programMeta, MERGE_ACCOUNT_META);
        }
        return serializedInstructionLength;
    }

    public static Transaction createTx(AccountMeta feePayer, List<Instruction> instructions) {
        HashMap<PublicKey, AccountMeta> accounts = HashMap.newHashMap(64);
        int serializedInstructionLength = Transaction.mergeAccounts(feePayer, accounts, instructions);
        return Transaction.createTx(instructions, serializedInstructionLength, Transaction.sortLegacyAccounts(accounts));
    }

    public static Transaction createTx(AccountMeta feePayer, Instruction instruction) {
        return Transaction.createTx(feePayer, List.of(instruction));
    }

    public static Transaction createTx(List<Instruction> instructions) {
        return Transaction.createTx((AccountMeta)null, instructions);
    }

    public static Transaction createTx(AccountMeta feePayer, List<Instruction> instructions, AddressLookupTable lookupTable) {
        if (lookupTable == null) {
            return Transaction.createTx(feePayer, instructions);
        }
        HashMap<PublicKey, AccountMeta> accounts = HashMap.newHashMap(64);
        int serializedInstructionLength = Transaction.mergeAccounts(feePayer, accounts, instructions);
        return Transaction.createTx(instructions, serializedInstructionLength, Transaction.sortV0Accounts(accounts), lookupTable);
    }

    public static Transaction createTx(PublicKey feePayer, List<Instruction> instructions, AddressLookupTable lookupTable) {
        return Transaction.createTx(feePayer == null ? null : AccountMeta.createFeePayer(feePayer), instructions, lookupTable);
    }

    public static Transaction createTx(AccountMeta feePayer, List<Instruction> instructions, AddressLookupTable lookupTable, LookupTableAccountMeta[] tableAccountMetas) {
        if (tableAccountMetas == null || tableAccountMetas.length == 0) {
            return Transaction.createTx(feePayer, instructions, lookupTable);
        }
        if (lookupTable != null) {
            throw new IllegalStateException("Use either a single lookup table or multiple account metas, not both");
        }
        return Transaction.createTx(feePayer, instructions, tableAccountMetas);
    }

    public static Transaction createTx(List<Instruction> instructions, AddressLookupTable lookupTable) {
        return Transaction.createTx((AccountMeta)null, instructions, lookupTable);
    }

    public static Transaction createTx(PublicKey feePayer, List<Instruction> instructions, Instruction ... push) {
        ArrayList<Instruction> pushed = new ArrayList<Instruction>(instructions.size() + push.length);
        Collections.addAll(pushed, push);
        pushed.addAll(instructions);
        return Transaction.createTx(feePayer, pushed);
    }

    public static Transaction createTx(List<Instruction> instructions, Instruction ... push) {
        return Transaction.createTx(null, instructions, push);
    }

    public static Transaction createTx(PublicKey feePayer, Instruction instruction) {
        return Transaction.createTx(feePayer, List.of(instruction));
    }

    public static Transaction createTx(Instruction instruction) {
        return Transaction.createTx((AccountMeta)null, instruction);
    }

    public static Transaction createTx(List<Instruction> instructions, AccountMeta[] sortedAccountKeys) {
        if (instructions.isEmpty()) {
            throw new IllegalArgumentException("No instructions provided");
        }
        int serializedInstructionLength = instructions.stream().mapToInt(Instruction::serializedLength).sum();
        return Transaction.createTx(instructions, serializedInstructionLength, sortedAccountKeys);
    }

    public static Transaction createTx(Instruction instruction, AccountMeta[] sortedAccountKeys) {
        return Transaction.createTx(List.of(instruction), instruction.serializedLength(), sortedAccountKeys);
    }

    public static Transaction createTx(Instruction[] instructions, int serializedInstructionLength, Map<PublicKey, AccountMeta> mergedAccounts) {
        return Transaction.createTx(Arrays.asList(instructions), serializedInstructionLength, Transaction.sortV0Accounts(mergedAccounts));
    }

    public static Transaction createTx(List<Instruction> instructions, int serializedInstructionLength, AccountMeta[] sortedAccounts) {
        int numAccounts = sortedAccounts.length;
        HashMap<PublicKey, Integer> accountIndexLookupTable = HashMap.newHashMap(numAccounts);
        int numRequiredSignatures = 0;
        int numReadonlySignedAccounts = 0;
        int numReadonlyUnsignedAccounts = 0;
        AccountMeta feePayer = null;
        for (int i = 0; i < numAccounts; ++i) {
            AccountMeta accountMeta = sortedAccounts[i];
            accountIndexLookupTable.put(accountMeta.publicKey(), i);
            if (accountMeta.signer()) {
                if (accountMeta.feePayer()) {
                    feePayer = accountMeta;
                }
                ++numRequiredSignatures;
                if (accountMeta.write()) continue;
                ++numReadonlySignedAccounts;
                continue;
            }
            if (accountMeta.write()) continue;
            ++numReadonlyUnsignedAccounts;
        }
        int sigLen = 1 + (numRequiredSignatures << 6);
        int numInstructions = instructions.size();
        int bufferSize = sigLen + 3 + CompactU16Encoding.getByteLen(numAccounts) + (numAccounts << 5) + 32 + CompactU16Encoding.getByteLen(numInstructions) + serializedInstructionLength;
        byte[] out = new byte[bufferSize];
        out[0] = (byte)numRequiredSignatures;
        int i = sigLen;
        out[i] = (byte)numRequiredSignatures;
        out[++i] = (byte)numReadonlySignedAccounts;
        out[++i] = (byte)numReadonlyUnsignedAccounts;
        ++i;
        i += CompactU16Encoding.encodeLength(out, i, numAccounts);
        int accountsOffset = i;
        for (AccountMeta accountMeta : sortedAccounts) {
            i += accountMeta.publicKey().write(out, i);
        }
        int recentBlockHashIndex = i;
        i += 32;
        i += CompactU16Encoding.encodeLength(out, i, numInstructions);
        for (Instruction instruction : instructions) {
            i = instruction.serialize(out, i, accountIndexLookupTable);
        }
        return new TransactionRecord(feePayer, instructions, null, TransactionRecord.NO_TABLES, out, numRequiredSignatures, sigLen, accountsOffset, recentBlockHashIndex);
    }

    public static AccountMeta[] sortV0Accounts(Map<PublicKey, AccountMeta> mergedAccounts) {
        AccountMeta[] accountMetas = (AccountMeta[])mergedAccounts.values().toArray(AccountMeta.ACCOUNT_META_ARRAY_GENERATOR);
        Arrays.sort(accountMetas, VO_META_COMPARATOR);
        return accountMetas;
    }

    public static Transaction createTx(List<Instruction> instructions, int serializedInstructionLength, Map<PublicKey, AccountMeta> mergedAccounts, AddressLookupTable lookupTable) {
        if (lookupTable == null) {
            return Transaction.createTx(instructions, serializedInstructionLength, Transaction.sortLegacyAccounts(mergedAccounts));
        }
        return Transaction.createTx(instructions, serializedInstructionLength, Transaction.sortV0Accounts(mergedAccounts), lookupTable);
    }

    public static Transaction createTx(List<Instruction> instructions, int serializedInstructionLength, AccountMeta[] sortedAccounts, AddressLookupTable lookupTable) {
        if (lookupTable == null) {
            return Transaction.createTx(instructions, serializedInstructionLength, sortedAccounts);
        }
        int numAccounts = sortedAccounts.length;
        HashMap<PublicKey, Integer> accountIndexLookupTable = HashMap.newHashMap(numAccounts);
        int numRequiredSignatures = 0;
        int numReadonlySignedAccounts = 0;
        int numReadonlyUnsignedAccounts = 0;
        AccountMeta feePayer = null;
        int numLookupReads = 0;
        int numLookupWrites = 0;
        int numIncludedAccounts = 0;
        for (int i = 0; i < numAccounts; ++i) {
            AccountMeta account = sortedAccounts[i];
            if (account.signer()) {
                if (account.feePayer()) {
                    feePayer = account;
                }
                if (!account.write()) {
                    ++numReadonlySignedAccounts;
                }
                ++numRequiredSignatures;
            } else if (account.invoked() || lookupTable.indexOf(account.publicKey()) < 0) {
                if (!account.write()) {
                    ++numReadonlyUnsignedAccounts;
                }
                if (i > numIncludedAccounts) {
                    int len = i - numIncludedAccounts;
                    if (len == 1) {
                        sortedAccounts[i] = sortedAccounts[numIncludedAccounts];
                    } else {
                        System.arraycopy(sortedAccounts, numIncludedAccounts, sortedAccounts, numIncludedAccounts + 1, len);
                    }
                    sortedAccounts[numIncludedAccounts] = account;
                }
            } else {
                if (account.write()) {
                    ++numLookupWrites;
                    continue;
                }
                ++numLookupReads;
                continue;
            }
            accountIndexLookupTable.put(account.publicKey(), numIncludedAccounts);
            ++numIncludedAccounts;
        }
        for (int a = numIncludedAccounts; a < numAccounts; ++a) {
            accountIndexLookupTable.put(sortedAccounts[a].publicKey(), a);
        }
        int numTableIndexedAccounts = numLookupReads + numLookupWrites;
        int sigLen = 1 + (numRequiredSignatures << 6);
        int bufferSize = sigLen + 4 + CompactU16Encoding.getByteLen(numIncludedAccounts) + (numIncludedAccounts << 5) + 32 + CompactU16Encoding.getByteLen(instructions.size()) + serializedInstructionLength + (numTableIndexedAccounts > 0 ? 35 + numTableIndexedAccounts : 1);
        byte[] out = new byte[bufferSize];
        out[0] = (byte)numRequiredSignatures;
        int i = sigLen;
        out[i] = -128;
        out[++i] = (byte)numRequiredSignatures;
        out[++i] = (byte)numReadonlySignedAccounts;
        out[++i] = (byte)numReadonlyUnsignedAccounts;
        ++i;
        i += CompactU16Encoding.encodeLength(out, i, numIncludedAccounts);
        int accountsOffset = i;
        for (int a = 0; a < numIncludedAccounts; ++a) {
            i += sortedAccounts[a].publicKey().write(out, i);
        }
        int recentBlockHashIndex = i;
        i += 32;
        i += CompactU16Encoding.encodeLength(out, i, instructions.size());
        for (Instruction instruction : instructions) {
            i = instruction.serialize(out, i, accountIndexLookupTable);
        }
        if (numTableIndexedAccounts > 0) {
            i += CompactU16Encoding.encodeLength(out, i, 1);
            i += lookupTable.address().write(out, i);
            i += CompactU16Encoding.encodeLength(out, i, numLookupWrites);
            int a = numIncludedAccounts;
            int to = numIncludedAccounts + numLookupWrites;
            while (a < to) {
                out[i] = lookupTable.indexOfOrThrow(sortedAccounts[a].publicKey());
                ++a;
                ++i;
            }
            i += CompactU16Encoding.encodeLength(out, i, numLookupReads);
            while (a < numAccounts) {
                out[i] = lookupTable.indexOfOrThrow(sortedAccounts[a].publicKey());
                ++a;
                ++i;
            }
            return new TransactionRecord(feePayer, instructions, lookupTable, TransactionRecord.NO_TABLES, out, numRequiredSignatures, sigLen, accountsOffset, recentBlockHashIndex);
        }
        CompactU16Encoding.encodeLength(out, i, 0);
        return new TransactionRecord(feePayer, instructions, null, TransactionRecord.NO_TABLES, out, numRequiredSignatures, sigLen, accountsOffset, recentBlockHashIndex);
    }

    public static Transaction createTx(AccountMeta feePayer, List<Instruction> instructions, LookupTableAccountMeta[] tableAccountMetas) {
        HashMap<PublicKey, AccountMeta> accounts = HashMap.newHashMap(64);
        int serializedInstructionLength = Transaction.mergeAccounts(feePayer, accounts, instructions);
        return Transaction.createTx(instructions, serializedInstructionLength, accounts, tableAccountMetas);
    }

    public static Transaction createTx(PublicKey feePayer, List<Instruction> instructions, LookupTableAccountMeta[] tableAccountMetas) {
        return Transaction.createTx(feePayer == null ? null : AccountMeta.createFeePayer(feePayer), instructions, tableAccountMetas);
    }

    public static Transaction createTx(List<Instruction> instructions, int serializedInstructionLength, Map<PublicKey, AccountMeta> mergedAccounts, LookupTableAccountMeta[] tableAccountMetas) {
        if (tableAccountMetas == null || tableAccountMetas.length == 0) {
            return Transaction.createTx(instructions, serializedInstructionLength, Transaction.sortLegacyAccounts(mergedAccounts));
        }
        return Transaction.createTx(instructions, serializedInstructionLength, Transaction.sortV0Accounts(mergedAccounts), tableAccountMetas);
    }

    public static Transaction createTx(List<Instruction> instructions, int serializedInstructionLength, AccountMeta[] sortedAccounts, LookupTableAccountMeta[] tableAccountMetas) {
        int numLookupTables = tableAccountMetas.length;
        if (numLookupTables == 0) {
            return Transaction.createTx(instructions);
        }
        if (numLookupTables == 1) {
            return Transaction.createTx(instructions, serializedInstructionLength, sortedAccounts, tableAccountMetas[0].lookupTable());
        }
        for (LookupTableAccountMeta lookupTable : tableAccountMetas) {
            lookupTable.reset();
        }
        int numAccounts = sortedAccounts.length;
        HashMap<PublicKey, Integer> accountIndexLookupTable = HashMap.newHashMap(numAccounts);
        int numRequiredSignatures = 0;
        int numReadonlySignedAccounts = 0;
        int numReadonlyUnsignedAccounts = 0;
        int numIncludedAccounts = 0;
        AccountMeta feePayer = null;
        block1: for (int i = 0; i < numAccounts; ++i) {
            AccountMeta account = sortedAccounts[i];
            if (account.signer()) {
                if (account.feePayer()) {
                    feePayer = account;
                }
                if (!account.write()) {
                    ++numReadonlySignedAccounts;
                }
                ++numRequiredSignatures;
            } else {
                if (!account.invoked()) {
                    for (LookupTableAccountMeta lookupTable : tableAccountMetas) {
                        if (lookupTable.addAccountIfExists(account)) continue block1;
                    }
                }
                if (!account.write()) {
                    ++numReadonlyUnsignedAccounts;
                }
                if (i > numIncludedAccounts) {
                    int len = i - numIncludedAccounts;
                    if (len == 1) {
                        sortedAccounts[i] = sortedAccounts[numIncludedAccounts];
                    } else {
                        System.arraycopy(sortedAccounts, numIncludedAccounts, sortedAccounts, numIncludedAccounts + 1, len);
                    }
                    sortedAccounts[numIncludedAccounts] = account;
                }
            }
            accountIndexLookupTable.put(account.publicKey(), numIncludedAccounts);
            ++numIncludedAccounts;
        }
        int tai = numIncludedAccounts;
        for (LookupTableAccountMeta tableAccountMeta : tableAccountMetas) {
            tai = tableAccountMeta.indexWrites(accountIndexLookupTable, tai);
        }
        for (LookupTableAccountMeta tableAccountMeta : tableAccountMetas) {
            tai = tableAccountMeta.indexReads(accountIndexLookupTable, tai);
        }
        int numTablesWithIndexedAccounts = 0;
        for (LookupTableAccountMeta tableAccountMeta : tableAccountMetas) {
            if (tableAccountMeta.numIndexed() <= 0) continue;
            ++numTablesWithIndexedAccounts;
        }
        int sigLen = 1 + (numRequiredSignatures << 6);
        int bufferSize = sigLen + 4 + CompactU16Encoding.getByteLen(numIncludedAccounts) + (numIncludedAccounts << 5) + 32 + CompactU16Encoding.getByteLen(instructions.size()) + serializedInstructionLength + (1 + numTablesWithIndexedAccounts * 34 + (numAccounts - numIncludedAccounts));
        byte[] out = new byte[bufferSize];
        out[0] = (byte)numRequiredSignatures;
        int i = sigLen;
        out[i] = -128;
        out[++i] = (byte)numRequiredSignatures;
        out[++i] = (byte)numReadonlySignedAccounts;
        out[++i] = (byte)numReadonlyUnsignedAccounts;
        ++i;
        i += CompactU16Encoding.encodeLength(out, i, numIncludedAccounts);
        int accountsOffset = i;
        for (int a = 0; a < numIncludedAccounts; ++a) {
            i += sortedAccounts[a].publicKey().write(out, i);
        }
        int recentBlockHashIndex = i;
        i += 32;
        i += CompactU16Encoding.encodeLength(out, i, instructions.size());
        for (Instruction instruction : instructions) {
            i = instruction.serialize(out, i, accountIndexLookupTable);
        }
        i += CompactU16Encoding.encodeLength(out, i, numTablesWithIndexedAccounts);
        if (numLookupTables == numTablesWithIndexedAccounts) {
            for (LookupTableAccountMeta tableAccountMeta : tableAccountMetas) {
                i = tableAccountMeta.serialize(out, i);
            }
            return new TransactionRecord(feePayer, instructions, null, tableAccountMetas, out, numRequiredSignatures, sigLen, accountsOffset, recentBlockHashIndex);
        }
        LookupTableAccountMeta[] usedTables = new LookupTableAccountMeta[numTablesWithIndexedAccounts];
        int t = 0;
        for (LookupTableAccountMeta tableAccountMeta : tableAccountMetas) {
            if (tableAccountMeta.numIndexed() <= 0) continue;
            i = tableAccountMeta.serialize(out, i);
            usedTables[t++] = tableAccountMeta;
        }
        return new TransactionRecord(feePayer, instructions, null, usedTables, out, numRequiredSignatures, sigLen, accountsOffset, recentBlockHashIndex);
    }

    public static void setBlockHash(byte[] data, byte[] recentBlockHash) {
        int versionOffset;
        int numSigners = Byte.toUnsignedInt(data[0]);
        int accountMetaOffset = versionOffset + (CompactU16Encoding.signedByte(data[versionOffset = 1 + numSigners * 64]) ? 4 : 3);
        int accountMetaByteLen = CompactU16Encoding.getByteLen(data, accountMetaOffset);
        int accountMetaLen = CompactU16Encoding.decode(data, accountMetaOffset) * 32;
        int recentBlockHashOffset = accountMetaOffset + accountMetaByteLen + accountMetaLen;
        System.arraycopy(recentBlockHash, 0, data, recentBlockHashOffset, 32);
    }

    public static void sign(Signer signer, byte[] out, int msgOffset, int msgLen, int offset) {
        signer.sign(out, msgOffset, msgLen, offset);
    }

    public static void sign(Signer signer, byte[] out) {
        out[0] = 1;
        int sigLen = 65;
        int msgLen = out.length - 65;
        Transaction.sign(signer, out, 65, msgLen, 1);
    }

    public static String signAndBase64Encode(Signer signer, byte[] out) {
        Transaction.sign(signer, out);
        return Base64.getEncoder().encodeToString(out);
    }

    public static void sign(SequencedCollection<Signer> signers, byte[] out, int msgOffset, int msgLen, int offset) {
        for (Signer signer : signers) {
            offset = signer.sign(out, msgOffset, msgLen, offset);
        }
    }

    public static void sign(SequencedCollection<Signer> signers, byte[] out) {
        int numSigners = signers.size();
        out[0] = (byte)numSigners;
        int sigLen = 1 + numSigners * 64;
        int msgLen = out.length - sigLen;
        Transaction.sign(signers, out, sigLen, msgLen, 1);
    }

    public static String signAndBase64Encode(SequencedCollection<Signer> signers, byte[] out) {
        Transaction.sign(signers, out);
        return Base64.getEncoder().encodeToString(out);
    }

    default public String base64EncodeToString() {
        return Base64.getEncoder().encodeToString(this.serialized());
    }

    public void sign(Signer var1);

    public void sign(int var1, Signer var2);

    default public String signAndBase64Encode(Signer signer) {
        this.sign(signer);
        return this.base64EncodeToString();
    }

    default public void sign(byte[] recentBlockHash, Signer signer) {
        this.setRecentBlockHash(recentBlockHash);
        this.sign(signer);
    }

    default public void sign(String recentBlockHash, Signer signer) {
        this.sign(Base58.decode(recentBlockHash), signer);
    }

    default public String signAndBase64Encode(byte[] recentBlockHash, Signer signer) {
        this.sign(recentBlockHash, signer);
        return this.base64EncodeToString();
    }

    default public String signAndBase64Encode(String recentBlockHash, Signer signer) {
        return this.signAndBase64Encode(Base58.decode(recentBlockHash), signer);
    }

    public void sign(Collection<Signer> var1);

    public void sign(SequencedCollection<Signer> var1);

    default public String signAndBase64Encode(SequencedCollection<Signer> signers) {
        this.sign(signers);
        return this.base64EncodeToString();
    }

    default public void sign(byte[] recentBlockHash, SequencedCollection<Signer> signers) {
        this.setRecentBlockHash(recentBlockHash);
        this.sign(signers);
    }

    default public void sign(String recentBlockHash, SequencedCollection<Signer> signers) {
        this.setRecentBlockHash(recentBlockHash);
        this.sign(signers);
    }

    default public String signAndBase64Encode(byte[] recentBlockHash, SequencedCollection<Signer> signers) {
        this.sign(recentBlockHash, signers);
        return this.base64EncodeToString();
    }

    default public String signAndBase64Encode(String recentBlockHash, SequencedCollection<Signer> signers) {
        this.sign(recentBlockHash, signers);
        return this.base64EncodeToString();
    }

    public String getBase58Id();

    public byte[] getId();

    public int size();

    default public boolean exceedsSizeLimit() {
        return this.size() > 1232;
    }

    public List<Instruction> instructions();

    public AddressLookupTable lookupTable();

    public LookupTableAccountMeta[] tableAccountMetas();

    public void setRecentBlockHash(byte[] var1);

    public void setRecentBlockHash(String var1);

    public byte[] recentBlockHash();

    public int version();

    public int numSigners();

    public byte[] serialized();

    public Transaction prependIx(Instruction var1);

    public Transaction prependInstructions(Instruction var1, Instruction var2);

    public Transaction prependInstructions(SequencedCollection<Instruction> var1);

    public Transaction appendIx(Instruction var1);

    public Transaction appendInstructions(SequencedCollection<Instruction> var1);

    public Transaction replaceInstruction(int var1, Instruction var2);

    public AccountMeta feePayer();
}

