/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.tx;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SequencedCollection;
import software.sava.core.accounts.Signer;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.encoding.Base58;
import software.sava.core.encoding.CompactU16Encoding;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;

record TransactionRecord(AccountMeta feePayer, List<Instruction> instructions, AddressLookupTable lookupTable, LookupTableAccountMeta[] tableAccountMetas, byte[] data, int numSigners, int messageOffset, int accountsOffset, int recentBlockHashIndex) implements Transaction
{
    static final LookupTableAccountMeta[] NO_TABLES = new LookupTableAccountMeta[0];

    @Override
    public void setRecentBlockHash(byte[] recentBlockHash) {
        if (recentBlockHash == null || recentBlockHash.length != 32) {
            throw new IllegalArgumentException("32 byte recent blockHash is required");
        }
        System.arraycopy(recentBlockHash, 0, this.data, this.recentBlockHashIndex, 32);
    }

    @Override
    public void setRecentBlockHash(String recentBlockHash) {
        this.setRecentBlockHash(Base58.decode(recentBlockHash));
    }

    @Override
    public byte[] recentBlockHash() {
        return Arrays.copyOfRange(this.data, this.recentBlockHashIndex, this.recentBlockHashIndex + 32);
    }

    @Override
    public int version() {
        int version = this.data[this.messageOffset] & 0xFF;
        return CompactU16Encoding.signedByte(version) ? version & 0x7F : -128;
    }

    @Override
    public byte[] serialized() {
        return this.data;
    }

    @Override
    public void sign(Signer signer) {
        if (this.numSigners > 1) {
            byte[] pubKey = signer.publicKey().toByteArray();
            int from = this.accountsOffset;
            int i = 0;
            while (i < this.numSigners) {
                if (Arrays.equals(pubKey, 0, 32, this.data, from, from + 32)) {
                    Transaction.sign(signer, this.data, this.messageOffset, this.data.length - this.messageOffset, 1 + i * 64);
                    return;
                }
                ++i;
                from += 32;
            }
            throw new IllegalArgumentException("Failed to find index for signer " + String.valueOf(signer.publicKey()));
        }
        this.data[0] = 1;
        Transaction.sign(signer, this.data, this.messageOffset, this.data.length - this.messageOffset, 1);
    }

    @Override
    public void sign(int index, Signer signer) {
        Transaction.sign(signer, this.data, this.messageOffset, this.data.length - this.messageOffset, 1 + index * 64);
    }

    @Override
    public void sign(SequencedCollection<Signer> signers) {
        int numSigners = signers.size();
        if (numSigners != this.numSigners) {
            throw new IllegalArgumentException(String.format("Expected %d signers, only passed %d.", this.numSigners, numSigners));
        }
        this.data[0] = (byte)numSigners;
        Transaction.sign(signers, this.data, this.messageOffset, this.data.length - this.messageOffset, 1);
    }

    @Override
    public void sign(Collection<Signer> signers) {
        int numSigners = signers.size();
        if (numSigners != this.numSigners) {
            throw new IllegalArgumentException(String.format("Expected %d signers, only passed %d.", this.numSigners, numSigners));
        }
        this.data[0] = (byte)numSigners;
        for (Signer signer : signers) {
            this.sign(signer);
        }
    }

    @Override
    public String getBase58Id() {
        return Transaction.getBase58Id(this.data);
    }

    @Override
    public byte[] getId() {
        return Transaction.getId(this.data);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    private Transaction setBlockHash(Transaction transaction) {
        if (transaction instanceof TransactionRecord) {
            TransactionRecord transactionRecord = (TransactionRecord)transaction;
            System.arraycopy(this.data, this.recentBlockHashIndex, transactionRecord.data, transactionRecord.recentBlockHashIndex, 32);
        } else {
            transaction.setRecentBlockHash(this.recentBlockHash());
        }
        return transaction;
    }

    @Override
    public Transaction prependIx(Instruction ix) {
        Instruction[] ixArray = new Instruction[1 + this.instructions.size()];
        ixArray[0] = ix;
        int i = 1;
        for (Instruction _ix : this.instructions) {
            ixArray[i++] = _ix;
        }
        return this.setBlockHash(Transaction.createTx(this.feePayer, Arrays.asList(ixArray), this.lookupTable, this.tableAccountMetas));
    }

    @Override
    public Transaction prependInstructions(Instruction ix1, Instruction ix2) {
        Instruction[] ixArray = new Instruction[2 + this.instructions.size()];
        ixArray[0] = ix1;
        ixArray[1] = ix2;
        int i = 2;
        for (Instruction _ix : this.instructions) {
            ixArray[i++] = _ix;
        }
        return this.setBlockHash(Transaction.createTx(this.feePayer, Arrays.asList(ixArray), this.lookupTable, this.tableAccountMetas));
    }

    @Override
    public Transaction prependInstructions(SequencedCollection<Instruction> instructions) {
        Instruction[] ixArray = new Instruction[instructions.size() + this.instructions.size()];
        int i = 0;
        for (Instruction ix : instructions) {
            ixArray[i++] = ix;
        }
        for (Instruction ix : this.instructions) {
            ixArray[i++] = ix;
        }
        return this.setBlockHash(Transaction.createTx(this.feePayer, Arrays.asList(ixArray), this.lookupTable, this.tableAccountMetas));
    }

    @Override
    public Transaction appendIx(Instruction ix) {
        Instruction[] ixArray = new Instruction[1 + this.instructions.size()];
        int i = 0;
        for (Instruction _ix : this.instructions) {
            ixArray[i++] = _ix;
        }
        ixArray[this.instructions.size()] = ix;
        return this.setBlockHash(Transaction.createTx(this.feePayer, Arrays.asList(ixArray), this.lookupTable, this.tableAccountMetas));
    }

    @Override
    public Transaction appendInstructions(SequencedCollection<Instruction> instructions) {
        Instruction[] ixArray = new Instruction[instructions.size() + this.instructions.size()];
        int i = 0;
        for (Instruction ix : this.instructions) {
            ixArray[i++] = ix;
        }
        for (Instruction ix : instructions) {
            ixArray[i++] = ix;
        }
        return this.setBlockHash(Transaction.createTx(this.feePayer, Arrays.asList(ixArray), this.lookupTable, this.tableAccountMetas));
    }

    @Override
    public Transaction replaceInstruction(int index, Instruction instruction) {
        Instruction[] ixArray = (Instruction[])this.instructions.toArray(Instruction[]::new);
        ixArray[index] = instruction;
        return this.setBlockHash(Transaction.createTx(this.feePayer, Arrays.asList(ixArray), this.lookupTable, this.tableAccountMetas));
    }
}

