/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.tx;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.encoding.CompactU16Encoding;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;
import software.sava.core.tx.TransactionSkeletonRecord;

public interface TransactionSkeleton {
    public static TransactionSkeleton deserializeSkeleton(byte[] data) {
        int numRequiredSignatures;
        int version;
        int o = 0;
        int numSignatures = CompactU16Encoding.decode(data, o);
        o += CompactU16Encoding.getByteLen(data, o);
        int messageOffset = o += numSignatures * 64;
        if (CompactU16Encoding.signedByte(version = data[o++] & 0xFF)) {
            numRequiredSignatures = data[o++];
            version &= 0x7F;
        } else {
            numRequiredSignatures = version;
            version = -128;
        }
        byte numReadonlySignedAccounts = data[o++];
        byte numReadonlyUnsignedAccounts = data[o++];
        int numIncludedAccounts = CompactU16Encoding.decode(data, o);
        o += CompactU16Encoding.getByteLen(data, o);
        int accountsOffset = o;
        int recentBlockHashIndex = o += numIncludedAccounts << 5;
        int numInstructions = CompactU16Encoding.decode(data, o += 32);
        o += CompactU16Encoding.getByteLen(data, o);
        int instructionsOffset = o;
        if (version >= 0) {
            int[] invokedIndexes = new int[numInstructions];
            for (int i = 0; i < numInstructions; ++i) {
                invokedIndexes[i] = CompactU16Encoding.decode(data, o);
                o += CompactU16Encoding.getByteLen(data, o);
                int numAccounts = CompactU16Encoding.decode(data, o);
                o += CompactU16Encoding.getByteLen(data, o);
                int len = CompactU16Encoding.decode(data, o += numAccounts);
                o += CompactU16Encoding.getByteLen(data, o);
                o += len;
            }
            if (o < data.length) {
                int numLookupTables = CompactU16Encoding.decode(data, o);
                int lookupTablesOffset = ++o;
                if (numLookupTables > 0) {
                    PublicKey[] lookupTableAccounts = new PublicKey[numLookupTables];
                    int numAccounts = numIncludedAccounts;
                    for (int t = 0; t < numLookupTables; ++t) {
                        lookupTableAccounts[t] = PublicKey.readPubKey(data, o);
                        int numWriteIndexes = CompactU16Encoding.decode(data, o += 32);
                        o += CompactU16Encoding.getByteLen(data, o);
                        numAccounts += numWriteIndexes;
                        int numReadIndexes = CompactU16Encoding.decode(data, o += numWriteIndexes);
                        o += CompactU16Encoding.getByteLen(data, o);
                        o += numReadIndexes;
                        numAccounts += numReadIndexes;
                    }
                    Arrays.sort(invokedIndexes);
                    return new TransactionSkeletonRecord(data, version, messageOffset, numRequiredSignatures, numReadonlySignedAccounts, numReadonlyUnsignedAccounts, numIncludedAccounts, accountsOffset, recentBlockHashIndex, numInstructions, instructionsOffset, invokedIndexes, lookupTablesOffset, lookupTableAccounts, numAccounts);
                }
                return new TransactionSkeletonRecord(data, version, messageOffset, numRequiredSignatures, numReadonlySignedAccounts, numReadonlyUnsignedAccounts, numIncludedAccounts, accountsOffset, recentBlockHashIndex, numInstructions, instructionsOffset, invokedIndexes, lookupTablesOffset, TransactionSkeletonRecord.NO_TABLES, numIncludedAccounts);
            }
            return new TransactionSkeletonRecord(data, version, messageOffset, numRequiredSignatures, numReadonlySignedAccounts, numReadonlyUnsignedAccounts, numIncludedAccounts, accountsOffset, recentBlockHashIndex, numInstructions, instructionsOffset, invokedIndexes, data.length, TransactionSkeletonRecord.NO_TABLES, numIncludedAccounts);
        }
        for (int i = 0; i < numInstructions; ++i) {
            o += CompactU16Encoding.getByteLen(data, o);
            int numAccounts = CompactU16Encoding.decode(data, o);
            o += CompactU16Encoding.getByteLen(data, o);
            int len = CompactU16Encoding.decode(data, o += numAccounts);
            o += CompactU16Encoding.getByteLen(data, o);
            o += len;
        }
        return new TransactionSkeletonRecord(data, version, messageOffset, numRequiredSignatures, numReadonlySignedAccounts, numReadonlyUnsignedAccounts, numIncludedAccounts, accountsOffset, recentBlockHashIndex, numInstructions, instructionsOffset, TransactionSkeletonRecord.LEGACY_INVOKED_INDEXES, -1, TransactionSkeletonRecord.NO_TABLES, numIncludedAccounts);
    }

    public byte[] data();

    public int numSignatures();

    default public int numSigners() {
        return this.numSignatures();
    }

    public String id();

    public int version();

    public boolean isVersioned();

    public boolean isLegacy();

    public int numReadonlySignedAccounts();

    public int numReadonlyUnsignedAccounts();

    public int recentBlockHashIndex();

    public byte[] blockHash();

    public String base58BlockHash();

    public int numIncludedAccounts();

    public int numAccounts();

    default public int numIndexedAccounts() {
        return this.numAccounts() - this.numIncludedAccounts();
    }

    public PublicKey[] lookupTableAccounts();

    public AccountMeta[] parseAccounts();

    public AccountMeta[] parseAccounts(Map<PublicKey, AddressLookupTable> var1);

    default public AccountMeta[] parseAccounts(Stream<AddressLookupTable> lookupTables) {
        Map<PublicKey, AddressLookupTable> lookupTableMap = lookupTables.collect(Collectors.toUnmodifiableMap(AddressLookupTable::address, Function.identity()));
        return this.parseAccounts(lookupTableMap);
    }

    public AccountMeta[] parseAccounts(List<PublicKey> var1, List<PublicKey> var2);

    public PublicKey feePayer();

    public AccountMeta[] parseSignerAccounts();

    public PublicKey[] parseSignerPublicKeys();

    public AccountMeta[] parseNonSignerAccounts();

    public PublicKey[] parseNonSignerPublicKeys();

    public AccountMeta[] parseAccounts(AddressLookupTable var1);

    public PublicKey[] parseProgramAccounts();

    public int serializedInstructionsLength();

    public Instruction[] parseInstructions(AccountMeta[] var1);

    default public Instruction[] parseLegacyInstructions() {
        return this.parseInstructions(this.parseAccounts());
    }

    public Instruction[] parseInstructionsWithoutAccounts();

    public Instruction[] parseInstructionsWithoutTableAccounts();

    public Instruction[] filterInstructions(AccountMeta[] var1, Discriminator var2);

    default public Instruction[] filterInstructionsWithoutTableAccounts(Discriminator discriminator) {
        return this.filterInstructions(this.parseAccounts(), discriminator);
    }

    public Instruction[] filterInstructionsWithoutAccounts(Discriminator var1);

    public Transaction createTransaction(List<Instruction> var1);

    default public Transaction createTransaction(Instruction[] instructions) {
        return this.createTransaction(Arrays.asList(instructions));
    }

    default public Transaction createTransaction(AccountMeta[] accounts) {
        Instruction[] instructions = this.parseInstructions(accounts);
        return this.createTransaction(instructions);
    }

    default public Transaction createTransaction() {
        AccountMeta[] accounts = this.parseAccounts();
        return this.createTransaction(accounts);
    }

    public Transaction createTransaction(List<Instruction> var1, AddressLookupTable var2);

    default public Transaction createTransaction(Instruction[] instructions, AddressLookupTable lookupTable) {
        return this.createTransaction(Arrays.asList(instructions), lookupTable);
    }

    default public Transaction createTransaction(AccountMeta[] accounts, AddressLookupTable lookupTable) {
        Instruction[] instructions = this.parseInstructions(accounts);
        return this.createTransaction(instructions, lookupTable);
    }

    default public Transaction createTransaction(AddressLookupTable lookupTable) {
        AccountMeta[] accounts = this.parseAccounts(lookupTable);
        return this.createTransaction(accounts, lookupTable);
    }

    default public Transaction createTransaction(AccountMeta[] accounts, LookupTableAccountMeta[] tableAccountMetas) {
        Instruction[] instructions = this.parseInstructions(accounts);
        return this.createTransaction(Arrays.asList(instructions), tableAccountMetas);
    }

    default public Transaction createTransaction(LookupTableAccountMeta[] tableAccountMetas) {
        AccountMeta[] accounts = this.parseAccounts(Arrays.stream(tableAccountMetas).map(LookupTableAccountMeta::lookupTable));
        return this.createTransaction(accounts, tableAccountMetas);
    }

    public Transaction createTransaction(List<Instruction> var1, LookupTableAccountMeta[] var2);
}

