/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.tx;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.encoding.Base58;
import software.sava.core.encoding.CompactU16Encoding;
import software.sava.core.programs.Discriminator;
import software.sava.core.tx.Instruction;
import software.sava.core.tx.Transaction;
import software.sava.core.tx.TransactionRecord;
import software.sava.core.tx.TransactionSkeleton;

record TransactionSkeletonRecord(byte[] data, int version, int messageOffset, int numSignatures, int numReadonlySignedAccounts, int numReadonlyUnsignedAccounts, int numIncludedAccounts, int accountsOffset, int recentBlockHashIndex, int numInstructions, int instructionsOffset, int[] invokedIndexes, int lookupTablesOffset, PublicKey[] lookupTableAccounts, int numAccounts) implements TransactionSkeleton
{
    static final int[] LEGACY_INVOKED_INDEXES = new int[0];
    static final PublicKey[] NO_TABLES = new PublicKey[0];
    private static final List<AccountMeta> NO_ACCOUNTS = List.of();

    @Override
    public boolean isVersioned() {
        return this.version != -128;
    }

    @Override
    public boolean isLegacy() {
        return this.version == -128;
    }

    @Override
    public String id() {
        return Base58.encode(this.data, 1, 65);
    }

    @Override
    public byte[] blockHash() {
        return Arrays.copyOfRange(this.data, this.recentBlockHashIndex, this.recentBlockHashIndex + 32);
    }

    @Override
    public String base58BlockHash() {
        return Base58.encode(this.data, this.recentBlockHashIndex, this.recentBlockHashIndex + 32);
    }

    @Override
    public PublicKey feePayer() {
        return PublicKey.readPubKey(this.data, this.accountsOffset);
    }

    private int parseSignatureAccounts(AccountMeta[] accounts) {
        accounts[0] = AccountMeta.createFeePayer(this.feePayer());
        int o = this.accountsOffset + 32;
        int a = 1;
        int numWriteSigners = this.numSignatures - this.numReadonlySignedAccounts;
        while (a < numWriteSigners) {
            accounts[a] = AccountMeta.createWritableSigner(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        while (a < this.numSignatures) {
            accounts[a] = AccountMeta.createReadOnlySigner(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        return o;
    }

    @Override
    public AccountMeta[] parseSignerAccounts() {
        AccountMeta[] accounts = new AccountMeta[this.numSignatures];
        this.parseSignatureAccounts(accounts);
        return accounts;
    }

    @Override
    public PublicKey[] parseSignerPublicKeys() {
        PublicKey[] accounts = new PublicKey[this.numSignatures];
        int o = this.accountsOffset;
        int a = 0;
        while (a < this.numSignatures) {
            accounts[a] = PublicKey.readPubKey(this.data, o);
            ++a;
            o += 32;
        }
        return accounts;
    }

    @Override
    public AccountMeta[] parseAccounts() {
        AccountMeta[] accounts = new AccountMeta[this.numIncludedAccounts];
        int o = this.parseSignatureAccounts(accounts);
        int a = this.numSignatures;
        int to = this.numIncludedAccounts - this.numReadonlyUnsignedAccounts;
        while (a < to) {
            accounts[a] = AccountMeta.createWrite(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        while (a < this.numIncludedAccounts) {
            accounts[a] = AccountMeta.createRead(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        return accounts;
    }

    @Override
    public AccountMeta[] parseNonSignerAccounts() {
        int numAccounts = this.numIncludedAccounts - this.numSignatures;
        AccountMeta[] accounts = new AccountMeta[numAccounts];
        int o = this.accountsOffset + this.numSignatures * 32;
        int a = 0;
        int to = numAccounts - this.numReadonlyUnsignedAccounts;
        while (a < to) {
            accounts[a] = AccountMeta.createWrite(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        while (a < numAccounts) {
            accounts[a] = AccountMeta.createRead(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        return accounts;
    }

    @Override
    public PublicKey[] parseNonSignerPublicKeys() {
        int numAccounts = this.numIncludedAccounts - this.numSignatures;
        PublicKey[] accounts = new PublicKey[numAccounts];
        int a = 0;
        int o = this.accountsOffset + this.numSignatures * 32;
        while (a < numAccounts) {
            accounts[a] = PublicKey.readPubKey(this.data, o);
            ++a;
            o += 32;
        }
        return accounts;
    }

    @Override
    public AccountMeta[] parseAccounts(AddressLookupTable lookupTable) {
        return lookupTable == null ? this.parseAccounts() : this.parseAccounts(Map.of(lookupTable.address(), lookupTable));
    }

    @Override
    public int serializedInstructionsLength() {
        int serializedInstructionsLength = 0;
        int o = this.instructionsOffset;
        for (int i = 0; i < this.numInstructions; ++i) {
            int numAccounts = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int len = CompactU16Encoding.decode(this.data, o += numAccounts);
            o += CompactU16Encoding.getByteLen(this.data, o);
            o += len;
            serializedInstructionsLength += 1 + CompactU16Encoding.getByteLen(numAccounts) + numAccounts + CompactU16Encoding.getByteLen(len) + len;
        }
        return serializedInstructionsLength;
    }

    private AccountMeta parseVersionedReadAccount(PublicKey pubKey, int a) {
        return Arrays.binarySearch(this.invokedIndexes, a) < 0 ? AccountMeta.createRead(pubKey) : AccountMeta.createInvoked(pubKey);
    }

    private int parseVersionedIncludedAccounts(AccountMeta[] accounts) {
        int o = this.parseSignatureAccounts(accounts);
        int a = this.numSignatures;
        int to = this.numIncludedAccounts - this.numReadonlyUnsignedAccounts;
        while (a < to) {
            accounts[a] = AccountMeta.createWrite(PublicKey.readPubKey(this.data, o));
            ++a;
            o += 32;
        }
        while (a < this.numIncludedAccounts) {
            accounts[a] = this.parseVersionedReadAccount(PublicKey.readPubKey(this.data, o), a);
            ++a;
            o += 32;
        }
        return a;
    }

    @Override
    public AccountMeta[] parseAccounts(Map<PublicKey, AddressLookupTable> lookupTables) {
        int numReadIndexes;
        int numWriteIndexes;
        AddressLookupTable lookupTable;
        AccountMeta[] accounts = new AccountMeta[this.numAccounts];
        int a = this.parseVersionedIncludedAccounts(accounts);
        int o = this.lookupTablesOffset;
        for (PublicKey lookupTableKey : this.lookupTableAccounts) {
            lookupTable = lookupTables.get(lookupTableKey);
            numWriteIndexes = CompactU16Encoding.decode(this.data, o += 32);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int w = 0;
            while (w < numWriteIndexes) {
                accounts[a] = AccountMeta.createWrite(lookupTable.account(this.data[o] & 0xFF));
                ++w;
                ++a;
                ++o;
            }
            numReadIndexes = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            o += numReadIndexes;
        }
        o = this.lookupTablesOffset;
        for (PublicKey lookupTableKey : this.lookupTableAccounts) {
            lookupTable = lookupTables.get(lookupTableKey);
            numWriteIndexes = CompactU16Encoding.decode(this.data, o += 32);
            o += CompactU16Encoding.getByteLen(this.data, o);
            numReadIndexes = CompactU16Encoding.decode(this.data, o += numWriteIndexes);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int r = 0;
            while (r < numReadIndexes) {
                accounts[a] = AccountMeta.createRead(lookupTable.account(this.data[o] & 0xFF));
                ++r;
                ++a;
                ++o;
            }
        }
        return accounts;
    }

    @Override
    public AccountMeta[] parseAccounts(List<PublicKey> writableLoaded, List<PublicKey> readonlyLoaded) {
        AccountMeta[] accounts = new AccountMeta[this.numAccounts];
        int a = this.parseVersionedIncludedAccounts(accounts);
        for (PublicKey writeable : writableLoaded) {
            accounts[a++] = AccountMeta.createWrite(writeable);
        }
        for (PublicKey readable : readonlyLoaded) {
            accounts[a++] = AccountMeta.createRead(readable);
        }
        return accounts;
    }

    @Override
    public Instruction[] parseInstructions(AccountMeta[] accounts) {
        Instruction[] instructions = new Instruction[this.numInstructions];
        int o = this.instructionsOffset;
        for (int i = 0; i < this.numInstructions; ++i) {
            AccountMeta programAccount = accounts[CompactU16Encoding.decode(this.data, o)];
            o += CompactU16Encoding.getByteLen(this.data, o);
            int numIxAccounts = CompactU16Encoding.decode(this.data, o);
            AccountMeta[] ixAccounts = new AccountMeta[numIxAccounts];
            o += CompactU16Encoding.getByteLen(this.data, o);
            for (int a = 0; a < numIxAccounts; ++a) {
                int accountIndex;
                ixAccounts[a] = (accountIndex = this.data[o++] & 0xFF) < accounts.length ? accounts[accountIndex] : null;
            }
            int len = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            instructions[i] = Instruction.createInstruction(programAccount, Arrays.asList(ixAccounts), this.data, o, len);
            o += len;
        }
        return instructions;
    }

    private int accountOffset(int accountIndex) {
        return this.accountsOffset + accountIndex * 32;
    }

    private PublicKey getAccount(int accountIndex) {
        return PublicKey.readPubKey(this.data, this.accountOffset(accountIndex));
    }

    @Override
    public PublicKey[] parseProgramAccounts() {
        PublicKey[] programs = new PublicKey[this.numInstructions];
        int o = this.instructionsOffset;
        for (int i = 0; i < this.numInstructions; ++i) {
            int programAccountIndex = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            programs[i] = this.getAccount(programAccountIndex);
            int numIxAccounts = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int len = CompactU16Encoding.decode(this.data, o += numIxAccounts);
            o += CompactU16Encoding.getByteLen(this.data, o);
            o += len;
        }
        return programs;
    }

    @Override
    public Instruction[] parseInstructionsWithoutAccounts() {
        Instruction[] instructions = new Instruction[this.numInstructions];
        int o = this.instructionsOffset;
        for (int i = 0; i < this.numInstructions; ++i) {
            int programAccountIndex = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            PublicKey programAccount = this.getAccount(programAccountIndex);
            int numIxAccounts = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int len = CompactU16Encoding.decode(this.data, o += numIxAccounts);
            o += CompactU16Encoding.getByteLen(this.data, o);
            instructions[i] = Instruction.createInstruction(programAccount, NO_ACCOUNTS, this.data, o, len);
            o += len;
        }
        return instructions;
    }

    @Override
    public Instruction[] filterInstructions(AccountMeta[] accounts, Discriminator discriminator) {
        Instruction[] instructions = new Instruction[this.numInstructions];
        int d = 0;
        int o = this.instructionsOffset;
        for (int i = 0; i < this.numInstructions; ++i) {
            int programAccountIndex = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int numIxAccounts = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int accountsOffset = o;
            int len = CompactU16Encoding.decode(this.data, o += numIxAccounts);
            if (discriminator.equals(this.data, o += CompactU16Encoding.getByteLen(this.data, o))) {
                AccountMeta[] ixAccounts = new AccountMeta[numIxAccounts];
                for (int a = 0; a < numIxAccounts; ++a) {
                    int accountIndex;
                    ixAccounts[a] = (accountIndex = this.data[accountsOffset++] & 0xFF) < accounts.length ? accounts[accountIndex] : null;
                }
                instructions[d++] = Instruction.createInstruction(this.getAccount(programAccountIndex), Arrays.asList(ixAccounts), this.data, o, len);
            }
            o += len;
        }
        return d == this.numInstructions ? instructions : Arrays.copyOfRange(instructions, 0, d);
    }

    @Override
    public Instruction[] filterInstructionsWithoutAccounts(Discriminator discriminator) {
        Instruction[] instructions = new Instruction[this.numInstructions];
        int d = 0;
        int o = this.instructionsOffset;
        for (int i = 0; i < this.numInstructions; ++i) {
            int programAccountIndex = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int numIxAccounts = CompactU16Encoding.decode(this.data, o);
            o += CompactU16Encoding.getByteLen(this.data, o);
            int len = CompactU16Encoding.decode(this.data, o += numIxAccounts);
            if (discriminator.equals(this.data, o += CompactU16Encoding.getByteLen(this.data, o))) {
                instructions[d++] = Instruction.createInstruction(this.getAccount(programAccountIndex), NO_ACCOUNTS, this.data, o, len);
            }
            o += len;
        }
        return d == this.numInstructions ? instructions : Arrays.copyOfRange(instructions, 0, d);
    }

    @Override
    public Instruction[] parseInstructionsWithoutTableAccounts() {
        AccountMeta[] accounts = new AccountMeta[this.numAccounts];
        this.parseVersionedIncludedAccounts(accounts);
        return this.parseInstructions(accounts);
    }

    @Override
    public Transaction createTransaction(List<Instruction> instructions) {
        return new TransactionRecord(AccountMeta.createFeePayer(this.feePayer()), instructions, null, TransactionRecord.NO_TABLES, this.data, this.numSignatures, this.messageOffset, this.accountsOffset, this.recentBlockHashIndex);
    }

    @Override
    public Transaction createTransaction(List<Instruction> instructions, AddressLookupTable lookupTable) {
        return new TransactionRecord(AccountMeta.createFeePayer(this.feePayer()), instructions, lookupTable, TransactionRecord.NO_TABLES, this.data, this.numSignatures, this.messageOffset, this.accountsOffset, this.recentBlockHashIndex);
    }

    @Override
    public Transaction createTransaction(List<Instruction> instructions, LookupTableAccountMeta[] tableAccountMetas) {
        return new TransactionRecord(AccountMeta.createFeePayer(this.feePayer()), instructions, null, tableAccountMetas, this.data, this.numSignatures, this.messageOffset, this.accountsOffset, this.recentBlockHashIndex);
    }
}

