/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public interface DecimalInteger {
    public int decimals();

    default public BigDecimal toDecimal(long amount) {
        return DecimalInteger.toDecimal(amount, this.decimals());
    }

    default public BigDecimal toDecimal(BigInteger amount) {
        return DecimalInteger.toDecimal(amount, this.decimals());
    }

    default public BigDecimal toDecimal(BigDecimal amount) {
        return DecimalInteger.toDecimal(amount, this.decimals());
    }

    default public BigDecimal fromDecimal(BigDecimal amount) {
        return DecimalInteger.fromDecimal(amount, this.decimals());
    }

    public static BigDecimal toDecimal(long val, int decimals) {
        return DecimalInteger.toDecimal(val < 0L ? new BigDecimal(Long.toUnsignedString(val)) : BigDecimal.valueOf(val), decimals);
    }

    public static BigDecimal toDecimal(BigInteger val, int decimals) {
        return DecimalInteger.toDecimal(new BigDecimal(val), decimals);
    }

    public static BigDecimal toDecimal(BigDecimal val, int decimals) {
        return val.movePointLeft(decimals).stripTrailingZeros();
    }

    public static BigDecimal fromDecimal(BigDecimal val, int decimals) {
        return val.movePointRight(decimals);
    }
}

