/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.console;

import com.alaya.codegen.Console;
import com.alaya.console.IODevice;
import com.alaya.console.WalletManager;
import com.alaya.crypto.CipherException;
import com.alaya.crypto.Credentials;
import com.alaya.crypto.ECKeyPair;
import com.alaya.crypto.WalletUtils;
import com.alaya.utils.Files;
import java.io.File;
import java.io.IOException;

public class KeyImporter
extends WalletManager {
    public KeyImporter() {
    }

    public KeyImporter(IODevice console) {
        super(console);
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            new KeyImporter().run(args[0]);
        } else {
            new KeyImporter().run();
        }
    }

    static void main(IODevice console) {
        new KeyImporter(console).run();
    }

    private void run(String input) {
        File keyFile = new File(input);
        if (keyFile.isFile()) {
            String privateKey = null;
            try {
                privateKey = Files.readString((File)keyFile);
            }
            catch (IOException e) {
                Console.exitError((String)("Unable to read file " + input));
            }
            this.createWalletFile(privateKey.trim());
        } else {
            this.createWalletFile(input.trim());
        }
    }

    private void run() {
        String input = this.console.readLine("Please enter the hex encoded private key or key file location: ", new Object[0]).trim();
        this.run(input);
    }

    private void createWalletFile(String privateKey) {
        if (!WalletUtils.isValidPrivateKey((String)privateKey)) {
            Console.exitError((String)"Invalid private key specified, must be 64 digit hex value");
        }
        Credentials credentials = Credentials.create((String)privateKey);
        String password = this.getPassword("Please enter a wallet file password: ");
        String destinationDir = this.getDestinationDir();
        File destination = this.createDir(destinationDir);
        try {
            String walletFileName = WalletUtils.generateWalletFile((String)password, (ECKeyPair)credentials.getEcKeyPair(), (File)destination, (boolean)true);
            this.console.printf("Wallet file " + walletFileName + " successfully created in: " + destinationDir + "\n", new Object[0]);
        }
        catch (CipherException | IOException e) {
            Console.exitError((Throwable)e);
        }
    }
}

