/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.console;

import com.alaya.codegen.Console;
import com.alaya.console.WalletManager;
import com.alaya.crypto.Credentials;
import com.alaya.crypto.WalletUtils;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.Web3jService;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.core.methods.response.Web3ClientVersion;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.protocol.http.HttpService;
import com.alaya.tx.Transfer;
import com.alaya.utils.Convert;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class WalletSendFunds
extends WalletManager {
    private static final String USAGE = "send <walletfile> <destination-address>";

    public static void main(String[] args) {
        if (args.length != 2) {
            Console.exitError((String)USAGE);
        } else {
            new WalletSendFunds().run(args[0], args[1], args[2]);
        }
    }

    private void run(String walletFileLocation, String chainId, String destinationAddress) {
        File walletFile = new File(walletFileLocation);
        Credentials credentials = this.getCredentials(walletFile);
        this.console.printf("Wallet for address " + credentials.getAddress(Long.valueOf(chainId).longValue()) + " loaded\n", new Object[0]);
        if (!WalletUtils.isValidAddress((String)destinationAddress)) {
            Console.exitError((String)"Invalid destination address specified");
        }
        Web3j web3j = this.getEthereumClient();
        BigDecimal amountToTransfer = this.getAmountToTransfer();
        Convert.Unit transferUnit = this.getTransferUnit();
        BigDecimal amountInWei = Convert.toVon((BigDecimal)amountToTransfer, (Convert.Unit)transferUnit);
        this.confirmTransfer(amountToTransfer, transferUnit, amountInWei, destinationAddress);
        TransactionReceipt transactionReceipt = this.performTransfer(web3j, destinationAddress, chainId, credentials, amountInWei);
        this.console.printf("Funds have been successfully transferred from %s to %s%nTransaction hash: %s%nMined block number: %s%n", credentials.getAddress(Long.valueOf(chainId).longValue()), destinationAddress, transactionReceipt.getTransactionHash(), transactionReceipt.getBlockNumber());
    }

    private BigDecimal getAmountToTransfer() {
        String amount = this.console.readLine("What amound would you like to transfer (please enter a numeric value): ", new Object[0]).trim();
        try {
            return new BigDecimal(amount);
        }
        catch (NumberFormatException e) {
            Console.exitError((String)"Invalid amount specified");
            throw new RuntimeException("Application exit failure");
        }
    }

    private Convert.Unit getTransferUnit() {
        String unit = this.console.readLine("Please specify the unit (ether, wei, ...) [ether]: ", new Object[0]).trim();
        Convert.Unit transferUnit = unit.equals("") ? Convert.Unit.ATP : Convert.Unit.fromString((String)unit.toLowerCase());
        return transferUnit;
    }

    private void confirmTransfer(BigDecimal amountToTransfer, Convert.Unit transferUnit, BigDecimal amountInWei, String destinationAddress) {
        this.console.printf("Please confim that you wish to transfer %s %s (%s %s) to address %s%n", amountToTransfer.stripTrailingZeros().toPlainString(), transferUnit, amountInWei.stripTrailingZeros().toPlainString(), Convert.Unit.VON, destinationAddress);
        String confirm = this.console.readLine("Please type 'yes' to proceed: ", new Object[0]).trim();
        if (!confirm.toLowerCase().equals("yes")) {
            Console.exitError((String)"OK, some other time perhaps...");
        }
    }

    private TransactionReceipt performTransfer(Web3j web3j, String destinationAddress, String chainId, Credentials credentials, BigDecimal amountInWei) {
        this.console.printf("Commencing transfer (this may take a few minutes) ", new Object[0]);
        try {
            CompletableFuture future = Transfer.sendFunds((Web3j)web3j, (Credentials)credentials, (long)Long.valueOf(chainId), (String)destinationAddress, (BigDecimal)amountInWei, (Convert.Unit)Convert.Unit.ATP).sendAsync();
            while (!future.isDone()) {
                this.console.printf(".", new Object[0]);
                Thread.sleep(500L);
            }
            this.console.printf("$%n%n", new Object[0]);
            return (TransactionReceipt)future.get();
        }
        catch (TransactionException | IOException | InterruptedException | ExecutionException e) {
            Console.exitError((String)("Problem encountered transferring funds: \n" + e.getMessage()));
            throw new RuntimeException("Application exit failure");
        }
    }

    private Web3j getEthereumClient() {
        String clientAddress = this.console.readLine("Please confirm address of running Ethereum client you wish to send the transfer request to [http://localhost:8545/]: ", new Object[0]).trim();
        Web3j web3j = clientAddress.equals("") ? Web3j.build((Web3jService)new HttpService()) : Web3j.build((Web3jService)new HttpService(clientAddress));
        try {
            Web3ClientVersion web3ClientVersion = (Web3ClientVersion)web3j.web3ClientVersion().sendAsync().get();
            if (!web3ClientVersion.hasError()) {
                this.console.printf("Connected successfully to client: %s%n", web3ClientVersion.getWeb3ClientVersion());
                return web3j;
            }
            Console.exitError((String)("Unable to process response from client: " + web3ClientVersion.getError()));
        }
        catch (InterruptedException | ExecutionException e) {
            Console.exitError((String)("Problem encountered verifying client: " + e.getMessage()));
        }
        throw new RuntimeException("Application exit failure");
    }
}

