/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.codegen;

import com.alaya.abi.solidity.EventEncoder;
import com.alaya.abi.solidity.FunctionEncoder;
import com.alaya.abi.solidity.TypeReference;
import com.alaya.abi.solidity.datatypes.Address;
import com.alaya.abi.solidity.datatypes.Bool;
import com.alaya.abi.solidity.datatypes.DynamicArray;
import com.alaya.abi.solidity.datatypes.DynamicBytes;
import com.alaya.abi.solidity.datatypes.Event;
import com.alaya.abi.solidity.datatypes.Function;
import com.alaya.abi.solidity.datatypes.StaticArray;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.AbiTypes;
import com.alaya.codegen.GenerationReporter;
import com.alaya.codegen.Generator;
import com.alaya.codegen.LogGenerationReporter;
import com.alaya.codegen.SolidityFunctionWrapperGenerator;
import com.alaya.crypto.Credentials;
import com.alaya.protocol.ObjectMapperFactory;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.DefaultBlockParameter;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.request.PlatonFilter;
import com.alaya.protocol.core.methods.response.AbiDefinition;
import com.alaya.protocol.core.methods.response.Log;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.tx.Contract;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Collection;
import com.alaya.utils.Strings;
import com.alaya.utils.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class SolidityFunctionWrapper
extends Generator {
    private static final String BINARY = "BINARY";
    private static final String WEB3J = "web3j";
    private static final String CREDENTIALS = "credentials";
    private static final String CONTRACT_GAS_PROVIDER = "contractGasProvider";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String INITIAL_VALUE = "initialVonValue";
    private static final String CONTRACT_ADDRESS = "contractAddress";
    private static final String CHAINID = "chainId";
    private static final String GAS_PRICE = "gasPrice";
    private static final String GAS_LIMIT = "gasLimit";
    private static final String FILTER = "filter";
    private static final String START_BLOCK = "startBlock";
    private static final String END_BLOCK = "endBlock";
    private static final String WEI_VALUE = "vonValue";
    private static final String FUNC_NAME_PREFIX = "FUNC_";
    private static final ClassName LOG = ClassName.get(Log.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SolidityFunctionWrapper.class);
    private static final String CODEGEN_WARNING = "<p>Auto generated code.\n<p><strong>Do not modify!</strong>\n<p>Please use the <a href=\"https://github.com/PlatONnetwork/client-sdk-java/releases\">platon-web3j command line tools</a>,\nor the " + SolidityFunctionWrapperGenerator.class.getName() + " in the \n<a href=\"https://github.com/PlatONnetwork/client-sdk-java/tree/master/codegen\">codegen module</a> to update.\n";
    private final boolean useNativeJavaTypes;
    private static final String regex = "(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?";
    private static final Pattern pattern = Pattern.compile("(\\w+)(?:\\[(.*?)\\])(?:\\[(.*?)\\])?");
    private final GenerationReporter reporter;

    public SolidityFunctionWrapper(boolean useNativeJavaTypes) {
        this(useNativeJavaTypes, new LogGenerationReporter(LOGGER));
    }

    SolidityFunctionWrapper(boolean useNativeJavaTypes, GenerationReporter reporter) {
        this.useNativeJavaTypes = useNativeJavaTypes;
        this.reporter = reporter;
    }

    public void generateJavaFiles(String contractName, String bin, String abi, String destinationDir, String basePackageName) throws IOException, ClassNotFoundException {
        this.generateJavaFiles(contractName, bin, this.loadContractDefinition(abi), destinationDir, basePackageName, null);
    }

    void generateJavaFiles(String contractName, String bin, List<AbiDefinition> abi, String destinationDir, String basePackageName, Map<String, String> addresses) throws IOException, ClassNotFoundException {
        for (int i = 0; i < abi.size(); ++i) {
            AbiDefinition abiDefinition = abi.get(i);
            if (!abiDefinition.getType().equals("event")) continue;
            List namedTypeList = abiDefinition.getInputs();
            for (int j = 0; j < namedTypeList.size(); ++j) {
                AbiDefinition.NamedType namedType = (AbiDefinition.NamedType)namedTypeList.get(j);
                String name = SolidityFunctionWrapper.createValidParamName(namedType.getName(), j);
                namedType.setName(name);
            }
        }
        String className = Strings.capitaliseFirstLetter((String)contractName);
        TypeSpec.Builder classBuilder = this.createClassBuilder(className, bin);
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(Credentials.class, CREDENTIALS));
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructor(TransactionManager.class, TRANSACTION_MANAGER));
        classBuilder.addFields(this.buildFuncNameConstants(abi));
        classBuilder.addMethods(this.buildFunctionDefinitions(className, classBuilder, abi));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, Credentials.class, CREDENTIALS));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoad(className, TransactionManager.class, TRANSACTION_MANAGER));
        this.addAddressesSupport(classBuilder, addresses);
        this.write(basePackageName, classBuilder.build(), destinationDir);
    }

    private void addAddressesSupport(TypeSpec.Builder classBuilder, Map<String, String> addresses) {
        if (addresses != null) {
            ClassName stringType = ClassName.get(String.class);
            ClassName mapType = ClassName.get(HashMap.class);
            ParameterizedTypeName mapStringString = ParameterizedTypeName.get((ClassName)mapType, (TypeName[])new TypeName[]{stringType, stringType});
            FieldSpec addressesStaticField = FieldSpec.builder((TypeName)mapStringString, (String)"_addresses", (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL}).build();
            classBuilder.addField(addressesStaticField);
            CodeBlock.Builder staticInit = CodeBlock.builder();
            staticInit.addStatement("_addresses = new HashMap<String, String>()", new Object[0]);
            addresses.forEach((k, v) -> staticInit.addStatement(String.format("_addresses.put(\"%1s\", \"%2s\")", k, v), new Object[0]));
            classBuilder.addStaticBlock(staticInit.build());
            MethodSpec getAddress = MethodSpec.methodBuilder((String)"getStaticDeployedAddress").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getAddress);
            MethodSpec getPreviousAddress = MethodSpec.methodBuilder((String)"getPreviouslyDeployedAddress").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getPreviousAddress);
        }
    }

    private TypeSpec.Builder createClassBuilder(String className, String binary) {
        String javadoc = CODEGEN_WARNING + this.getWeb3jVersion();
        return TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(javadoc, new Object[0]).superclass(Contract.class).addField(this.createBinaryDefinition(binary));
    }

    private String getWeb3jVersion() {
        String version;
        try {
            version = Version.getVersion();
        }
        catch (IOException | NullPointerException e) {
            version = "none";
        }
        return "\n<p>Generated with web3j version " + version + ".\n";
    }

    private FieldSpec createBinaryDefinition(String binary) {
        return FieldSpec.builder(String.class, (String)BINARY, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{binary}).build();
    }

    private FieldSpec createEventDefinition(String name, List<NamedTypeName> parameters) {
        CodeBlock initializer = SolidityFunctionWrapper.buildVariableLengthEventInitializer(name, parameters);
        return FieldSpec.builder(Event.class, (String)this.buildEventDefinitionName(name), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer).build();
    }

    private String buildEventDefinitionName(String eventName) {
        return eventName.toUpperCase() + "_EVENT";
    }

    private List<MethodSpec> buildFunctionDefinitions(String className, TypeSpec.Builder classBuilder, List<AbiDefinition> functionDefinitions) throws ClassNotFoundException {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        boolean constructor = false;
        for (AbiDefinition functionDefinition : functionDefinitions) {
            if (functionDefinition.getType().equals("function")) {
                MethodSpec ms = this.buildFunction(functionDefinition);
                methodSpecs.add(ms);
                continue;
            }
            if (functionDefinition.getType().equals("event")) {
                methodSpecs.addAll(this.buildEventFunctions(functionDefinition, classBuilder));
                continue;
            }
            if (!functionDefinition.getType().equals("constructor")) continue;
            constructor = true;
            methodSpecs.add(this.buildDeploy(className, functionDefinition, Credentials.class, CREDENTIALS, true));
            methodSpecs.add(this.buildDeploy(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER, true));
        }
        if (!constructor) {
            MethodSpec.Builder credentialsMethodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, Credentials.class, CREDENTIALS, false, true);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(credentialsMethodBuilder, className, CREDENTIALS, false, true));
            MethodSpec.Builder transactionManagerMethodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER, false, true);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(transactionManagerMethodBuilder, className, TRANSACTION_MANAGER, false, true));
        }
        return methodSpecs;
    }

    Iterable<FieldSpec> buildFuncNameConstants(List<AbiDefinition> functionDefinitions) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        HashSet<String> fieldNames = new HashSet<String>();
        fieldNames.add("deploy");
        for (AbiDefinition functionDefinition : functionDefinitions) {
            String funcName;
            if (!functionDefinition.getType().equals("function") || fieldNames.contains(funcName = functionDefinition.getName())) continue;
            FieldSpec field = FieldSpec.builder(String.class, (String)SolidityFunctionWrapper.funcNameToConst(funcName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{funcName}).build();
            fields.add(field);
            fieldNames.add(funcName);
        }
        return fields;
    }

    private static MethodSpec buildConstructor(Class authType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]).addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(Long.class, CHAINID, new Modifier[0]).addStatement("super($N, $N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER, CHAINID});
        return toReturn.build();
    }

    private MethodSpec buildDeploy(String className, AbiDefinition functionDefinition, Class authType, String authName, boolean withGasProvider) {
        boolean isPayable = functionDefinition.isPayable();
        MethodSpec.Builder methodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, authType, authName, isPayable, withGasProvider);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        if (!inputParams.isEmpty()) {
            return SolidityFunctionWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName, isPayable, withGasProvider);
        }
        return SolidityFunctionWrapper.buildDeployNoParams(methodBuilder, className, authName, isPayable, withGasProvider);
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName, boolean isPayable, boolean withGasProvider) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($T.<$T>asList($L))", new Object[]{String.class, FunctionEncoder.class, Arrays.class, com.alaya.abi.solidity.datatypes.Type.class, inputParams});
        if (isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor, $L, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, INITIAL_VALUE, CHAINID});
        } else if (!isPayable && !withGasProvider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, CHAINID});
        }
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName, boolean isPayable, boolean withGasPRovider) {
        if (isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L,  \"\", $L, $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else if (isPayable && withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, \"\", $L, $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, INITIAL_VALUE, CHAINID});
        } else if (!isPayable && !withGasPRovider) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L,  \"\", $L)", new Object[]{className, WEB3J, authName, GAS_PRICE, GAS_LIMIT, BINARY, CHAINID});
            methodBuilder.addAnnotation(Deprecated.class);
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L,  \"\", $L)", new Object[]{className, WEB3J, authName, CONTRACT_GAS_PROVIDER, BINARY, CHAINID});
        }
        return methodBuilder.build();
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName, boolean isPayable, boolean withGasProvider) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{com.alaya.abi.solidity.datatypes.Type.class}))).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]);
        if (isPayable && !withGasProvider) {
            builder.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        } else if (isPayable && withGasProvider) {
            builder.addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        } else if (!isPayable && withGasProvider) {
            builder.addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]);
        } else {
            builder.addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]);
        }
        return builder.addParameter(Long.class, CHAINID, new Modifier[0]);
    }

    private static MethodSpec buildLoad(String className, Class authType, String authName) {
        MethodSpec.Builder toReturn = MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (Type[])new Type[]{com.alaya.abi.solidity.datatypes.Type.class})).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Web3j.class, WEB3J, new Modifier[0]).addParameter((Type)authType, authName, new Modifier[0]).addParameter(GasProvider.class, CONTRACT_GAS_PROVIDER, new Modifier[0]).addParameter(Long.class, CHAINID, new Modifier[0]).addStatement("return new $L($L, $L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, WEB3J, authName, CONTRACT_GAS_PROVIDER, CHAINID});
        return toReturn.build();
    }

    String addParameters(MethodSpec.Builder methodBuilder, List<AbiDefinition.NamedType> namedTypes) {
        List<ParameterSpec> inputParameterTypes = SolidityFunctionWrapper.buildParameterTypes(namedTypes);
        ArrayList<ParameterSpec> nativeInputParameterTypes = new ArrayList<ParameterSpec>(inputParameterTypes.size());
        for (ParameterSpec parameterSpec2 : inputParameterTypes) {
            TypeName typeName = this.getWrapperType(parameterSpec2.type);
            nativeInputParameterTypes.add(ParameterSpec.builder((TypeName)typeName, (String)parameterSpec2.name, (Modifier[])new Modifier[0]).build());
        }
        methodBuilder.addParameters(nativeInputParameterTypes);
        if (this.useNativeJavaTypes) {
            return Collection.join(inputParameterTypes, (String)", \n", this::createMappedParameterTypes);
        }
        return Collection.join(inputParameterTypes, (String)", ", parameterSpec -> parameterSpec.name);
    }

    private String createMappedParameterTypes(ParameterSpec parameterSpec) {
        if (parameterSpec.type instanceof ParameterizedTypeName) {
            List typeNames = ((ParameterizedTypeName)parameterSpec.type).typeArguments;
            if (typeNames.size() != 1) {
                throw new UnsupportedOperationException("Only a single parameterized type is supported");
            }
            String parameterSpecType = parameterSpec.type.toString();
            TypeName typeName = (TypeName)typeNames.get(0);
            String componentType = typeName.toString();
            String typeMapInput = typeName + ".class";
            if (typeName instanceof ParameterizedTypeName) {
                List typeArguments = ((ParameterizedTypeName)typeName).typeArguments;
                if (typeArguments.size() != 1) {
                    throw new UnsupportedOperationException("Only a single parameterized type is supported");
                }
                TypeName innerTypeName = (TypeName)typeArguments.get(0);
                componentType = ((ParameterizedTypeName)typeName).rawType.toString();
                parameterSpecType = ((ParameterizedTypeName)parameterSpec.type).rawType.toString();
                typeMapInput = ((ParameterizedTypeName)typeName).rawType + ".class, " + innerTypeName + ".class";
            }
            return "new " + parameterSpecType + "(\n" + componentType + ".class,\n        com.alaya.abi.solidity.Utils.typeMap(" + parameterSpec.name + ", " + typeMapInput + "))";
        }
        return "new " + parameterSpec.type + "(" + parameterSpec.name + ")";
    }

    private TypeName getWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getWrapperRawType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            if (typeName instanceof ParameterizedTypeName) {
                return ClassName.get(List.class);
            }
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getIndexedEventWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getEventNativeType(typeName);
        }
        return typeName;
    }

    static TypeName getNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return SolidityFunctionWrapper.getNativeType((ParameterizedTypeName)typeName);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.equals(Address.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Uint")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.startsWith("Int")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.equals(Utf8String.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Bytes")) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.equals(DynamicBytes.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.equals(Bool.class.getSimpleName())) {
            return TypeName.get(Boolean.class);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeName + ", no native type mapping exists.");
    }

    static TypeName getNativeType(ParameterizedTypeName parameterizedTypeName) {
        List typeNames = parameterizedTypeName.typeArguments;
        ArrayList<TypeName> nativeTypeNames = new ArrayList<TypeName>(typeNames.size());
        for (TypeName enclosedTypeName : typeNames) {
            nativeTypeNames.add(SolidityFunctionWrapper.getNativeType(enclosedTypeName));
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])nativeTypeNames.toArray(new TypeName[nativeTypeNames.size()]));
    }

    static TypeName getEventNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return TypeName.get(byte[].class);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.equals(Utf8String.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        return SolidityFunctionWrapper.getNativeType(typeName);
    }

    static List<ParameterSpec> buildParameterTypes(List<AbiDefinition.NamedType> namedTypes) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>(namedTypes.size());
        for (int i = 0; i < namedTypes.size(); ++i) {
            AbiDefinition.NamedType namedType = namedTypes.get(i);
            String name = SolidityFunctionWrapper.createValidParamName(namedType.getName(), i);
            String type = namedTypes.get(i).getType();
            result.add(ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build());
        }
        return result;
    }

    static String createValidParamName(String name, int idx) {
        if (name.equals("")) {
            return "param" + idx;
        }
        return name;
    }

    static List<TypeName> buildTypeNames(List<AbiDefinition.NamedType> namedTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(namedTypes.size());
        for (AbiDefinition.NamedType namedType : namedTypes) {
            result.add(SolidityFunctionWrapper.buildTypeName(namedType.getType()));
        }
        return result;
    }

    MethodSpec buildFunction(AbiDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        List<TypeName> outputParameterTypes = SolidityFunctionWrapper.buildTypeNames(functionDefinition.getOutputs());
        if (functionDefinition.isConstant()) {
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams);
        } else {
            this.buildTransactionFunction(functionDefinition, methodBuilder, inputParams);
        }
        return methodBuilder.build();
    }

    private void buildConstantFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, List<TypeName> outputParameterTypes, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (outputParameterTypes.isEmpty()) {
            methodBuilder.addStatement("throw new RuntimeException(\"cannot call constant function with void return type\")", new Object[0]);
        } else if (outputParameterTypes.size() == 1) {
            TypeName typeName = outputParameterTypes.get(0);
            TypeName nativeReturnTypeName = this.useNativeJavaTypes ? this.getWrapperRawType(typeName) : this.getWrapperType(typeName);
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall(nativeReturnTypeName));
            methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(new $T<$T>() {}))", new Object[]{Function.class, Function.class, SolidityFunctionWrapper.funcNameToConst(functionName), Arrays.class, com.alaya.abi.solidity.datatypes.Type.class, inputParams, Arrays.class, TypeReference.class, TypeReference.class, typeName});
            if (this.useNativeJavaTypes) {
                if (nativeReturnTypeName.equals((Object)ClassName.get(List.class))) {
                    ParameterizedTypeName listType = ParameterizedTypeName.get(List.class, (Type[])new Type[]{com.alaya.abi.solidity.datatypes.Type.class});
                    CodeBlock.Builder callCode = CodeBlock.builder();
                    callCode.addStatement("$T result = ($T) executeCallSingleValueReturn(function, $T.class)", new Object[]{listType, listType, nativeReturnTypeName});
                    callCode.addStatement("return convertToNative(result)", new Object[0]);
                    TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{nativeReturnTypeName})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns(nativeReturnTypeName).addCode(callCode.build()).build()).build();
                    methodBuilder.addStatement("return new $T(\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteCall(nativeReturnTypeName), callableType});
                } else {
                    methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function, $T.class)", new Object[]{nativeReturnTypeName});
                }
            } else {
                methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function)", new Object[0]);
            }
        } else {
            List<TypeName> returnTypes = this.buildReturnTypes(outputParameterTypes);
            ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"com.alaya.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[returnTypes.size()]));
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)parameterizedTupleType));
            SolidityFunctionWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionName, inputParams, outputParameterTypes);
            this.buildTupleResultContainer(methodBuilder, parameterizedTupleType, outputParameterTypes);
        }
    }

    private static ParameterizedTypeName buildRemoteCall(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(RemoteCall.class), (TypeName[])new TypeName[]{typeName});
    }

    private void buildTransactionFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        if (functionDefinition.hasOutputs()) {
            this.reporter.report(String.format("Definition of the function %s returns a value but is not defined as a view function. Please ensure it contains the view modifier if you want to read the return value", functionDefinition.getName()));
        }
        if (functionDefinition.isPayable()) {
            methodBuilder.addParameter(BigInteger.class, WEI_VALUE, new Modifier[0]);
        }
        String functionName = functionDefinition.getName();
        methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall(TypeName.get(TransactionReceipt.class)));
        methodBuilder.addStatement("final $T function = new $T(\n$N, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{Function.class, Function.class, SolidityFunctionWrapper.funcNameToConst(functionName), Arrays.class, com.alaya.abi.solidity.datatypes.Type.class, inputParams, Collections.class, TypeReference.class});
        if (functionDefinition.isPayable()) {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function, $N)", new Object[]{WEI_VALUE});
        } else {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function)", new Object[0]);
        }
    }

    TypeSpec buildEventResponseObject(String className, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        TypeName typeName;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        builder.addField((TypeName)LOG, "log", new Modifier[]{Modifier.PUBLIC});
        for (NamedTypeName namedType : indexedParameters) {
            typeName = this.getIndexedEventWrapperType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        for (NamedTypeName namedType : nonIndexedParameters) {
            typeName = this.getWrapperType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        return builder.build();
    }

    MethodSpec buildEventObservableFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) throws ClassNotFoundException {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventObservable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Observable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder observableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(PlatonFilter.class, FILTER, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        TypeSpec converter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Func1.class), (TypeName[])new TypeName[]{ClassName.get(Log.class), ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Log.class, "log", new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)responseClassName, (String[])new String[0])).addStatement("$T eventValues = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", log)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, true)).addStatement("return typedResponse", new Object[0]).build()).build();
        observableMethodBuilder.addStatement("return web3j.platonLogObservable(filter).map($L)", new Object[]{converter});
        return observableMethodBuilder.build();
    }

    MethodSpec buildDefaultEventObservableFunction(String responseClassName, String functionName) {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventObservable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Observable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder observableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(DefaultBlockParameter.class, START_BLOCK, new Modifier[0]).addParameter(DefaultBlockParameter.class, END_BLOCK, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        observableMethodBuilder.addStatement("$1T filter = new $1T($2L, $3L, getContractAddress())", new Object[]{PlatonFilter.class, START_BLOCK, END_BLOCK}).addStatement("filter.addSingleTopic($T.encode(" + this.buildEventDefinitionName(functionName) + "))", new Object[]{EventEncoder.class}).addStatement("return " + generatedFunctionName + "(filter)", new Object[0]);
        return observableMethodBuilder.build();
    }

    MethodSpec buildEventTransactionReceiptFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        String generatedFunctionName = "get" + Strings.capitaliseFirstLetter((String)functionName) + "Events";
        MethodSpec.Builder transactionMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]).returns((TypeName)parameterizedTypeName);
        transactionMethodBuilder.addStatement("$T valueList = extractEventParametersWithLog(" + this.buildEventDefinitionName(functionName) + ", transactionReceipt)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{Contract.EventValuesWithLog.class})}).addStatement("$1T responses = new $1T(valueList.size())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})}).beginControlFlow("for ($T eventValues : valueList)", new Object[]{Contract.EventValuesWithLog.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters, false)).addStatement("responses.add(typedResponse)", new Object[0]).endControlFlow();
        transactionMethodBuilder.addStatement("return responses", new Object[0]);
        return transactionMethodBuilder.build();
    }

    List<MethodSpec> buildEventFunctions(AbiDefinition functionDefinition, TypeSpec.Builder classBuilder) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        List inputs = functionDefinition.getInputs();
        String responseClassName = Strings.capitaliseFirstLetter((String)functionName) + "EventResponse";
        ArrayList<NamedTypeName> parameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> indexedParameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> nonIndexedParameters = new ArrayList<NamedTypeName>();
        for (AbiDefinition.NamedType namedType : inputs) {
            NamedTypeName parameter = new NamedTypeName(namedType.getName(), SolidityFunctionWrapper.buildTypeName(namedType.getType()), namedType.isIndexed());
            if (namedType.isIndexed()) {
                indexedParameters.add(parameter);
            } else {
                nonIndexedParameters.add(parameter);
            }
            parameters.add(parameter);
        }
        classBuilder.addField(this.createEventDefinition(functionName, parameters));
        classBuilder.addType(this.buildEventResponseObject(responseClassName, indexedParameters, nonIndexedParameters));
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.buildEventTransactionReceiptFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildEventObservableFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        methods.add(this.buildDefaultEventObservableFunction(responseClassName, functionName));
        return methods;
    }

    CodeBlock buildTypedResponse(String objectName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters, boolean observable) {
        int i;
        String nativeConversion = this.useNativeJavaTypes ? ".getValue()" : "";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (observable) {
            builder.addStatement("$L.log = log", new Object[]{objectName});
        } else {
            builder.addStatement("$L.log = eventValues.getLog()", new Object[]{objectName});
        }
        for (i = 0; i < indexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, indexedParameters.get(i).getName(), this.getIndexedEventWrapperType(indexedParameters.get(i).getTypeName()), i});
        }
        for (i = 0; i < nonIndexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getNonIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, nonIndexedParameters.get(i).getName(), this.getWrapperType(nonIndexedParameters.get(i).getTypeName()), i});
        }
        return builder.build();
    }

    static TypeName buildTypeName(String typeDeclaration) {
        String type = SolidityFunctionWrapper.trimStorageDeclaration(typeDeclaration);
        Matcher matcher = pattern.matcher(type);
        if (matcher.find()) {
            Class<?> rawType;
            ParameterizedTypeName typeName;
            Class baseType = AbiTypes.getType((String)matcher.group(1));
            String firstArrayDimension = matcher.group(2);
            String secondArrayDimension = matcher.group(3);
            if ("".equals(firstArrayDimension)) {
                typeName = ParameterizedTypeName.get(DynamicArray.class, (Type[])new Type[]{baseType});
            } else {
                rawType = SolidityFunctionWrapper.getStaticArrayTypeReferenceClass(firstArrayDimension);
                typeName = ParameterizedTypeName.get(rawType, (Type[])new Type[]{baseType});
            }
            if (secondArrayDimension != null) {
                if ("".equals(secondArrayDimension)) {
                    return ParameterizedTypeName.get((ClassName)ClassName.get(DynamicArray.class), (TypeName[])new TypeName[]{typeName});
                }
                rawType = SolidityFunctionWrapper.getStaticArrayTypeReferenceClass(secondArrayDimension);
                return ParameterizedTypeName.get((ClassName)ClassName.get(rawType), (TypeName[])new TypeName[]{typeName});
            }
            return typeName;
        }
        Class cls = AbiTypes.getType((String)type);
        return ClassName.get((Class)cls);
    }

    private static Class<?> getStaticArrayTypeReferenceClass(String type) {
        try {
            return Class.forName("com.alaya.abi.solidity.datatypes.generated.StaticArray" + type);
        }
        catch (ClassNotFoundException e) {
            return StaticArray.class;
        }
    }

    private static String trimStorageDeclaration(String type) {
        if (type.endsWith(" storage") || type.endsWith(" memory")) {
            return type.split(" ")[0];
        }
        return type;
    }

    private List<TypeName> buildReturnTypes(List<TypeName> outputParameterTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(outputParameterTypes.size());
        for (TypeName typeName : outputParameterTypes) {
            result.add(this.getWrapperType(typeName));
        }
        return result;
    }

    private static void buildVariableLengthReturnFunctionConstructor(MethodSpec.Builder methodBuilder, String functionName, String inputParameters, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Function.class);
        objects.add(Function.class);
        objects.add(SolidityFunctionWrapper.funcNameToConst(functionName));
        objects.add(Arrays.class);
        objects.add(com.alaya.abi.solidity.datatypes.Type.class);
        objects.add(inputParameters);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (TypeName outputParameterType : outputParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(outputParameterType);
        }
        String asListParams = Collection.join(outputParameterTypes, (String)", ", typeName -> "new $T<$T>() {}");
        methodBuilder.addStatement("final $T function = new $T($N, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray());
    }

    private void buildTupleResultContainer(MethodSpec.Builder methodBuilder, ParameterizedTypeName tupleType, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        List typeArguments = tupleType.typeArguments;
        CodeBlock.Builder tupleConstructor = CodeBlock.builder();
        tupleConstructor.addStatement("$T results = executeCallMultipleValueReturn(function)", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{com.alaya.abi.solidity.datatypes.Type.class})}).add("return new $T(", new Object[]{tupleType}).add("$>$>", new Object[0]);
        String resultStringSimple = "\n($T) results.get($L)";
        if (this.useNativeJavaTypes) {
            resultStringSimple = resultStringSimple + ".getValue()";
        }
        String resultStringNativeList = "\nconvertToNative(($T) results.get($L).getValue())";
        int size = typeArguments.size();
        ClassName classList = ClassName.get(List.class);
        for (int i = 0; i < size; ++i) {
            TypeName param = outputParameterTypes.get(i);
            TypeName convertTo = (TypeName)typeArguments.get(i);
            String resultString = resultStringSimple;
            if (this.useNativeJavaTypes && param instanceof ParameterizedTypeName) {
                ParameterizedTypeName oldContainer = (ParameterizedTypeName)param;
                ParameterizedTypeName newContainer = (ParameterizedTypeName)convertTo;
                if (newContainer.rawType.compareTo(classList) == 0 && newContainer.typeArguments.size() == 1) {
                    convertTo = ParameterizedTypeName.get((ClassName)classList, (TypeName[])new TypeName[]{(TypeName)oldContainer.typeArguments.get(0)});
                    resultString = resultStringNativeList;
                }
            }
            tupleConstructor.add(resultString, new Object[]{convertTo, i});
            tupleConstructor.add(i < size - 1 ? ", " : ");\n", new Object[0]);
        }
        tupleConstructor.add("$<$<", new Object[0]);
        TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{tupleType})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns((TypeName)tupleType).addCode(tupleConstructor.build()).build()).build();
        methodBuilder.addStatement("return new $T(\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteCall((TypeName)tupleType), callableType});
    }

    private static CodeBlock buildVariableLengthEventInitializer(String eventName, List<NamedTypeName> parameterTypes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Event.class);
        objects.add(eventName);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (NamedTypeName parameterType : parameterTypes) {
            objects.add(TypeReference.class);
            objects.add(parameterType.getTypeName());
        }
        String asListParams = parameterTypes.stream().map(type -> {
            if (type.isIndexed()) {
                return "new $T<$T>(true) {}";
            }
            return "new $T<$T>() {}";
        }).collect(Collectors.joining(", "));
        return CodeBlock.builder().addStatement("new $T($S, \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray()).build();
    }

    private List<AbiDefinition> loadContractDefinition(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(abi, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private static String funcNameToConst(String funcName) {
        return FUNC_NAME_PREFIX + funcName.toUpperCase();
    }

    private static class NamedTypeName {
        private final TypeName typeName;
        private final String name;
        private final boolean indexed;

        NamedTypeName(String name, TypeName typeName, boolean indexed) {
            this.name = name;
            this.typeName = typeName;
            this.indexed = indexed;
        }

        public String getName() {
            return this.name;
        }

        public TypeName getTypeName() {
            return this.typeName;
        }

        public boolean isIndexed() {
            return this.indexed;
        }
    }
}

