/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.wasm;

import com.alaya.abi.wasm.datatypes.WasmEvent;
import com.alaya.crypto.Hash;
import com.alaya.rlp.wasm.RLPCodec;
import com.alaya.rlp.wasm.datatypes.Int;
import com.alaya.rlp.wasm.datatypes.Int8;
import com.alaya.rlp.wasm.datatypes.Uint;
import com.alaya.rlp.wasm.datatypes.Uint8;
import com.alaya.rlp.wasm.datatypes.WasmAddress;
import com.alaya.utils.Numeric;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class WasmEventEncoder {
    private static final int MAX_BIT_LENGTH = 256;
    private static final int MAX_BYTE_LENGTH = 32;
    private static final int MAX_HEX_LENGTH = 64;

    private WasmEventEncoder() {
    }

    public static String encode(WasmEvent event) {
        return WasmEventEncoder.encodeString(event.getName());
    }

    public static String encodeIndexParameter(Object o) {
        if (o instanceof Int) {
            return WasmEventEncoder.encodeInt((Int)o);
        }
        if (o instanceof Uint) {
            return WasmEventEncoder.encodeUint((Uint)o);
        }
        if (o instanceof WasmAddress) {
            return WasmEventEncoder.encodeAddress((WasmAddress)o);
        }
        if (o instanceof Boolean) {
            return WasmEventEncoder.encodeBoolean((Boolean)o);
        }
        if (o instanceof String) {
            return WasmEventEncoder.encodeString((String)o);
        }
        if (o instanceof List) {
            return WasmEventEncoder.encodeList((List)o);
        }
        if (o instanceof byte[]) {
            return WasmEventEncoder.encodeBytes((byte[])o);
        }
        if (o.getClass().isArray()) {
            return WasmEventEncoder.encodeArray((Object[])o);
        }
        return WasmEventEncoder.encodeBytes(RLPCodec.encode((Object)o));
    }

    private static String encodeUint(BigInteger number) {
        return Numeric.toHexStringWithPrefixZeroPadded((BigInteger)number, (int)64);
    }

    private static String encodeInt(Int number) {
        return WasmEventEncoder.encodeUint(number.getUnsingedValue());
    }

    private static String encodeUint(Uint number) {
        return WasmEventEncoder.encodeUint(number.getValue());
    }

    private static String encodeString(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return WasmEventEncoder.encodeBytes(bytes);
    }

    private static String encodeArray(Object[] objectArray) {
        return WasmEventEncoder.encodeList(Arrays.asList(objectArray));
    }

    private static String encodeList(List<?> uintList) {
        if (uintList.stream().filter(item -> item instanceof Uint8).count() == (long)uintList.size()) {
            return WasmEventEncoder.encodeBytes(uintList.stream().map(item -> ((Uint8)item).getValue().byteValue()).collect(Collectors.toList()));
        }
        if (uintList.stream().filter(item -> item instanceof Int8).count() == (long)uintList.size()) {
            return WasmEventEncoder.encodeBytes(uintList.stream().map(item -> ((Int8)item).getValue()).collect(Collectors.toList()));
        }
        return WasmEventEncoder.encodeBytes(RLPCodec.encode(uintList));
    }

    private static String encodeBytes(List<Byte> list) {
        byte[] bytes = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            bytes[i] = list.get(i);
        }
        return WasmEventEncoder.encodeBytes(bytes);
    }

    private static String encodeBytes(byte[] bytes) {
        if (bytes.length > 32) {
            bytes = Hash.sha3((byte[])bytes);
        }
        return WasmEventEncoder.encodeUint(Numeric.toBigInt((byte[])bytes));
    }

    private static String encodeBoolean(Boolean bool) {
        BigInteger number = BigInteger.ZERO;
        if (bool.booleanValue()) {
            number = BigInteger.ONE;
        }
        return WasmEventEncoder.encodeUint(number);
    }

    private static String encodeAddress(WasmAddress address) {
        return WasmEventEncoder.encodeUint(address.getBigIntValue());
    }
}

