/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.abi.wasm;

import com.alaya.abi.wasm.datatypes.WasmFunction;
import com.alaya.rlp.wasm.RLPCodec;
import com.alaya.rlp.wasm.datatypes.Uint64;
import com.alaya.utils.Numeric;
import java.util.ArrayList;
import java.util.List;

public class WasmFunctionEncoder {
    public static byte[] MAGIC_NUM = new byte[]{0, 97, 115, 109};
    public static String DEPLOY_METHOD_NAME = "init";
    private static final long FNV_64_INIT = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;

    public static String encode(WasmFunction function) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(WasmFunctionEncoder.fnvOne64Hash(function.getName()));
        for (Object o : function.getInputParameters()) {
            if (o.equals(Void.class)) continue;
            parameters.add(o);
        }
        byte[] data = RLPCodec.encode(parameters);
        return Numeric.toHexStringNoPrefix((byte[])data);
    }

    public static String encodeConstructor(String code, List<?> inputParameters) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(WasmFunctionEncoder.fnvOne64Hash(DEPLOY_METHOD_NAME));
        for (Object o : inputParameters) {
            if (o.equals(Void.class)) continue;
            parameters.add(o);
        }
        byte[] parameterData = RLPCodec.encode(parameters);
        byte[] codeBinary = Numeric.hexStringToByteArray((String)code);
        Object[] objs = new Object[]{codeBinary, parameterData};
        byte[] data = RLPCodec.encode((Object)objs);
        byte[] result = new byte[MAGIC_NUM.length + data.length];
        System.arraycopy(MAGIC_NUM, 0, result, 0, MAGIC_NUM.length);
        System.arraycopy(data, 0, result, MAGIC_NUM.length, data.length);
        return Numeric.toHexStringNoPrefix((byte[])result);
    }

    public static Uint64 fnvOne64Hash(String value) {
        long rv = -3750763034362895579L;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            rv *= 1099511628211L;
            rv ^= (long)value.charAt(i);
        }
        return Uint64.of((String)Long.toUnsignedString(rv));
    }
}

