/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos;

import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.abi.solidity.datatypes.generated.Uint16;
import com.alaya.abi.solidity.datatypes.generated.Uint256;
import com.alaya.abi.solidity.datatypes.generated.Uint64;
import com.alaya.bech32.Bech32;
import com.alaya.contracts.ppos.BaseContract;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.dto.CallResponse;
import com.alaya.contracts.ppos.dto.TransactionResponse;
import com.alaya.contracts.ppos.dto.enums.StakingAmountType;
import com.alaya.contracts.ppos.dto.resp.Delegation;
import com.alaya.contracts.ppos.dto.resp.DelegationIdInfo;
import com.alaya.contracts.ppos.exception.EstimateGasException;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.Log;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.rlp.solidity.RlpDecoder;
import com.alaya.rlp.solidity.RlpList;
import com.alaya.rlp.solidity.RlpString;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class DelegateContract
extends BaseContract {
    public static DelegateContract load(Web3j web3j, long chainId) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking((long)chainId), web3j);
    }

    public static DelegateContract load(Web3j web3j, TransactionManager transactionManager, long chainId) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking((long)chainId), web3j, transactionManager);
    }

    public static DelegateContract load(Web3j web3j, Credentials credentials, long chainId) {
        return new DelegateContract(NetworkParameters.getPposContractAddressOfStaking((long)chainId), chainId, web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private DelegateContract(String contractAddress, long chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private DelegateContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> delegate(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getDelegateGasProvider(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> delegateReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createDelegateFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createDelegateFunction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = new Function(1004, Arrays.asList(new Uint16((long)stakingAmountType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)));
        return function;
    }

    public RemoteCall<TransactionResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> unDelegate(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getUnDelegateGasProvider(String nodeId, BigInteger stakingBlockNum, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> unDelegateReturnTransaction(String nodeId, BigInteger stakingBlockNum, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createUnDelegateFunction(nodeId, stakingBlockNum, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createUnDelegateFunction(String nodeId, BigInteger stakingBlockNum, BigInteger amount) {
        Function function = new Function(1005, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint256(amount)));
        return function;
    }

    public BigInteger decodeUnDelegateLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt logs[0].data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        if (statusCode != 0) {
            throw new TransactionException("TransactionResponse code is 0");
        }
        return ((RlpString)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).asPositiveBigInteger();
    }

    public RemoteCall<CallResponse<Delegation>> getDelegateInfo(String nodeId, String delAddr, BigInteger stakingBlockNum) {
        Function function = new Function(1104, Arrays.asList(new Uint64(stakingBlockNum), new BytesType(Bech32.addressDecode((String)delAddr)), new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return this.executeRemoteCallObjectValueReturn(function, Delegation.class);
    }

    public RemoteCall<CallResponse<List<DelegationIdInfo>>> getRelatedListByDelAddr(String address) {
        Function function = new Function(1103, Arrays.asList(new BytesType(Bech32.addressDecode((String)address))));
        return this.executeRemoteCallListValueReturn(function, DelegationIdInfo.class);
    }
}

