/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos;

import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Uint32;
import com.alaya.abi.solidity.datatypes.generated.Uint8;
import com.alaya.contracts.ppos.BaseContract;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.dto.CallResponse;
import com.alaya.contracts.ppos.dto.TransactionResponse;
import com.alaya.contracts.ppos.dto.enums.VoteOption;
import com.alaya.contracts.ppos.dto.resp.GovernParam;
import com.alaya.contracts.ppos.dto.resp.Proposal;
import com.alaya.contracts.ppos.dto.resp.TallyResult;
import com.alaya.contracts.ppos.exception.EstimateGasException;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.protocol.core.methods.response.bean.ProgramVersion;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class ProposalContract
extends BaseContract {
    public static ProposalContract load(Web3j web3j, long chainId) {
        return new ProposalContract(NetworkParameters.getPposContractAddressOfProposal((long)chainId), web3j);
    }

    public static ProposalContract load(Web3j web3j, TransactionManager transactionManager, long chainId) {
        return new ProposalContract(NetworkParameters.getPposContractAddressOfProposal((long)chainId), web3j, transactionManager);
    }

    public static ProposalContract load(Web3j web3j, Credentials credentials, long chainId) {
        return new ProposalContract(NetworkParameters.getPposContractAddressOfProposal((long)chainId), chainId, web3j, credentials);
    }

    private ProposalContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private ProposalContract(String contractAddress, long chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private ProposalContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<CallResponse<Proposal>> getProposal(String proposalId) {
        Function function = new Function(2100, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)proposalId))));
        return this.executeRemoteCallObjectValueReturn(function, Proposal.class);
    }

    public RemoteCall<CallResponse<TallyResult>> getTallyResult(String proposalId) {
        Function function = new Function(2101, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)proposalId))));
        return this.executeRemoteCallObjectValueReturn(function, TallyResult.class);
    }

    public RemoteCall<CallResponse<List<Proposal>>> getProposalList() {
        Function function = new Function(2102, Arrays.asList(new Type[0]));
        return this.executeRemoteCallListValueReturn(function, Proposal.class);
    }

    public RemoteCall<TransactionResponse> vote(ProgramVersion programVersion, VoteOption voteOption, String proposalID, String verifier) {
        Function function = this.createVoteFunction(programVersion, proposalID, verifier, voteOption);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> vote(ProgramVersion programVersion, VoteOption voteOption, String proposalID, String verifier, GasProvider gasProvider) {
        Function function = this.createVoteFunction(programVersion, proposalID, verifier, voteOption);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getVoteProposalGasProvider(ProgramVersion programVersion, VoteOption voteOption, String proposalID, String verifier) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createVoteFunction(programVersion, proposalID, verifier, voteOption);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> voteReturnTransaction(ProgramVersion programVersion, VoteOption voteOption, String proposalID, String verifier) {
        Function function = this.createVoteFunction(programVersion, proposalID, verifier, voteOption);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> voteReturnTransaction(ProgramVersion programVersion, String proposalID, String verifier, VoteOption voteOption, GasProvider gasProvider) {
        Function function = this.createVoteFunction(programVersion, proposalID, verifier, voteOption);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createVoteFunction(ProgramVersion programVersion, String proposalID, String verifier, VoteOption voteOption) {
        Function function = new Function(2003, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)verifier)), new BytesType(Numeric.hexStringToByteArray((String)proposalID)), new Uint8((long)voteOption.getValue()), new Uint32(programVersion.getProgramVersion()), new BytesType(Numeric.hexStringToByteArray((String)programVersion.getProgramVersionSign()))));
        return function;
    }

    public RemoteCall<TransactionResponse> declareVersion(ProgramVersion programVersion, String verifier) {
        Function function = this.createDeclareVersionFunction(programVersion, verifier);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> declareVersion(ProgramVersion programVersion, String verifier, GasProvider gasProvider) {
        Function function = this.createDeclareVersionFunction(programVersion, verifier);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getDeclareVersionGasProvider(ProgramVersion programVersion, String verifier) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createDeclareVersionFunction(programVersion, verifier);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> declareVersionReturnTransaction(ProgramVersion programVersion, String verifier) {
        Function function = this.createDeclareVersionFunction(programVersion, verifier);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> declareVersionReturnTransaction(ProgramVersion programVersion, String verifier, GasProvider gasProvider) {
        Function function = this.createDeclareVersionFunction(programVersion, verifier);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createDeclareVersionFunction(ProgramVersion programVersion, String verifier) {
        Function function = new Function(2004, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)verifier)), new Uint32(programVersion.getProgramVersion()), new BytesType(Numeric.hexStringToByteArray((String)programVersion.getProgramVersionSign()))));
        return function;
    }

    public RemoteCall<TransactionResponse> submitProposal(Proposal proposal) {
        Function function = this.createSubmitProposalFunction(proposal);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> submitProposal(Proposal proposal, GasProvider gasProvider) {
        Function function = this.createSubmitProposalFunction(proposal);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getSubmitProposalGasProvider(Proposal proposal) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createSubmitProposalFunction(proposal);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> submitProposalReturnTransaction(Proposal proposal) {
        Function function = this.createSubmitProposalFunction(proposal);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> submitProposalReturnTransaction(Proposal proposal, GasProvider gasProvider) {
        Function function = this.createSubmitProposalFunction(proposal);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createSubmitProposalFunction(Proposal proposal) {
        if (proposal == null) {
            throw new NullPointerException("proposal must not be null");
        }
        Function function = new Function(proposal.getSubmitFunctionType(), proposal.getSubmitInputParameters());
        return function;
    }

    public RemoteCall<CallResponse<BigInteger>> getActiveVersion() {
        Function function = new Function(2103);
        return this.executeRemoteCallObjectValueReturn(function, BigInteger.class);
    }

    public RemoteCall<CallResponse<String>> getGovernParamValue(String module, String name) {
        Function function = new Function(2104, Arrays.asList(new Utf8String(module), new Utf8String(name)));
        return this.executeRemoteCallObjectValueReturn(function, String.class);
    }

    public RemoteCall<CallResponse<List<BigInteger>>> getAccuVerifiersCount(String proposalId, String blockHash) {
        Function function = new Function(2105, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)proposalId)), new BytesType(Numeric.hexStringToByteArray((String)blockHash))));
        return this.executeRemoteCallListValueReturn(function, BigInteger.class);
    }

    public RemoteCall<CallResponse<List<GovernParam>>> getParamList(String module) {
        Function function = new Function(2106, Arrays.asList(new Utf8String(module)));
        return this.executeRemoteCallListValueReturn(function, GovernParam.class);
    }
}

