/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos;

import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.bech32.Bech32;
import com.alaya.contracts.ppos.BaseContract;
import com.alaya.contracts.ppos.abi.CustomStaticArray;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.dto.CallResponse;
import com.alaya.contracts.ppos.dto.RestrictingPlan;
import com.alaya.contracts.ppos.dto.TransactionResponse;
import com.alaya.contracts.ppos.dto.req.CreateRestrictingParam;
import com.alaya.contracts.ppos.dto.resp.RestrictingItem;
import com.alaya.contracts.ppos.exception.EstimateGasException;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class RestrictingPlanContract
extends BaseContract {
    public static RestrictingPlanContract load(Web3j web3j, long chainId) {
        return new RestrictingPlanContract(NetworkParameters.getPposContractAddressOfRestrctingPlan((long)chainId), web3j);
    }

    public static RestrictingPlanContract load(Web3j web3j, TransactionManager transactionManager, long chainId) {
        return new RestrictingPlanContract(NetworkParameters.getPposContractAddressOfRestrctingPlan((long)chainId), web3j, transactionManager);
    }

    public static RestrictingPlanContract load(Web3j web3j, Credentials credentials, long chainId) {
        return new RestrictingPlanContract(NetworkParameters.getPposContractAddressOfRestrctingPlan((long)chainId), chainId, web3j, credentials);
    }

    private RestrictingPlanContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private RestrictingPlanContract(String contractAddress, long chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private RestrictingPlanContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> createRestrictingPlan(String account, List<RestrictingPlan> restrictingPlanList) {
        Function function = this.createRestrictingPlanFunction(account, restrictingPlanList);
        return this.executeRemoteCallTransaction(function);
    }

    public GasProvider getCreateRestrictingPlanGasProvider(CreateRestrictingParam param) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createRestrictingPlanFunction(param.getAccount(), Arrays.asList(param.getPlans()));
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<TransactionResponse> createRestrictingPlan(String account, List<RestrictingPlan> restrictingPlanList, GasProvider gasProvider) {
        Function function = this.createRestrictingPlanFunction(account, restrictingPlanList);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getCreateRestrictingPlan(String account, List<RestrictingPlan> restrictingPlanList) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createRestrictingPlanFunction(account, restrictingPlanList);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> createRestrictingPlanReturnTransaction(String account, List<RestrictingPlan> restrictingPlanList) {
        Function function = this.createRestrictingPlanFunction(account, restrictingPlanList);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> createRestrictingPlanReturnTransaction(String account, List<RestrictingPlan> restrictingPlanList, GasProvider gasProvider) {
        Function function = this.createRestrictingPlanFunction(account, restrictingPlanList);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createRestrictingPlanFunction(String account, List<RestrictingPlan> restrictingPlanList) {
        Function function = new Function(4000, Arrays.asList(new BytesType(Bech32.addressDecode((String)account)), new CustomStaticArray<RestrictingPlan>(restrictingPlanList)));
        return function;
    }

    public RemoteCall<CallResponse<RestrictingItem>> getRestrictingInfo(String account) {
        Function function = new Function(4100, Arrays.asList(new BytesType(Bech32.addressDecode((String)account))));
        return this.executeRemoteCallObjectValueReturn(function, RestrictingItem.class);
    }
}

