/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos;

import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.bech32.Bech32;
import com.alaya.contracts.ppos.BaseContract;
import com.alaya.contracts.ppos.abi.CustomStaticArray;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.abi.custom.NodeId;
import com.alaya.contracts.ppos.dto.CallResponse;
import com.alaya.contracts.ppos.dto.TransactionResponse;
import com.alaya.contracts.ppos.dto.resp.Reward;
import com.alaya.contracts.ppos.exception.EstimateGasException;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.Log;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.rlp.solidity.RlpDecoder;
import com.alaya.rlp.solidity.RlpList;
import com.alaya.rlp.solidity.RlpString;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RewardContract
extends BaseContract {
    public static RewardContract load(Web3j web3j, long chainId) {
        return new RewardContract(NetworkParameters.getPposContractAddressOfReward((long)chainId), web3j);
    }

    public static RewardContract load(Web3j web3j, TransactionManager transactionManager, long chainId) {
        return new RewardContract(NetworkParameters.getPposContractAddressOfReward((long)chainId), web3j, transactionManager);
    }

    public static RewardContract load(Web3j web3j, Credentials credentials, long chainId) {
        return new RewardContract(NetworkParameters.getPposContractAddressOfReward((long)chainId), chainId, web3j, credentials);
    }

    private RewardContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private RewardContract(String contractAddress, long chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private RewardContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> withdrawDelegateReward() {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> withdrawDelegateReward(GasProvider gasProvider) {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getWithdrawDelegateRewardGasProvider() throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> withdrawDelegateRewardReturnTransaction() {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> withdrawDelegateRewardReturnTransaction(GasProvider gasProvider) {
        Function function = this.createWithdrawDelegateRewardFunction();
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createWithdrawDelegateRewardFunction() {
        Function function = new Function(5000);
        return function;
    }

    public List<Reward> decodeWithdrawDelegateRewardLog(TransactionReceipt transactionReceipt) throws TransactionException {
        List<Log> logs = transactionReceipt.getLogs();
        if (logs == null || logs.isEmpty()) {
            throw new TransactionException("TransactionReceipt logs is empty");
        }
        String logData = logs.get(0).getData();
        if (null == logData || "".equals(logData)) {
            throw new TransactionException("TransactionReceipt logs[0].data is empty");
        }
        RlpList rlp = RlpDecoder.decode((byte[])Numeric.hexStringToByteArray((String)logData));
        List rlpList = ((RlpList)rlp.getValues().get(0)).getValues();
        String decodedStatus = new String(((RlpString)rlpList.get(0)).getBytes());
        int statusCode = Integer.parseInt(decodedStatus);
        if (statusCode != 0) {
            throw new TransactionException("TransactionResponse code is 0");
        }
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        ((RlpList)RlpDecoder.decode((byte[])((RlpString)rlpList.get(1)).getBytes()).getValues().get(0)).getValues().stream().forEach(rl -> {
            RlpList rlpL = (RlpList)rl;
            Reward reward = new Reward();
            reward.setNodeId(((RlpString)rlpL.getValues().get(0)).asString());
            reward.setStakingNum(((RlpString)rlpL.getValues().get(1)).asPositiveBigInteger());
            reward.setRewardBigIntegerValue(((RlpString)rlpL.getValues().get(2)).asPositiveBigInteger());
            rewards.add(reward);
        });
        return rewards;
    }

    public RemoteCall<CallResponse<List<Reward>>> getDelegateReward(String address, List<String> nodeList) {
        List bytesTypeList = nodeList.stream().map(nodeId -> new NodeId((String)nodeId)).collect(Collectors.toList());
        CustomStaticArray dynamicArray = new CustomStaticArray(bytesTypeList);
        Function function = new Function(5100, Arrays.asList(new BytesType(Bech32.addressDecode((String)address)), dynamicArray));
        return this.executeRemoteCallListValueReturn(function, Reward.class);
    }
}

