/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos;

import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.abi.solidity.datatypes.Utf8String;
import com.alaya.abi.solidity.datatypes.generated.Uint32;
import com.alaya.abi.solidity.datatypes.generated.Uint64;
import com.alaya.contracts.ppos.BaseContract;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.dto.CallResponse;
import com.alaya.contracts.ppos.dto.TransactionResponse;
import com.alaya.contracts.ppos.dto.common.DuplicateSignType;
import com.alaya.contracts.ppos.exception.EstimateGasException;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class SlashContract
extends BaseContract {
    public static SlashContract load(Web3j web3j, long chainId) {
        return new SlashContract(NetworkParameters.getPposContractAddressOfSlash((long)chainId), web3j);
    }

    public static SlashContract load(Web3j web3j, TransactionManager transactionManager, long chainId) {
        return new SlashContract(NetworkParameters.getPposContractAddressOfSlash((long)chainId), web3j, transactionManager);
    }

    public static SlashContract load(Web3j web3j, Credentials credentials, long chainId) {
        return new SlashContract(NetworkParameters.getPposContractAddressOfSlash((long)chainId), chainId, web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private SlashContract(String contractAddress, long chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private SlashContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<TransactionResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> reportDoubleSign(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getReportDoubleSignGasProvider(DuplicateSignType duplicateSignType, String data) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> reportDoubleSignReturnTransaction(DuplicateSignType duplicateSignType, String data, GasProvider gasProvider) {
        Function function = this.createReportDoubleSignFunction(duplicateSignType, data);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createReportDoubleSignFunction(DuplicateSignType duplicateSignType, String data) {
        Function function = new Function(3000, Arrays.asList(new Uint32(BigInteger.valueOf(duplicateSignType.getValue())), new Utf8String(data)));
        return function;
    }

    public RemoteCall<CallResponse<String>> checkDoubleSign(DuplicateSignType doubleSignType, String nodeId, BigInteger blockNumber) {
        Function function = new Function(3001, Arrays.asList(new Uint32((long)doubleSignType.getValue()), new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint64(blockNumber)));
        return this.executeRemoteCallObjectValueReturn(function, String.class);
    }
}

