/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos;

import com.alaya.abi.solidity.datatypes.BytesType;
import com.alaya.abi.solidity.datatypes.generated.Uint16;
import com.alaya.abi.solidity.datatypes.generated.Uint256;
import com.alaya.contracts.ppos.BaseContract;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.dto.CallResponse;
import com.alaya.contracts.ppos.dto.TransactionResponse;
import com.alaya.contracts.ppos.dto.enums.StakingAmountType;
import com.alaya.contracts.ppos.dto.req.StakingParam;
import com.alaya.contracts.ppos.dto.req.UpdateStakingParam;
import com.alaya.contracts.ppos.dto.resp.Node;
import com.alaya.contracts.ppos.exception.EstimateGasException;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class StakingContract
extends BaseContract {
    public static StakingContract load(Web3j web3j, long chainId) {
        return new StakingContract(NetworkParameters.getPposContractAddressOfStaking((long)chainId), web3j);
    }

    public static StakingContract load(Web3j web3j, TransactionManager transactionManager, long chainId) {
        return new StakingContract(NetworkParameters.getPposContractAddressOfStaking((long)chainId), web3j, transactionManager);
    }

    public static StakingContract load(Web3j web3j, Credentials credentials, long chainId) {
        return new StakingContract(NetworkParameters.getPposContractAddressOfStaking((long)chainId), chainId, web3j, credentials);
    }

    private StakingContract(String contractAddress, Web3j web3j) {
        super(contractAddress, web3j);
    }

    private StakingContract(String contractAddress, long chainId, Web3j web3j, Credentials credentials) {
        super(contractAddress, chainId, web3j, credentials);
    }

    private StakingContract(String contractAddress, Web3j web3j, TransactionManager transactionManager) {
        super(contractAddress, web3j, transactionManager);
    }

    public RemoteCall<CallResponse<Node>> getStakingInfo(String nodeId) {
        Function function = new Function(1105, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return this.executeRemoteCallObjectValueReturn(function, Node.class);
    }

    public RemoteCall<CallResponse<BigInteger>> getPackageReward() {
        Function function = new Function(1200);
        return this.executeRemoteCallObjectValueReturn(function, BigInteger.class);
    }

    public RemoteCall<CallResponse<BigInteger>> getStakingReward() {
        Function function = new Function(1201);
        return this.executeRemoteCallObjectValueReturn(function, BigInteger.class);
    }

    public RemoteCall<CallResponse<BigInteger>> getAvgPackTime() {
        Function function = new Function(1202);
        return this.executeRemoteCallObjectValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionResponse> staking(StakingParam stakingParam) {
        Function function = this.createStakingFunction(stakingParam);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> staking(StakingParam stakingParam, GasProvider gasProvider) {
        Function function = this.createStakingFunction(stakingParam);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getStakingGasProvider(StakingParam stakingParam) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createStakingFunction(stakingParam);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> stakingReturnTransaction(StakingParam stakingParam) {
        Function function = this.createStakingFunction(stakingParam);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> stakingReturnTransaction(StakingParam stakingParam, GasProvider gasProvider) {
        Function function = this.createStakingFunction(stakingParam);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createStakingFunction(StakingParam stakingParam) {
        Function function = new Function(1000, stakingParam.getSubmitInputParameters());
        return function;
    }

    public RemoteCall<TransactionResponse> unStaking(String nodeId) {
        Function function = this.createUnStakingFunction(nodeId);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> unStaking(String nodeId, GasProvider gasProvider) {
        Function function = this.createUnStakingFunction(nodeId);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getUnStakingGasProvider(String nodeId) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createUnStakingFunction(nodeId);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> unStakingReturnTransaction(String nodeId) {
        Function function = this.createUnStakingFunction(nodeId);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> unStakingReturnTransaction(String nodeId, GasProvider gasProvider) {
        Function function = this.createUnStakingFunction(nodeId);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createUnStakingFunction(String nodeId) {
        Function function = new Function(1003, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)nodeId))));
        return function;
    }

    public RemoteCall<TransactionResponse> updateStakingInfo(UpdateStakingParam updateStakingParam) {
        Function function = this.createUpdateStakingFunction(updateStakingParam);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> updateStakingInfo(UpdateStakingParam updateStakingParam, GasProvider gasProvider) {
        Function function = this.createUpdateStakingFunction(updateStakingParam);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getUpdateStakingInfoGasProvider(UpdateStakingParam updateStakingParam) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createUpdateStakingFunction(updateStakingParam);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> updateStakingInfoReturnTransaction(UpdateStakingParam updateStakingParam) {
        Function function = this.createUpdateStakingFunction(updateStakingParam);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> updateStakingInfoReturnTransaction(UpdateStakingParam updateStakingParam, GasProvider gasProvider) {
        Function function = this.createUpdateStakingFunction(updateStakingParam);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createUpdateStakingFunction(UpdateStakingParam updateStakingParam) {
        Function function = new Function(1001, updateStakingParam.getSubmitInputParameters());
        return function;
    }

    public RemoteCall<TransactionResponse> addStaking(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createAddStakingFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionResponse> addStaking(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createAddStakingFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransaction(function, gasProvider);
    }

    public GasProvider getAddStakingGasProvider(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) throws IOException, EstimateGasException, NoSupportFunctionType {
        Function function = this.createAddStakingFunction(nodeId, stakingAmountType, amount);
        return this.getDefaultGasProvider(function);
    }

    public RemoteCall<PlatonSendTransaction> addStakingReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = this.createAddStakingFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function);
    }

    public RemoteCall<PlatonSendTransaction> addStakingReturnTransaction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount, GasProvider gasProvider) {
        Function function = this.createAddStakingFunction(nodeId, stakingAmountType, amount);
        return this.executeRemoteCallTransactionStep1(function, gasProvider);
    }

    private Function createAddStakingFunction(String nodeId, StakingAmountType stakingAmountType, BigInteger amount) {
        Function function = new Function(1002, Arrays.asList(new BytesType(Numeric.hexStringToByteArray((String)nodeId)), new Uint16((long)stakingAmountType.getValue()), new Uint256(amount)));
        return function;
    }
}

