/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.contracts.ppos.utils;

import com.alaya.abi.solidity.datatypes.Type;
import com.alaya.contracts.ppos.abi.CustomStaticArray;
import com.alaya.contracts.ppos.abi.Function;
import com.alaya.contracts.ppos.exception.NoSupportFunctionType;
import com.alaya.contracts.ppos.utils.EncoderUtils;
import com.alaya.utils.Numeric;
import java.math.BigInteger;
import java.util.List;

public class EstimateGasUtil {
    private static final BigInteger BASE_DEFAULT_GAS_LIMIT = BigInteger.valueOf(21000L);
    private static final BigInteger BASE_NON_ZERO_GAS_LIMIT = BigInteger.valueOf(68L);
    private static final BigInteger BASE_ZERO_GAS_LIMIT = BigInteger.valueOf(4L);

    public static BigInteger getGasLimit(Function function) throws NoSupportFunctionType {
        if (EstimateGasUtil.isSupportLocal(function.getType())) {
            return BASE_DEFAULT_GAS_LIMIT.add(EstimateGasUtil.getContractGasLimit(function.getType())).add(EstimateGasUtil.getFunctionGasLimit(function.getType())).add(EstimateGasUtil.getInterfaceDynamicGasLimit(function.getType(), function.getInputParameters())).add(EstimateGasUtil.getDataGasLimit(EncoderUtils.functionEncoder(function)));
        }
        throw new NoSupportFunctionType(function.getType());
    }

    public static boolean isSupportLocal(int type) {
        switch (type) {
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 3000: 
            case 4000: {
                return true;
            }
        }
        return false;
    }

    private static BigInteger getContractGasLimit(int type) {
        switch (type) {
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: {
                return BigInteger.valueOf(6000L);
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                return BigInteger.valueOf(9000L);
            }
            case 3000: {
                return BigInteger.valueOf(21000L);
            }
            case 4000: {
                return BigInteger.valueOf(18000L);
            }
        }
        return BigInteger.valueOf(0L);
    }

    private static BigInteger getFunctionGasLimit(int type) {
        switch (type) {
            case 2002: 
            case 2005: {
                return BigInteger.valueOf(500000L);
            }
            case 2001: {
                return BigInteger.valueOf(450000L);
            }
            case 2000: {
                return BigInteger.valueOf(320000L);
            }
            case 1000: {
                return BigInteger.valueOf(32000L);
            }
            case 1001: {
                return BigInteger.valueOf(12000L);
            }
            case 1002: 
            case 1003: {
                return BigInteger.valueOf(20000L);
            }
            case 1004: {
                return BigInteger.valueOf(16000L);
            }
            case 1005: 
            case 4000: {
                return BigInteger.valueOf(8000L);
            }
            case 2004: {
                return BigInteger.valueOf(3000L);
            }
            case 2003: {
                return BigInteger.valueOf(2000L);
            }
            case 3000: {
                return BigInteger.valueOf(42000L);
            }
        }
        return BigInteger.valueOf(0L);
    }

    private static BigInteger getInterfaceDynamicGasLimit(int type, List<Type> inputParameters) {
        if (type == 4000 && inputParameters.size() > 1 && inputParameters.get(1) instanceof CustomStaticArray) {
            return BigInteger.valueOf(((CustomStaticArray)inputParameters.get(1)).getValue().size()).multiply(BASE_DEFAULT_GAS_LIMIT);
        }
        return BigInteger.ZERO;
    }

    private static BigInteger getDataGasLimit(String rlpData) {
        byte[] bytes = Numeric.hexStringToByteArray((String)rlpData);
        int nonZeroSize = 0;
        int zeroSize = 0;
        for (byte b : bytes) {
            if (b != 0) {
                ++nonZeroSize;
                continue;
            }
            ++zeroSize;
        }
        return BigInteger.valueOf(nonZeroSize).multiply(BASE_NON_ZERO_GAS_LIMIT).add(BigInteger.valueOf(zeroSize).multiply(BASE_ZERO_GAS_LIMIT));
    }
}

