/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.protocol.core;

import com.alaya.utils.Async;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import rx.Observable;

public class RemoteCall<T> {
    private Callable<T> callable;

    public RemoteCall(Callable<T> callable) {
        this.callable = callable;
    }

    public T send() throws Exception {
        return this.callable.call();
    }

    public CompletableFuture<T> sendAsync() {
        return Async.run(this::send);
    }

    public Observable<T> observable() {
        return Observable.create(subscriber -> {
            try {
                subscriber.onNext(this.send());
                subscriber.onCompleted();
            }
            catch (Exception e) {
                subscriber.onError((Throwable)e);
            }
        });
    }
}

