/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.protocol.core.filters;

import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.Request;
import com.alaya.protocol.core.Response;
import com.alaya.protocol.core.filters.Callback;
import com.alaya.protocol.core.filters.FilterException;
import com.alaya.protocol.core.methods.response.PlatonFilter;
import com.alaya.protocol.core.methods.response.PlatonLog;
import com.alaya.protocol.core.methods.response.PlatonUninstallFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Filter<T> {
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    final Web3j web3j;
    final Callback<T> callback;
    private volatile BigInteger filterId;
    private ScheduledFuture<?> schedule;
    private ScheduledExecutorService scheduledExecutorService;
    private long blockTime;

    public Filter(Web3j web3j, Callback<T> callback) {
        this.web3j = web3j;
        this.callback = callback;
    }

    public void run(ScheduledExecutorService scheduledExecutorService, long blockTime) {
        try {
            PlatonFilter ethFilter = this.sendRequest();
            if (ethFilter.hasError()) {
                this.throwException(ethFilter.getError());
            }
            this.filterId = ethFilter.getFilterId();
            this.scheduledExecutorService = scheduledExecutorService;
            this.blockTime = blockTime;
            this.getInitialFilterLogs();
            this.schedule = scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    this.pollFilter(ethFilter);
                }
                catch (Throwable e) {
                    log.error("Error sending request", e);
                }
            }, 0L, blockTime, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void getInitialFilterLogs() {
        try {
            Optional<Request<?, PlatonLog>> maybeRequest = this.getFilterLogs(this.filterId);
            PlatonLog ethLog = null;
            if (maybeRequest.isPresent()) {
                ethLog = maybeRequest.get().send();
            } else {
                ethLog = new PlatonLog();
                ethLog.setResult(Collections.emptyList());
            }
            this.process(ethLog.getLogs());
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void pollFilter(PlatonFilter ethFilter) {
        Response ethLog = null;
        try {
            ethLog = this.web3j.platonGetFilterChanges(this.filterId).send();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (ethLog.hasError()) {
            Response.Error error = ethLog.getError();
            switch (error.getCode()) {
                case -32000: {
                    this.reinstallFilter();
                    break;
                }
                default: {
                    this.throwException(error);
                    break;
                }
            }
        } else {
            this.process(((PlatonLog)ethLog).getLogs());
        }
    }

    abstract PlatonFilter sendRequest() throws IOException;

    abstract void process(List<PlatonLog.LogResult> var1);

    private void reinstallFilter() {
        log.warn("The filter has not been found. Filter id: " + this.filterId);
        this.schedule.cancel(true);
        this.run(this.scheduledExecutorService, this.blockTime);
    }

    public void cancel() {
        this.schedule.cancel(false);
        try {
            PlatonUninstallFilter ethUninstallFilter = this.web3j.platonUninstallFilter(this.filterId).send();
            if (ethUninstallFilter.hasError()) {
                this.throwException(ethUninstallFilter.getError());
            }
            if (!ethUninstallFilter.isUninstalled()) {
                throw new FilterException("Filter with id '" + this.filterId + "' failed to uninstall");
            }
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    protected abstract Optional<Request<?, PlatonLog>> getFilterLogs(BigInteger var1);

    void throwException(Response.Error error) {
        throw new FilterException("Invalid request: " + (error == null ? "Unknown Error" : error.getMessage()));
    }

    void throwException(Throwable cause) {
        throw new FilterException("Error sending request", cause);
    }
}

