/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.tx;

import com.alaya.crypto.Credentials;
import com.alaya.protocol.Web3j;
import com.alaya.tx.RawTransactionManager;
import com.alaya.tx.response.TransactionReceiptProcessor;
import java.io.IOException;
import java.math.BigInteger;

public class FastRawTransactionManager
extends RawTransactionManager {
    private volatile BigInteger nonce = BigInteger.valueOf(-1L);

    public FastRawTransactionManager(Web3j web3j, Credentials credentials, long chainId) {
        super(web3j, credentials, chainId);
    }

    public FastRawTransactionManager(Web3j web3j, Credentials credentials, long chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(web3j, credentials, chainId, transactionReceiptProcessor);
    }

    @Override
    protected synchronized BigInteger getNonce() throws IOException {
        this.nonce = this.nonce.signum() == -1 ? super.getNonce() : this.nonce.add(BigInteger.ONE);
        return this.nonce;
    }

    public BigInteger getCurrentNonce() {
        return this.nonce;
    }

    public synchronized void resetNonce() throws IOException {
        this.nonce = super.getNonce();
    }

    public synchronized void setNonce(BigInteger value) {
        this.nonce = value;
    }
}

