/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.tx;

import com.alaya.crypto.Credentials;
import com.alaya.crypto.Hash;
import com.alaya.crypto.RawTransaction;
import com.alaya.crypto.TransactionEncoder;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.DefaultBlockParameterName;
import com.alaya.protocol.core.methods.response.PlatonGetTransactionCount;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.exceptions.TxHashMismatchException;
import com.alaya.tx.response.TransactionReceiptProcessor;
import com.alaya.utils.Numeric;
import com.alaya.utils.TxHashVerifier;
import java.io.IOException;
import java.math.BigInteger;

public class RawTransactionManager
extends TransactionManager {
    private final Web3j web3j;
    final Credentials credentials;
    private final long chainId;
    protected TxHashVerifier txHashVerifier = new TxHashVerifier();

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId) {
        super(web3j, credentials.getAddress(chainId));
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress(chainId));
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(Web3j web3j, Credentials credentials, long chainId, int attempts, long sleepDuration) {
        super(web3j, attempts, sleepDuration, credentials.getAddress(chainId));
        this.web3j = web3j;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    protected BigInteger getNonce() throws IOException {
        PlatonGetTransactionCount ethGetTransactionCount = this.web3j.platonGetTransactionCount(this.credentials.getAddress(this.chainId), DefaultBlockParameterName.PENDING).send();
        if (ethGetTransactionCount.getTransactionCount().intValue() == 0) {
            ethGetTransactionCount = this.web3j.platonGetTransactionCount(this.credentials.getAddress(this.chainId), DefaultBlockParameterName.LATEST).send();
        }
        return ethGetTransactionCount.getTransactionCount();
    }

    public TxHashVerifier getTxHashVerifier() {
        return this.txHashVerifier;
    }

    public void setTxHashVerifier(TxHashVerifier txHashVerifier) {
        this.txHashVerifier = txHashVerifier;
    }

    @Override
    public PlatonSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    public PlatonSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        String txHashRemote;
        String txHashLocal;
        byte[] signedMessage = this.chainId > -1L ? TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)this.chainId, (Credentials)this.credentials) : TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        PlatonSendTransaction ethSendTransaction = this.web3j.platonSendRawTransaction(hexValue).send();
        if (ethSendTransaction != null && !ethSendTransaction.hasError() && !this.txHashVerifier.verify(txHashLocal = Hash.sha3((String)hexValue), txHashRemote = ethSendTransaction.getTransactionHash())) {
            throw new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        return ethSendTransaction;
    }
}

