/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.tx;

import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.methods.response.PlatonSendTransaction;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.tx.response.PollingTransactionReceiptProcessor;
import com.alaya.tx.response.TransactionReceiptProcessor;
import java.io.IOException;
import java.math.BigInteger;

public abstract class TransactionManager {
    public static final int DEFAULT_POLLING_ATTEMPTS_PER_TX_HASH = 40;
    public static final long DEFAULT_POLLING_FREQUENCY = 2000L;
    private final TransactionReceiptProcessor transactionReceiptProcessor;
    private final String fromAddress;

    protected TransactionManager(TransactionReceiptProcessor transactionReceiptProcessor, String fromAddress) {
        this.transactionReceiptProcessor = transactionReceiptProcessor;
        this.fromAddress = fromAddress;
    }

    protected TransactionManager(Web3j web3j, String fromAddress) {
        this(new PollingTransactionReceiptProcessor(web3j, 2000L, 40), fromAddress);
    }

    protected TransactionManager(Web3j web3j, int attempts, long sleepDuration, String fromAddress) {
        this(new PollingTransactionReceiptProcessor(web3j, sleepDuration, attempts), fromAddress);
    }

    protected TransactionReceipt executeTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException, TransactionException {
        PlatonSendTransaction ethSendTransaction = this.sendTransaction(gasPrice, gasLimit, to, data, value);
        return this.processResponse(ethSendTransaction);
    }

    protected TransactionReceipt getTransactionReceipt(PlatonSendTransaction ethSendTransaction) throws IOException, TransactionException {
        return this.processResponse(ethSendTransaction);
    }

    public abstract PlatonSendTransaction sendTransaction(BigInteger var1, BigInteger var2, String var3, String var4, BigInteger var5) throws IOException;

    public String getFromAddress() {
        return this.fromAddress;
    }

    private TransactionReceipt processResponse(PlatonSendTransaction transactionResponse) throws IOException, TransactionException {
        if (transactionResponse.hasError()) {
            throw new RuntimeException("Error processing transaction request: " + transactionResponse.getError().getMessage());
        }
        String transactionHash = transactionResponse.getTransactionHash();
        return this.transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
    }
}

