/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.tx;

import com.alaya.crypto.Credentials;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.tx.ManagedTransaction;
import com.alaya.tx.RawTransactionManager;
import com.alaya.tx.TransactionManager;
import com.alaya.utils.Convert;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Transfer
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(21000L);

    public Transfer(Web3j web3j, TransactionManager transactionManager) {
        super(web3j, transactionManager);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit) throws IOException, InterruptedException, TransactionException {
        BigInteger gasPrice = this.requestCurrentGasPrice();
        return this.send(toAddress, value, unit, gasPrice, GAS_LIMIT);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) throws IOException, InterruptedException, TransactionException {
        BigDecimal weiValue = Convert.toVon((BigDecimal)value, (Convert.Unit)unit);
        if (!Numeric.isIntegerValue((BigDecimal)weiValue)) {
            throw new UnsupportedOperationException("Non decimal Wei value provided: " + value + " " + unit.toString() + " = " + weiValue + " Wei");
        }
        return this.send(toAddress, "", weiValue.toBigIntegerExact(), gasPrice, gasLimit);
    }

    public static RemoteCall<TransactionReceipt> sendFunds(Web3j web3j, Credentials credentials, long chainId, String toAddress, BigDecimal value, Convert.Unit unit) throws InterruptedException, IOException, TransactionException {
        RawTransactionManager transactionManager = new RawTransactionManager(web3j, credentials, chainId);
        return new RemoteCall<TransactionReceipt>(() -> new Transfer(web3j, transactionManager).send(toAddress, value, unit));
    }

    public RemoteCall<TransactionReceipt> sendFunds(String toAddress, BigDecimal value, Convert.Unit unit) {
        return new RemoteCall<TransactionReceipt>(() -> this.send(toAddress, value, unit));
    }

    public RemoteCall<TransactionReceipt> sendFunds(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) {
        return new RemoteCall<TransactionReceipt>(() -> this.send(toAddress, value, unit, gasPrice, gasLimit));
    }
}

