/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.tx;

import com.alaya.abi.wasm.WasmEventDecoder;
import com.alaya.abi.wasm.WasmEventEncoder;
import com.alaya.abi.wasm.WasmEventValues;
import com.alaya.abi.wasm.WasmFunctionEncoder;
import com.alaya.abi.wasm.WasmReturnDecoder;
import com.alaya.abi.wasm.datatypes.WasmEvent;
import com.alaya.abi.wasm.datatypes.WasmEventParameter;
import com.alaya.abi.wasm.datatypes.WasmFunction;
import com.alaya.crypto.Credentials;
import com.alaya.parameters.NetworkParameters;
import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.DefaultBlockParameter;
import com.alaya.protocol.core.DefaultBlockParameterName;
import com.alaya.protocol.core.RemoteCall;
import com.alaya.protocol.core.methods.request.Transaction;
import com.alaya.protocol.core.methods.response.Log;
import com.alaya.protocol.core.methods.response.PlatonCall;
import com.alaya.protocol.core.methods.response.PlatonGetCode;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.rlp.wasm.RLPCodec;
import com.alaya.rlp.wasm.RLPList;
import com.alaya.rlp.wasm.datatypes.Int;
import com.alaya.rlp.wasm.datatypes.Uint;
import com.alaya.tx.ManagedTransaction;
import com.alaya.tx.RawTransactionManager;
import com.alaya.tx.TransactionManager;
import com.alaya.tx.gas.GasProvider;
import com.alaya.utils.Numeric;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class WasmContract
extends ManagedTransaction {
    public static final String FUNC_DEPLOY = "deploy";
    protected final String contractBinary;
    protected String contractAddress;
    protected GasProvider gasProvider;
    protected TransactionReceipt transactionReceipt;
    protected Map<String, String> deployedAddresses;
    protected DefaultBlockParameter defaultBlockParameter = DefaultBlockParameterName.LATEST;
    protected long chainId;

    protected WasmContract(String contractBinary, String contractAddress, Web3j web3j, TransactionManager transactionManager, GasProvider gasProvider, long chainId) {
        super(web3j, transactionManager);
        this.contractAddress = contractAddress;
        this.contractBinary = contractBinary;
        this.gasProvider = gasProvider;
        this.chainId = chainId;
    }

    protected WasmContract(String contractBinary, String contractAddress, Web3j web3j, Credentials credentials, GasProvider gasProvider, long chainId) {
        this(contractBinary, contractAddress, web3j, new RawTransactionManager(web3j, credentials, chainId), gasProvider, chainId);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void setGasProvider(GasProvider gasProvider) {
        this.gasProvider = gasProvider;
    }

    public boolean isValid() throws IOException {
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart contract wrapper with web3j v2.2.0+");
        }
        PlatonGetCode ethGetCode = this.web3j.platonGetCode(this.contractAddress, DefaultBlockParameterName.LATEST).send();
        if (ethGetCode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix((String)ethGetCode.getCode());
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    public void setDefaultBlockParameter(DefaultBlockParameter defaultBlockParameter) {
        this.defaultBlockParameter = defaultBlockParameter;
    }

    protected <T> T executeCall(WasmFunction function, Class<T> clazz) throws IOException {
        String encodedFunction = WasmFunctionEncoder.encode((WasmFunction)function);
        PlatonCall ethCall = this.web3j.platonCall(Transaction.createEthCallTransaction(this.transactionManager.getFromAddress(), this.contractAddress, encodedFunction), this.defaultBlockParameter).send();
        String value = ethCall.getValue();
        if (null != function.getOutputParameterizedType()) {
            return (T)WasmReturnDecoder.decode((String)value, clazz, (ParameterizedType)function.getOutputParameterizedType(), (long)this.chainId);
        }
        return (T)WasmReturnDecoder.decode((String)value, clazz, (long)this.chainId);
    }

    protected <T> RemoteCall<T> executeRemoteCall(WasmFunction function, Class<T> returnType) {
        return new RemoteCall<Object>(() -> this.executeCall(function, returnType));
    }

    protected TransactionReceipt executeTransaction(WasmFunction function) throws IOException, TransactionException {
        return this.executeTransaction(function, BigInteger.ZERO);
    }

    private TransactionReceipt executeTransaction(WasmFunction function, BigInteger vonValue) throws IOException, TransactionException {
        String data = WasmFunctionEncoder.encode((WasmFunction)function);
        return this.executeTransaction(data, vonValue);
    }

    TransactionReceipt executeTransaction(String data, BigInteger vonValue) throws TransactionException, IOException {
        TransactionReceipt receipt = this.send(this.contractAddress, data, vonValue, this.gasProvider.getGasPrice(), this.gasProvider.getGasLimit());
        if (!receipt.isStatusOK()) {
            throw new TransactionException(String.format("Transaction has failed with status: %s. Gas used: %d. (not-enough gas?)", receipt.getStatus(), receipt.getGasUsed()));
        }
        return receipt;
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(WasmFunction function) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(WasmFunction function, BigInteger vonValue) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function, vonValue));
    }

    private static <T extends WasmContract> T create(T contract, String encodedConstructor, BigInteger value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(encodedConstructor, value);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends WasmContract> T deploy(Class<T> type, Web3j web3j, Credentials credentials, GasProvider contractGasProvider, String encodedConstructor, BigInteger value, long chainId) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, Credentials.class, GasProvider.class, Long.class);
            constructor.setAccessible(true);
            WasmContract contract = (WasmContract)constructor.newInstance(null, web3j, credentials, contractGasProvider, chainId);
            return (T)WasmContract.create(contract, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends WasmContract> T deploy(Class<T> type, Web3j web3j, TransactionManager transactionManager, GasProvider contractGasProvider, String encodedConstructor, BigInteger value, long chainId) throws RuntimeException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, Web3j.class, TransactionManager.class, GasProvider.class, Long.class);
            constructor.setAccessible(true);
            WasmContract contract = (WasmContract)constructor.newInstance(null, web3j, transactionManager, contractGasProvider, chainId);
            return (T)WasmContract.create(contract, encodedConstructor, value);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends WasmContract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, GasProvider contractGasProvider, String encodedConstructor, BigInteger value, long chainId) {
        return new RemoteCall<WasmContract>(() -> WasmContract.deploy(type, web3j, credentials, contractGasProvider, encodedConstructor, value, chainId));
    }

    public static <T extends WasmContract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, Credentials credentials, GasProvider contractGasProvider, String encodedConstructor, long chainId) {
        return new RemoteCall<WasmContract>(() -> WasmContract.deploy(type, web3j, credentials, contractGasProvider, encodedConstructor, BigInteger.ZERO, chainId));
    }

    public static <T extends WasmContract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, GasProvider contractGasProvider, String encodedConstructor, BigInteger value, long chainId) {
        return new RemoteCall<WasmContract>(() -> WasmContract.deploy(type, web3j, transactionManager, contractGasProvider, encodedConstructor, value, chainId));
    }

    public static <T extends WasmContract> RemoteCall<T> deployRemoteCall(Class<T> type, Web3j web3j, TransactionManager transactionManager, GasProvider contractGasProvider, String encodedConstructor, long chainId) {
        return new RemoteCall<WasmContract>(() -> WasmContract.deploy(type, web3j, transactionManager, contractGasProvider, encodedConstructor, BigInteger.ZERO, chainId));
    }

    public static WasmEventValues staticExtractEventParameters(WasmEvent event, Log log) {
        return WasmContract.staticExtractEventParameters(event, log, NetworkParameters.CurrentNetwork.getChainId());
    }

    public static WasmEventValues staticExtractEventParameters(WasmEvent event, Log log, long chainId) {
        String eventSignature = WasmEventEncoder.encode((WasmEvent)event);
        List<String> topics = log.getTopics();
        if (null == topics || topics.isEmpty() || !topics.get(0).equals(eventSignature)) {
            return null;
        }
        ArrayList<String> indexedValues = new ArrayList<String>();
        List indexedParameters = event.getIndexedParameters();
        if (null != indexedParameters && !indexedParameters.isEmpty()) {
            for (int i = 0; i < indexedParameters.size(); ++i) {
                String topicData = topics.get(i + 1);
                WasmEventParameter wasmEventParameter = (WasmEventParameter)indexedParameters.get(i);
                Class clazz = wasmEventParameter.getType();
                if (Uint.class.isAssignableFrom(clazz) || Int.class.isAssignableFrom(clazz)) {
                    try {
                        indexedValues.add(WasmEventDecoder.decodeIndexParameter((String)topicData, (Class)clazz).toString());
                    }
                    catch (Exception e) {
                        indexedValues.add(topicData);
                    }
                    continue;
                }
                indexedValues.add(topicData);
            }
        }
        ArrayList<Object> nonIndexedValues = new ArrayList<Object>();
        List nonIndexedParameters = event.getNonIndexedParameters();
        if (null != log.getData() && !log.getData().equals("")) {
            RLPList rlpList = (RLPList)RLPCodec.decode((byte[])Numeric.hexStringToByteArray((String)log.getData()), RLPList.class, (long)chainId);
            for (int i = 0; i < rlpList.size(); ++i) {
                WasmEventParameter wasmEventParameter = (WasmEventParameter)nonIndexedParameters.get(i);
                if (wasmEventParameter.getParameterizedType() == null) {
                    nonIndexedValues.add(RLPCodec.decode((byte[])rlpList.get(i).getEncoded(), (Class)wasmEventParameter.getType(), (long)chainId));
                    continue;
                }
                nonIndexedValues.add(RLPCodec.decodeContainer((byte[])rlpList.get(i).getEncoded(), (ParameterizedType)wasmEventParameter.getParameterizedType(), (long)chainId));
            }
        }
        return new WasmEventValues(indexedValues, nonIndexedValues);
    }

    protected WasmEventValuesWithLog extractEventParametersWithLog(WasmEvent event, Log log) {
        WasmEventValues eventValues = WasmContract.staticExtractEventParameters(event, log, this.chainId);
        return eventValues == null ? null : new WasmEventValuesWithLog(eventValues, log);
    }

    protected List<WasmEventValuesWithLog> extractEventParametersWithLog(WasmEvent event, TransactionReceipt transactionReceipt) {
        return transactionReceipt.getLogs().stream().map(log -> this.extractEventParametersWithLog(event, (Log)log)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    public static class WasmEventValuesWithLog {
        private final WasmEventValues eventValues;
        private final Log log;

        private WasmEventValuesWithLog(WasmEventValues eventValues, Log log) {
            this.eventValues = eventValues;
            this.log = log;
        }

        public List<String> getIndexedValues() {
            return this.eventValues.getIndexedValues();
        }

        public List<?> getNonIndexedValues() {
            return this.eventValues.getNonIndexedValues();
        }

        public Log getLog() {
            return this.log;
        }
    }
}

