/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.tx.response;

import com.alaya.protocol.Web3j;
import com.alaya.protocol.core.methods.response.TransactionReceipt;
import com.alaya.protocol.exceptions.NoTransactionReceiptException;
import com.alaya.protocol.exceptions.TransactionException;
import com.alaya.tx.response.TransactionReceiptProcessor;
import java.io.IOException;
import java.util.Optional;

public class PollingTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    private final long sleepDuration;
    private final int attempts;

    public PollingTransactionReceiptProcessor(Web3j web3j, long sleepDuration, int attempts) {
        super(web3j);
        this.sleepDuration = sleepDuration;
        this.attempts = attempts;
    }

    @Override
    public TransactionReceipt waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        return this.getTransactionReceipt(transactionHash, this.sleepDuration, this.attempts);
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash, long sleepDuration, int attempts) throws IOException, TransactionException {
        Optional<TransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts; ++i) {
            if (!receiptOptional.isPresent()) {
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw new TransactionException(e);
                }
            } else {
                return receiptOptional.get();
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        throw new NoTransactionReceiptException("Transaction receipt was not generated after " + sleepDuration * (long)attempts / 1000L + " seconds for transaction: " + transactionHash);
    }
}

