/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.utils;

import com.alaya.crypto.ECDSASignature;
import com.alaya.crypto.Hash;
import com.alaya.crypto.Sign;
import com.alaya.protocol.core.methods.response.PlatonBlock;
import com.alaya.rlp.solidity.RlpEncoder;
import com.alaya.rlp.solidity.RlpList;
import com.alaya.rlp.solidity.RlpString;
import com.alaya.rlp.solidity.RlpType;
import com.alaya.utils.Numeric;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class NodeIdTool {
    private NodeIdTool() {
    }

    public static String getPublicKey(PlatonBlock.Block block) {
        String publicKey = NodeIdTool.testBlock(block).toString(16);
        int lack = 128 - publicKey.length();
        if (lack <= 0) {
            return publicKey;
        }
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < lack; ++i) {
            prefix.append("0");
        }
        prefix.append(publicKey);
        return prefix.toString();
    }

    public static BigInteger testBlock(PlatonBlock.Block block) {
        String extraData = block.getExtraData();
        String signature = extraData.substring(66, extraData.length());
        byte[] msgHash = NodeIdTool.getMsgHash(block);
        byte[] signatureBytes = Numeric.hexStringToByteArray((String)signature);
        byte v = signatureBytes[64];
        byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
        byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
        return Sign.recoverFromSignature((int)v, (ECDSASignature)new ECDSASignature(new BigInteger(1, r), new BigInteger(1, s)), (byte[])msgHash);
    }

    private static byte[] getMsgHash(PlatonBlock.Block block) {
        byte[] signData = NodeIdTool.encode(block);
        return Hash.sha3((byte[])signData);
    }

    private static byte[] encode(PlatonBlock.Block block) {
        List<RlpType> values = NodeIdTool.asRlpValues(block);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode((RlpType)rlpList);
    }

    static List<RlpType> asRlpValues(PlatonBlock.Block block) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getParentHash())));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getMiner())));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getStateRoot())));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getTransactionsRoot())));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getReceiptsRoot())));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getLogsBloom())));
        result.add((RlpType)RlpString.create((BigInteger)block.getNumber()));
        result.add((RlpType)RlpString.create((BigInteger)block.getGasLimit()));
        result.add((RlpType)RlpString.create((BigInteger)block.getGasUsed()));
        result.add((RlpType)RlpString.create((BigInteger)block.getTimestamp()));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getExtraData().substring(0, 66))));
        result.add((RlpType)RlpString.create((byte[])NodeIdTool.decodeHash(block.getNonceRaw())));
        return result;
    }

    static byte[] decodeHash(String hex) {
        return Hex.decode((String)Numeric.cleanHexPrefix((String)hex));
    }
}

