/*
 * Decompiled with CFR 0.152.
 */
package com.alaya.utils;

import java.math.BigInteger;
import rx.Observable;

public class Observables {
    public static Observable<BigInteger> range(BigInteger startValue, BigInteger endValue) {
        return Observables.range(startValue, endValue, true);
    }

    public static Observable<BigInteger> range(BigInteger startValue, BigInteger endValue, boolean ascending) {
        if (startValue.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("Negative start index cannot be used");
        }
        if (startValue.compareTo(endValue) > 0) {
            throw new IllegalArgumentException("Negative start index cannot be greater then end index");
        }
        if (ascending) {
            return Observable.create(subscriber -> {
                BigInteger i = startValue;
                while (i.compareTo(endValue) < 1 && !subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)i);
                    i = i.add(BigInteger.ONE);
                }
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onCompleted();
                }
            });
        }
        return Observable.create(subscriber -> {
            BigInteger i = endValue;
            while (i.compareTo(startValue) > -1 && !subscriber.isUnsubscribed()) {
                subscriber.onNext((Object)i);
                i = i.subtract(BigInteger.ONE);
            }
            if (!subscriber.isUnsubscribed()) {
                subscriber.onCompleted();
            }
        });
    }
}

